/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querybuilder;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.sql.visualeditor.Log;
import org.netbeans.modules.db.sql.visualeditor.api.VisualSQLEditorMetaData;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.InternalVSEMetaDataImpl;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilder;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Column;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryBuilderMetaData {
    private Hashtable importKcTable = new Hashtable();
    private Hashtable allColumnNames = null;
    private VisualSQLEditorMetaData metadata;
    private QueryBuilder queryBuilder;
    private boolean DEBUG = false;

    QueryBuilderMetaData(VisualSQLEditorMetaData visualSQLEditorMetaData, QueryBuilder queryBuilder) {
        this.metadata = visualSQLEditorMetaData;
        this.queryBuilder = queryBuilder;
    }

    QueryBuilderMetaData(DatabaseConnection databaseConnection, QueryBuilder queryBuilder) {
        this.metadata = new InternalVSEMetaDataImpl(databaseConnection);
        this.queryBuilder = queryBuilder;
    }

    boolean isSchemaName(String string) {
        List<String> list = this.getSchemas();
        if (list.contains(string)) {
            Log.getLogger().finest(" found schema name " + string);
            return true;
        }
        return false;
    }

    boolean isTableName(String string) {
        try {
            String string2 = this.checkTableName(string);
            if (string2 != null) {
                return true;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    boolean isColumnName(String string) {
        try {
            if (this.allColumnNames == null) {
                this.getAllColumnNames();
            }
            return this.allColumnNames.containsKey(string);
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    void getAllColumnNames() throws SQLException {
        this.allColumnNames = new Hashtable(500);
        List<List<String>> list = this.getTables();
        for (List<String> list2 : list) {
            List<String> list3 = this.getColumns(list2.get(0), list2.get(1));
            for (String string : list3) {
                this.allColumnNames.put(string, string);
            }
        }
    }

    String checkTableName(String string) throws SQLException {
        Log.getLogger().entering("QueryBuilderMetaData", "checkTableName", string);
        if (string == null || string.length() < 1) {
            return string;
        }
        String[] stringArray = QueryBuilderMetaData.parseTableName(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        if (string2 != null) {
            return this.checkFullTableName(string);
        }
        String string4 = null;
        List<String> list = this.getAllTables();
        for (String string5 : list) {
            String string6 = QueryBuilderMetaData.parseTableName(string5)[1];
            if (!string6.equalsIgnoreCase(string3)) continue;
            string4 = string5;
            break;
        }
        if (string4 == null) {
            String string7 = this.queryBuilder.getQueryModel().getFullTableName(string3);
            if (string7 != null && string.equals(string7)) {
                return null;
            }
            if (string7 != null) {
                return this.checkTableName(string7);
            }
        }
        if (string4 != null) {
            this.getColumnNames(string4);
        }
        return string4;
    }

    String checkFullTableName(String string) throws SQLException {
        Log.getLogger().entering("QueryBuilderMetaData", "checkFullTableName", string);
        String string2 = null;
        if (QueryBuilderMetaData.parseTableName(string)[0] == null) {
            return this.checkTableName(string);
        }
        List<String> list = this.getAllTables();
        for (String string3 : list) {
            if (!string3.equalsIgnoreCase(string)) continue;
            string2 = string3;
            break;
        }
        if (string2 != null) {
            this.getColumnNames(string2);
        }
        return string2;
    }

    String checkColumnName(String string, String string2) throws SQLException {
        Log.getLogger().entering("QueryBuilderMetaData", "checkColumnName", new Object[]{string, string2});
        String string3 = this.checkTableName(string);
        List list = this.getColumnNames(string3);
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            String string4 = (String)list.get(i);
            if (string2.equals(string4)) {
                return string2;
            }
            if (!string2.equalsIgnoreCase(string4)) continue;
            return string4;
        }
        return null;
    }

    boolean checkColumnNameForTable(Column column, String string) {
        boolean bl;
        block7: {
            List list;
            String string2;
            String string3;
            block6: {
                string3 = column.getColumnName();
                Log.getLogger().entering("QueryBuilderMetaData", "checkColumnNameForTable", string);
                String string4 = this.queryBuilder.getQueryModel().getFullTableName(string);
                if (string4 != null) {
                    string = string4;
                }
                bl = false;
                try {
                    string2 = this.checkTableName(string);
                    if (string2 == null) {
                        return false;
                    }
                    list = this.getColumnNames(string2);
                }
                catch (SQLException sQLException) {
                    Log.getLogger().finest("  ** problems getting metadata " + sQLException.getMessage());
                    return false;
                }
                if (!"*".equals(string3)) break block6;
                bl = true;
                if (string4 != null || string2.equals(column.getTableSpec())) break block7;
                column.setTableSpec(column.getTableSpec(), string2);
                Log.getLogger().finest(" adjust table to " + string2);
                break block7;
            }
            for (int i = 0; i < list.size(); ++i) {
                if (!string3.equalsIgnoreCase((String)list.get(i))) continue;
                column.setColumnName(column.getColumnName(), (String)list.get(i));
                Log.getLogger().finest(" adjust colname to " + (String)list.get(i));
                if (column.getTableSpec() == null) {
                    column.setTableSpec(column.getTableSpec(), string2);
                    Log.getLogger().finest(" adjust table to " + string2);
                }
                bl = true;
                break;
            }
        }
        Log.getLogger().finest("checkColumnNameForTable found=" + bl);
        return bl;
    }

    boolean checkTableColumnName(Column column) throws SQLException {
        String string = column.getTableSpec();
        String string2 = column.getFullTableName();
        String string3 = column.getColumnName();
        Log.getLogger().finest("checkTableColunName col=*, notable  tableSpec = " + string + " tableName = " + string2 + " . " + string3);
        if ("*".equals(column.getColumnName()) && string == null) {
            Log.getLogger().finest("checkTableColunName col=*, notable ");
            return true;
        }
        String string4 = this.checkTableName(string);
        String string5 = null;
        string5 = this.queryBuilder.getQueryModel().getFullTableName(string);
        Log.getLogger().finest("checkTableColumnName called.  checkedTableName = " + string4 + " fullTableNameFromAlias = " + string5);
        if (string4 == null) {
            return false;
        }
        if (string5 != null && !string5.equalsIgnoreCase(string)) {
            if (this.DEBUG) {
                System.out.println("setColumnTableName called.  checkedTableName = " + string4 + " tableSpec = " + string + " fullTableNameFromAlias = " + string5 + "\n");
            }
            column.setColumnTableName(string4);
            column.setColumnCorrName(string);
        } else if (!string4.equals(string2)) {
            if (this.DEBUG) {
                System.out.println("setTableSpec called.  checkedTableName = " + string4 + "\n");
            }
            column.setTableSpec(string2, string4);
        }
        String string6 = column.getColumnName();
        if (string6.equals("*")) {
            return true;
        }
        String string7 = this.checkColumnName(string4, string6);
        if (this.DEBUG) {
            System.out.println("column Name = " + string6 + "\n" + "checked column Name = " + string7 + "\n");
        }
        if (string7 == null) {
            return false;
        }
        if (!string7.equals(string6)) {
            if (this.DEBUG) {
                System.out.println("set column name called. oldColumnName = " + string6 + " newColumnName = " + string7 + "\n");
            }
            column.setColumnName(string6, string7);
        }
        return true;
    }

    List<String> getAllTables() throws SQLException {
        List<List<String>> list = this.getTables();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (List<String> list2 : list) {
            String string = list2.get(0);
            String string2 = list2.get(1);
            arrayList.add(string == null || string.equals("") ? string2 : string + "." + string2);
        }
        return arrayList;
    }

    List getImportedKeyColumns(String string) throws SQLException {
        ArrayList<String> arrayList = (ArrayList<String>)this.importKcTable.get(string);
        if (arrayList != null) {
            return arrayList;
        }
        String[] stringArray = QueryBuilderMetaData.parseTableName(string);
        List<List<String>> list = this.getImportedKeys(stringArray[0], stringArray[1]);
        arrayList = new ArrayList<String>();
        for (List<String> list2 : list) {
            arrayList.add(list2.get(1));
        }
        this.importKcTable.put(string, arrayList);
        return arrayList;
    }

    List getForeignKeys(String string) throws SQLException {
        Log.getLogger().entering("QueryBuilderMetaData", "getForeignKeys", string);
        String[] stringArray = QueryBuilderMetaData.parseTableName(string);
        List<List<String>> list = this.getImportedKeys(stringArray[0], stringArray[1]);
        list.addAll(this.getExportedKeys(stringArray[0], stringArray[1]));
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        for (List<String> list2 : list) {
            arrayList.add(list2.toArray());
        }
        return arrayList;
    }

    String[] findForeignKey(String string, String string2, List list) {
        Log.getLogger().entering("QueryBuilderMetaData", "findForeignKey", new Object[]{string, string2});
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String[] stringArray = (String[])list.get(i);
                if ((!stringArray[0].equalsIgnoreCase(string2) || !stringArray[2].equalsIgnoreCase(string)) && (!stringArray[0].equalsIgnoreCase(string) || !stringArray[2].equalsIgnoreCase(string2))) continue;
                return (String[])list.get(i);
            }
        }
        Log.getLogger().finest("No key found");
        return null;
    }

    String[] findForeignKey(String string, String string2, String string3, String string4) throws SQLException {
        Log.getLogger().entering("QueryBuilderMetaData", "findForeignKey", new Object[]{string, string2, string, string4});
        List list = this.getForeignKeys(string);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String[] stringArray = (String[])list.get(i);
                if ((!stringArray[0].equalsIgnoreCase(string) || !stringArray[1].equalsIgnoreCase(string2) || !stringArray[2].equalsIgnoreCase(string3) || !stringArray[3].equalsIgnoreCase(string4)) && (!stringArray[0].equalsIgnoreCase(string3) || !stringArray[1].equalsIgnoreCase(string4) || !stringArray[2].equalsIgnoreCase(string) || !stringArray[3].equalsIgnoreCase(string2))) continue;
                return (String[])list.get(i);
            }
        }
        Log.getLogger().finest("No key found");
        return null;
    }

    public void getColumnNames(String string, List list) {
        try {
            list.addAll(this.getColumnNames(string));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public List getColumnNames(String string) throws SQLException {
        String[] stringArray = QueryBuilderMetaData.parseTableName(string);
        return this.getColumns(stringArray[0], stringArray[1]);
    }

    List getPrimaryKeys(String string) throws SQLException {
        String string2;
        Log.getLogger().entering("QueryBuilderMetaData", "getPrimaryKeys", string);
        String string3 = null;
        String[] stringArray = QueryBuilderMetaData.parseTableName(string);
        if (stringArray.length > 1) {
            string3 = stringArray[0];
            string2 = stringArray[1];
        } else {
            string2 = stringArray[0];
        }
        return this.getPrimaryKeys(string3, string2);
    }

    List<String> getSchemas() {
        return this.metadata.getSchemas();
    }

    List<List<String>> getTables() throws SQLException {
        return this.metadata.getTables();
    }

    List<String> getPrimaryKeys(String string, String string2) throws SQLException {
        return this.metadata.getPrimaryKeys(string, string2);
    }

    List<List<String>> getImportedKeys(String string, String string2) throws SQLException {
        return this.metadata.getImportedKeys(string, string2);
    }

    List<List<String>> getExportedKeys(String string, String string2) throws SQLException {
        return this.metadata.getExportedKeys(string, string2);
    }

    List<String> getColumns(String string, String string2) throws SQLException {
        return this.metadata.getColumns(string, string2);
    }

    public String getIdentifierQuoteString() {
        try {
            return this.metadata.getIdentifierQuoteString();
        }
        catch (SQLException sQLException) {
            return "";
        }
    }

    void checkDatabaseConnection() throws SQLException {
    }

    private static String[] parseTableName(String string) {
        String[] stringArray = new String[2];
        String[] stringArray2 = string.split("\\.");
        if (stringArray2.length > 1) {
            stringArray[0] = stringArray2[0];
            stringArray[1] = stringArray2[1];
        } else {
            stringArray[0] = null;
            stringArray[1] = stringArray2[0];
        }
        return stringArray;
    }
}

