/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.fill.JRAbstractLRUVirtualizer;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.fill.VirtualizationObjectInputStream;
import net.sf.jasperreports.engine.fill.VirtualizationObjectOutputStream;

public class VirtualizationSerializer {
    protected static final int CLASSLOADER_IDX_NOT_SET = -1;
    protected final Map<ClassLoader, Integer> classLoadersIndexes = new HashMap<ClassLoader, Integer>();
    protected final List<ClassLoader> classLoadersList = new ArrayList<ClassLoader>();

    protected static boolean isAncestorClassLoader(ClassLoader loader) {
        for (ClassLoader ancestor = JRAbstractLRUVirtualizer.class.getClassLoader(); ancestor != null; ancestor = ancestor.getParent()) {
            if (!ancestor.equals(loader)) continue;
            return true;
        }
        return false;
    }

    public final void writeData(JRVirtualizable o, OutputStream out) throws IOException {
        ClassLoaderAnnotationObjectOutputStream oos = new ClassLoaderAnnotationObjectOutputStream(out, o.getContext());
        oos.writeObject(o.getVirtualData());
        oos.flush();
    }

    public final void readData(JRVirtualizable o, InputStream in) throws IOException {
        ClassLoaderAnnotationObjectInputStream ois = new ClassLoaderAnnotationObjectInputStream(in, o.getContext());
        try {
            o.setVirtualData(ois.readObject());
        }
        catch (ClassNotFoundException e) {
            throw new JRRuntimeException("Error deserializing virtualized object", e);
        }
    }

    protected class ClassLoaderAnnotationObjectInputStream
    extends VirtualizationObjectInputStream {
        public ClassLoaderAnnotationObjectInputStream(InputStream in, JRVirtualizationContext virtualizationContext) throws IOException {
            super(in, virtualizationContext);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            Class<?> clazz;
            try {
                clazz = super.resolveClass(desc);
                this.readShort();
            }
            catch (ClassNotFoundException e) {
                short loaderIdx = this.readShort();
                if (loaderIdx == -1) {
                    throw e;
                }
                ClassLoader loader = VirtualizationSerializer.this.classLoadersList.get(loaderIdx);
                clazz = Class.forName(desc.getName(), false, loader);
            }
            return clazz;
        }
    }

    protected class ClassLoaderAnnotationObjectOutputStream
    extends VirtualizationObjectOutputStream {
        public ClassLoaderAnnotationObjectOutputStream(OutputStream out, JRVirtualizationContext virtualizationContext) throws IOException {
            super(out, virtualizationContext);
        }

        @Override
        protected void annotateClass(Class<?> clazz) throws IOException {
            int loaderIdx;
            super.annotateClass(clazz);
            ClassLoader classLoader = clazz.getClassLoader();
            if (clazz.isPrimitive() || classLoader == null || VirtualizationSerializer.isAncestorClassLoader(classLoader)) {
                loaderIdx = -1;
            } else {
                Integer idx = VirtualizationSerializer.this.classLoadersIndexes.get(classLoader);
                if (idx == null) {
                    idx = VirtualizationSerializer.this.classLoadersList.size();
                    VirtualizationSerializer.this.classLoadersIndexes.put(classLoader, idx);
                    VirtualizationSerializer.this.classLoadersList.add(classLoader);
                }
                loaderIdx = idx;
            }
            this.writeShort(loaderIdx);
        }
    }
}

