/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc.impl;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.CalcWriter;
import mondrian.calc.ResultStyle;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.type.Type;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCalc
implements Calc {
    private final Calc[] calcs;
    protected final Type type;
    protected final Exp exp;

    protected AbstractCalc(Exp exp, Calc[] calcs) {
        assert (exp != null);
        this.exp = exp;
        this.calcs = calcs;
        this.type = exp.getType();
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void accept(CalcWriter calcWriter) {
        PrintWriter pw = calcWriter.getWriter();
        String name = this.getName();
        pw.print(name);
        Calc[] calcs = this.getCalcs();
        List<Object> argumentList = this.getArguments();
        if (calcs.length > 0 || !argumentList.isEmpty()) {
            pw.print("(");
            int k = 0;
            for (Calc calc : calcs) {
                if (k++ > 0) {
                    pw.print(", ");
                }
                calc.accept(calcWriter);
            }
            for (Object o : argumentList) {
                if (k++ > 0) {
                    pw.print(", ");
                }
                pw.print(o);
            }
            pw.print(")");
        }
    }

    protected String getName() {
        String name;
        if (this.exp instanceof ResolvedFunCall) {
            ResolvedFunCall funCall = (ResolvedFunCall)this.exp;
            name = funCall.getFunDef().getName();
        } else {
            int dollar;
            name = this.getClass().getName();
            int dot = name.lastIndexOf(46);
            int dotDollar = Math.max(dot, dollar = name.lastIndexOf(36));
            if (dotDollar >= 0) {
                name = name.substring(dotDollar + 1);
            }
        }
        return name;
    }

    public Calc[] getCalcs() {
        return this.calcs;
    }

    @Override
    public boolean dependsOn(Hierarchy hierarchy) {
        return AbstractCalc.anyDepends(this.getCalcs(), hierarchy);
    }

    public static boolean anyDepends(Calc[] calcs, Hierarchy hierarchy) {
        for (Calc calc : calcs) {
            if (calc == null || !calc.dependsOn(hierarchy)) continue;
            return true;
        }
        return false;
    }

    public static boolean anyDependsButFirst(Calc[] calcs, Hierarchy hierarchy) {
        if (calcs.length == 0) {
            return false;
        }
        if (calcs[0].dependsOn(hierarchy)) {
            return true;
        }
        if (calcs[0].getType().usesHierarchy(hierarchy, true)) {
            return false;
        }
        for (int i = 1; i < calcs.length; ++i) {
            Calc calc = calcs[i];
            if (calc == null || !calc.dependsOn(hierarchy)) continue;
            return true;
        }
        return false;
    }

    public static boolean butDepends(Calc[] calcs, Hierarchy hierarchy) {
        boolean result = true;
        for (Calc calc : calcs) {
            if (calc == null) continue;
            if (calc.dependsOn(hierarchy)) {
                return true;
            }
            if (!calc.getType().usesHierarchy(hierarchy, true)) continue;
            result = false;
        }
        return result;
    }

    public List<Object> getArguments() {
        return Collections.emptyList();
    }

    public static Evaluator simplifyEvaluator(Calc calc, Evaluator evaluator) {
        if (evaluator.isNonEmpty()) {
            return evaluator;
        }
        int changeCount = 0;
        Evaluator ev = evaluator;
        List<RolapHierarchy> hierarchies = ((RolapEvaluator)evaluator).getCube().getHierarchies();
        for (RolapHierarchy hierarchy : hierarchies) {
            Member unconstrainedMember;
            Member member = ev.getContext(hierarchy);
            if (member.isAll() || calc.dependsOn(hierarchy) || member == (unconstrainedMember = member.getHierarchy().getDefaultMember())) continue;
            if (changeCount++ == 0) {
                ev = evaluator.push(unconstrainedMember);
                continue;
            }
            ev.setContext(unconstrainedMember);
        }
        return ev;
    }

    @Override
    public ResultStyle getResultStyle() {
        return ResultStyle.VALUE;
    }
}

