/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.StringCalc;
import mondrian.calc.impl.AbstractHierarchyCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.OlapElement;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.type.HierarchyType;
import mondrian.olap.type.Type;

class DimensionsStringFunDef
extends FunDefBase {
    public static final FunDefBase INSTANCE = new DimensionsStringFunDef();

    private DimensionsStringFunDef() {
        super("Dimensions", "Returns the hierarchy whose name is specified by a string.", "fhS");
    }

    public Type getResultType(Validator validator, Exp[] args) {
        return HierarchyType.Unknown;
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final StringCalc stringCalc = compiler.compileString(call.getArg(0));
        return new AbstractHierarchyCalc(call, new Calc[]{stringCalc}){

            public Hierarchy evaluateHierarchy(Evaluator evaluator) {
                String dimensionName = stringCalc.evaluateString(evaluator);
                return DimensionsStringFunDef.this.findHierarchy(dimensionName, evaluator);
            }
        };
    }

    Hierarchy findHierarchy(String name, Evaluator evaluator) {
        OlapElement o;
        if (name.indexOf("[") == -1) {
            name = Util.quoteMdxIdentifier(name);
        }
        if ((o = evaluator.getSchemaReader().lookupCompound(evaluator.getCube(), DimensionsStringFunDef.parseIdentifier(name), false, 3)) instanceof Hierarchy) {
            return (Hierarchy)o;
        }
        if (o == null) {
            throw DimensionsStringFunDef.newEvalException(this, "Hierarchy '" + name + "' not found");
        }
        throw DimensionsStringFunDef.newEvalException(this, "Hierarchy(" + name + ") found " + o);
    }
}

