/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.type;

import java.util.List;
import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Util;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;

public class SetType
implements Type {
    private final Type elementType;
    private final String digest;

    public SetType(Type elementType) {
        if (elementType != null) assert (elementType instanceof MemberType || elementType instanceof TupleType);
        this.elementType = elementType;
        this.digest = "SetType<" + elementType + ">";
    }

    public int hashCode() {
        return this.digest.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SetType) {
            SetType that = (SetType)obj;
            return Util.equals(this.elementType, that.elementType);
        }
        return false;
    }

    public String toString() {
        return this.digest;
    }

    public Type getElementType() {
        return this.elementType;
    }

    public boolean usesDimension(Dimension dimension, boolean definitely) {
        if (this.elementType == null) {
            return definitely;
        }
        return this.elementType.usesDimension(dimension, definitely);
    }

    public boolean usesHierarchy(Hierarchy hierarchy, boolean definitely) {
        if (this.elementType == null) {
            return definitely;
        }
        return this.elementType.usesHierarchy(hierarchy, definitely);
    }

    public Dimension getDimension() {
        return this.elementType == null ? null : this.elementType.getDimension();
    }

    public Hierarchy getHierarchy() {
        return this.elementType == null ? null : this.elementType.getHierarchy();
    }

    public Level getLevel() {
        return this.elementType == null ? null : this.elementType.getLevel();
    }

    public int getArity() {
        return this.elementType instanceof TupleType ? ((TupleType)this.elementType).elementTypes.length : 1;
    }

    public Type computeCommonType(Type type, int[] conversionCount) {
        if (!(type instanceof SetType)) {
            return null;
        }
        SetType that = (SetType)type;
        Type mostGeneralElementType = this.getElementType().computeCommonType(that.getElementType(), conversionCount);
        if (mostGeneralElementType == null) {
            return null;
        }
        return new SetType(mostGeneralElementType);
    }

    public boolean isInstance(Object value) {
        if (!(value instanceof List)) {
            return false;
        }
        List list = (List)value;
        for (Object o : list) {
            if (this.elementType.isInstance(o)) continue;
            return false;
        }
        return true;
    }
}

