/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.mongodb.connection;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.mongodb.connection.MongoDbConnection;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.openide.util.NbBundle;

public class MongoDbConnectionEditor
extends JPanel
implements IReportConnectionEditor {
    private JTextField urlField;
    private JTextField usernameField;
    private JPasswordField passwordField;

    public MongoDbConnectionEditor() {
        this.initComponents();
    }

    private void initComponents() {
        JPanel propertiesPanel = new JPanel(new GridBagLayout());
        this.addLabel(propertiesPanel, "uri", 0, 0, 0.0, 1.0);
        this.urlField = new JTextField("mongodb://HOST:27017/DB_NAME");
        this.addComponent(propertiesPanel, this.urlField, 1, 0, 0.95, 1.0, 20, 2, 2);
        this.addComponent(propertiesPanel, Box.createHorizontalBox(), 2, 0, 0.05, 1.0, 20, 2, 1);
        this.addLabel(propertiesPanel, "username", 0, 1, 0.0, 0.0);
        this.usernameField = new JTextField(10);
        this.addComponent(propertiesPanel, this.usernameField, 1, 1, 0.6, 0.0, 10, 2, 1);
        this.addComponent(propertiesPanel, Box.createHorizontalBox(), 2, 1, 0.1, 1.0, 20, 0, 1);
        this.addComponent(propertiesPanel, Box.createHorizontalBox(), 3, 1, 0.3, 1.0, 0, 2, 1);
        this.addLabel(propertiesPanel, "password", 0, 2, 0.0, 0.0);
        this.passwordField = new JPasswordField(10);
        this.addComponent(propertiesPanel, this.passwordField, 1, 2, 0.5, 0.0, 0, 2, 1);
        this.addComponent(propertiesPanel, Box.createHorizontalBox(), 2, 2, 0.1, 1.0, 0, 0, 1);
        this.addComponent(propertiesPanel, Box.createHorizontalBox(), 3, 2, 0.4, 1.0, 0, 2, 1);
        GridBagConstraints contraints = new GridBagConstraints();
        contraints.gridx = 0;
        contraints.gridy = 0;
        contraints.fill = 2;
        contraints.anchor = 17;
        this.setLayout(new GridBagLayout());
        this.add((Component)propertiesPanel, contraints);
        contraints = new GridBagConstraints();
        contraints.gridx = 0;
        contraints.gridy = 1;
        contraints.fill = 0;
        contraints.anchor = 17;
        contraints.weightx = 1.0;
        contraints.weighty = 1.0;
        JPanel panel = new JPanel();
        this.add((Component)panel, contraints);
    }

    private void addLabel(JPanel panel, String fieldName, int gridx, int gridy, double weightx, double weighty) {
        JLabel urlLabel = new JLabel(NbBundle.getMessage(MongoDbConnection.class, (String)fieldName));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = gridx;
        constraints.gridy = gridy;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 5, 2, 5);
        constraints.anchor = 17;
        constraints.weightx = weightx;
        constraints.weighty = weighty;
        panel.add((Component)urlLabel, constraints);
    }

    private void addComponent(JPanel panel, JComponent component, int gridx, int gridy, double weightx, double weighty, int ipadx, int fill, int gridwidth) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = gridx;
        constraints.gridy = gridy;
        constraints.fill = fill;
        constraints.anchor = 17;
        constraints.insets = new Insets(2, 5, 5, 5);
        constraints.ipadx = ipadx;
        constraints.weightx = weightx;
        constraints.weighty = weighty;
        constraints.gridwidth = gridwidth;
        panel.add((Component)component, constraints);
    }

    public IReportConnection getIReportConnection() {
        MongoDbConnection connection = new MongoDbConnection();
        connection.setMongoURI(this.urlField.getText().trim());
        connection.setUsername(this.usernameField.getText().trim());
        connection.setPassword(new String(this.passwordField.getPassword()).trim());
        return connection;
    }

    public void setIReportConnection(IReportConnection connection) {
        if (connection instanceof MongoDbConnection) {
            this.urlField.setText(((MongoDbConnection)connection).getMongoURI());
            this.usernameField.setText(((MongoDbConnection)connection).getUsername());
            this.passwordField.setText(((MongoDbConnection)connection).getPassword());
        }
    }
}

