/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.map;

import com.jaspersoft.ireport.designer.editor.ExpObjectCellRenderer;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.editor.ExpressionEditorArea;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import net.sf.jasperreports.components.map.MarkerProperty;
import net.sf.jasperreports.components.map.StandardMarkerProperty;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardMarkerDialog
extends JDialog {
    StandardMarkerProperty tmpProperty = null;
    private String oldName = null;
    private List<String> currentPropertyNames = null;
    public static final String[] MARKER_PROPERTIES = new String[]{"latitude", "longitude"};
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JCheckBox jCheckBox1;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabelValue;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelValue;
    private ExpressionEditorArea jRTextExpressionValueExpression;
    private JScrollPane jScrollPaneValue;
    private JSeparator jSeparator1;
    private JTextArea jTextArea1;
    private int dialogResult;

    public StandardMarkerDialog(Dialog parent, List<MarkerProperty> currentProperties) {
        super(parent);
        this.initAll(currentProperties);
    }

    public StandardMarkerDialog(Frame parent, List<MarkerProperty> currentProperties) {
        super(parent);
        this.initAll(currentProperties);
    }

    public void initAll(List<MarkerProperty> currentProperties) {
        this.setModal(true);
        this.initComponents();
        this.currentPropertyNames = new ArrayList<String>();
        for (MarkerProperty p : currentProperties) {
            this.currentPropertyNames.add(p.getName());
        }
        this.jRTextExpressionValueExpression.setText("");
        this.jComboBox1.setModel(new DefaultComboBoxModel());
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(MARKER_PROPERTIES));
        this.jComboBox1.setRenderer(new ExpObjectCellRenderer());
        this.setLocationRelativeTo(null);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                StandardMarkerDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, I18n.getString((String)"Global.Pane.Escape"));
        this.getRootPane().getActionMap().put(I18n.getString((String)"Global.Pane.Escape"), escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jScrollPaneValue = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jCheckBox1 = new JCheckBox();
        this.jLabelValue = new JLabel();
        this.jPanelValue = new JPanel();
        this.jRTextExpressionValueExpression = new ExpressionEditorArea();
        this.jSeparator1 = new JSeparator();
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPaneValue.setViewportView(this.jTextArea1);
        this.setTitle("Add/modify property");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                StandardMarkerDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StandardMarkerDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StandardMarkerDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel2.setPreferredSize(new Dimension(350, 250));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setText("Property Name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.jComboBox1.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel2.add((Component)this.jComboBox1, gridBagConstraints);
        this.jCheckBox1.setSelected(true);
        this.jCheckBox1.setText("Use an expression");
        this.jCheckBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StandardMarkerDialog.this.jCheckBox1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jCheckBox1, gridBagConstraints);
        this.jLabelValue.setText("Value / Expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.jLabelValue, gridBagConstraints);
        this.jPanelValue.setLayout(new BorderLayout());
        this.jRTextExpressionValueExpression.setPreferredSize(new Dimension(300, 80));
        this.jPanelValue.add((Component)this.jRTextExpressionValueExpression, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jPanelValue, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(2, 2));
        this.jSeparator1.setPreferredSize(new Dimension(2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanel2.add((Component)this.jSeparator1, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.setBounds(0, 0, 595, 494);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String propretyName = this.jComboBox1.getSelectedItem() + "";
        if (propretyName == null || propretyName.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "Invalid Property", "Please specify a valid property name", 2);
            return;
        }
        if (this.oldName != null && !this.oldName.equals(propretyName) && this.currentPropertyNames != null && this.currentPropertyNames.contains(propretyName)) {
            JOptionPane.showMessageDialog(this, "Duplicated Property", "A property with this name already exists", 2);
            return;
        }
        this.tmpProperty = new StandardMarkerProperty();
        this.tmpProperty.setName(propretyName);
        if (this.jCheckBox1.isSelected()) {
            JRDesignExpression exp = new JRDesignExpression();
            exp.setText(this.jRTextExpressionValueExpression.getText());
            this.tmpProperty.setValueExpression((JRExpression)exp);
        } else {
            this.tmpProperty.setValue(this.jTextArea1.getText());
        }
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.jPanelValue.removeAll();
        if (!this.jCheckBox1.isSelected()) {
            this.jPanelValue.add((Component)this.jScrollPaneValue, "Center");
        } else {
            this.jPanelValue.add((Component)this.jRTextExpressionValueExpression, "Center");
        }
        this.jPanelValue.updateUI();
    }

    public StandardMarkerProperty getProperty() {
        return this.tmpProperty;
    }

    public void setProperty(StandardMarkerProperty tmpProperty) {
        this.jComboBox1.setSelectedItem(tmpProperty.getName());
        this.oldName = tmpProperty.getName();
        this.jTextArea1.setText(tmpProperty.getValue());
        this.jRTextExpressionValueExpression.setText(Misc.getExpressionText((JRExpression)tmpProperty.getValueExpression()));
        this.jCheckBox1.setSelected(tmpProperty.getValue() == null);
        this.jCheckBox1ActionPerformed(null);
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void setExpressionContext(ExpressionContext context) {
        this.jRTextExpressionValueExpression.setExpressionContext(context);
    }
}

