/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class URIEditor
extends PropertyEditorSupport {
    private final ClassLoader classLoader;

    public URIEditor() {
        this.classLoader = null;
    }

    public URIEditor(ClassLoader classLoader) {
        this.classLoader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.hasText(text)) {
            String uri = text.trim();
            if (this.classLoader != null && uri.startsWith("classpath:")) {
                ClassPathResource resource = new ClassPathResource(uri.substring("classpath:".length()), this.classLoader);
                try {
                    String url = resource.getURL().toString();
                    this.setValue(this.createURI(url));
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("Could not retrieve URI for " + resource + ": " + ex.getMessage());
                }
                catch (URISyntaxException ex) {
                    throw new IllegalArgumentException("Invalid URI syntax: " + ex);
                }
            } else {
                try {
                    this.setValue(this.createURI(uri));
                }
                catch (URISyntaxException ex) {
                    throw new IllegalArgumentException("Invalid URI syntax: " + ex);
                }
            }
        } else {
            this.setValue(null);
        }
    }

    protected URI createURI(String value) throws URISyntaxException {
        return new URI(StringUtils.replace(value, " ", "%20"));
    }

    public String getAsText() {
        URI value = (URI)this.getValue();
        return value != null ? value.toString() : "";
    }
}

