/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.headertoolbar;

import java.awt.Color;
import net.sf.jasperreports.components.headertoolbar.actions.ConditionalFormattingData;
import net.sf.jasperreports.components.headertoolbar.actions.FormatCondition;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import net.sf.jasperreports.engine.style.StyleProvider;
import net.sf.jasperreports.engine.style.StyleProviderContext;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.web.util.JacksonUtil;

public class HeaderToolbarConditionalStyleProvider
implements StyleProvider {
    private final StyleProviderContext context;
    private JasperReportsContext jasperreportsContext;

    public HeaderToolbarConditionalStyleProvider(StyleProviderContext context, JasperReportsContext jasperreportsContext) {
        this.context = context;
        this.jasperreportsContext = jasperreportsContext;
    }

    @Override
    public JRStyle getStyle(byte evaluation) {
        String srlzdConditionalFormattingData;
        if (this.context.getElement().getPropertiesMap() != null && (srlzdConditionalFormattingData = this.context.getElement().getPropertiesMap().getProperty("net.sf.jasperreports.components.headertoolbar.conditional.formatting")) != null) {
            JRBaseStyle style = null;
            ConditionalFormattingData cfd = JacksonUtil.getInstance(this.jasperreportsContext).loadObject(srlzdConditionalFormattingData, ConditionalFormattingData.class);
            if (cfd.getConditions().size() > 0) {
                SortFieldTypeEnum columnType = SortFieldTypeEnum.getByName(cfd.getColumnType());
                Object compareTo = columnType.equals(SortFieldTypeEnum.FIELD) ? this.context.getFieldValue(cfd.getFieldOrVariableName(), evaluation) : this.context.getVariableValue(cfd.getFieldOrVariableName(), evaluation);
                boolean bgColorSet = false;
                boolean fontBoldSet = false;
                boolean fontItalicSet = false;
                boolean fontUnderlineSet = false;
                boolean foreColorSet = false;
                boolean modeSet = false;
                for (FormatCondition condition : cfd.getConditions()) {
                    if (!condition.matches(compareTo, cfd.getConditionType(), cfd.getConditionPattern(), condition.getConditionTypeOperator())) continue;
                    if (style == null) {
                        style = new JRBaseStyle();
                    }
                    if (condition.isConditionFontBold() != null && !fontBoldSet) {
                        style.setBold(condition.isConditionFontBold());
                        fontBoldSet = true;
                    }
                    if (condition.isConditionFontItalic() != null && !fontItalicSet) {
                        style.setItalic(condition.isConditionFontItalic());
                        fontItalicSet = true;
                    }
                    if (condition.isConditionFontUnderline() != null && !fontUnderlineSet) {
                        style.setUnderline(condition.isConditionFontUnderline());
                        fontUnderlineSet = true;
                    }
                    if (condition.getConditionFontColor() != null && !foreColorSet) {
                        style.setForecolor(JRColorUtil.getColor("#" + condition.getConditionFontColor(), Color.black));
                        foreColorSet = true;
                    }
                    if (condition.getConditionMode() != null && !modeSet) {
                        style.setMode(ModeEnum.getByName(condition.getConditionMode()));
                        modeSet = true;
                    }
                    if (condition.getConditionFontBackColor() == null || bgColorSet) continue;
                    style.setBackcolor(JRColorUtil.getColor("#" + condition.getConditionFontBackColor(), Color.white));
                    bgColorSet = true;
                }
            }
            return style;
        }
        return null;
    }

    @Override
    public String[] getFields() {
        return null;
    }

    @Override
    public String[] getVariables() {
        return null;
    }
}

