/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.util;

import java.util.List;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.util.SecretsProvider;
import net.sf.jasperreports.util.SecretsProviderFactory;

public final class SecretsUtil {
    private final JasperReportsContext jasperReportsContext;

    private SecretsUtil(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public static final SecretsUtil getInstance(JasperReportsContext jasperReportsContext) {
        return new SecretsUtil(jasperReportsContext);
    }

    public String getSecret(String category, String key) {
        List<SecretsProviderFactory> factories = this.jasperReportsContext.getExtensions(SecretsProviderFactory.class);
        for (SecretsProviderFactory factory : factories) {
            SecretsProvider provider = factory.getSecretsProvider(category);
            if (provider == null || !provider.hasSecret(key)) continue;
            return provider.getSecret(key);
        }
        throw new JRRuntimeException("No secret found for '" + key + "' key in '" + category + "' category.");
    }
}

