/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.MessageUtil;
import net.sf.jasperreports.web.util.VelocityUtil;
import net.sf.jasperreports.web.util.WebResourceHandler;
import net.sf.jasperreports.web.util.WebUtil;

public class DefaultWebResourceHandler
implements WebResourceHandler {
    private static DefaultWebResourceHandler INSTANCE = new DefaultWebResourceHandler();

    private DefaultWebResourceHandler() {
    }

    public static DefaultWebResourceHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean hadlesResource(String resourceKey) {
        return true;
    }

    @Override
    public String getResourceType(String resourceKey) {
        if (resourceKey != null && resourceKey.lastIndexOf(".") != -1) {
            return resourceKey.substring(resourceKey.lastIndexOf(".") + 1);
        }
        return null;
    }

    @Override
    public byte[] getData(String resourceKey, HttpServletRequest request, JasperReportsContext jrContext) {
        if (resourceKey != null) {
            WebUtil webUtil = WebUtil.getInstance(jrContext);
            boolean isDynamicResource = webUtil.isDynamicResource(request);
            String resourceBundleName = webUtil.getResourceBundleForResource(request);
            Locale locale = webUtil.getResourceLocale(request);
            byte[] bytes = null;
            try {
                if (resourceKey.indexOf(".vm.") != -1 && (isDynamicResource || resourceBundleName != null || locale != null)) {
                    HashMap<String, Object> contextMap = new HashMap<String, Object>();
                    contextMap.put("path", request.getContextPath() + webUtil.getResourcesBasePath());
                    locale = locale == null ? Locale.getDefault() : locale;
                    contextMap.put("msgProvider", MessageUtil.getInstance(jrContext).getLocalizedMessageProvider(resourceBundleName, locale));
                    String resourceString = VelocityUtil.processTemplate(resourceKey, contextMap);
                    if (resourceString != null) {
                        bytes = resourceString.getBytes("UTF-8");
                    }
                } else {
                    bytes = JRLoader.loadBytesFromResource(resourceKey);
                }
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
            return bytes;
        }
        return null;
    }
}

