/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.hive.common.io.NonSyncByteArrayOutputStream;

public class NonSyncDataOutputBuffer
extends DataOutputStream {
    private final NonSyncByteArrayOutputStream buffer;

    public NonSyncDataOutputBuffer() {
        this(new NonSyncByteArrayOutputStream());
    }

    private NonSyncDataOutputBuffer(NonSyncByteArrayOutputStream buffer) {
        super(buffer);
        this.buffer = buffer;
    }

    public byte[] getData() {
        return this.buffer.getData();
    }

    public int getLength() {
        return this.buffer.getLength();
    }

    public NonSyncDataOutputBuffer reset() {
        this.written = 0;
        this.buffer.reset();
        return this;
    }

    public void write(DataInput in, int length) throws IOException {
        this.buffer.write(in, length);
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.write(b);
        this.incCount(1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.buffer.write(b, off, len);
        this.incCount(len);
    }

    private void incCount(int value) {
        this.written = this.written + value < 0 ? Integer.MAX_VALUE : (this.written += value);
    }
}

