/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;

public class FunctionInfo {
    private final boolean isNative;
    private final String displayName;
    private GenericUDF genericUDF;
    private GenericUDTF genericUDTF;
    private GenericUDAFResolver genericUDAFResolver;

    public FunctionInfo(boolean isNative, String displayName, GenericUDF genericUDF) {
        this.isNative = isNative;
        this.displayName = displayName;
        this.genericUDF = genericUDF;
    }

    public FunctionInfo(boolean isNative, String displayName, GenericUDAFResolver genericUDAFResolver) {
        this.isNative = isNative;
        this.displayName = displayName;
        this.genericUDAFResolver = genericUDAFResolver;
    }

    public FunctionInfo(boolean isNative, String displayName, GenericUDTF genericUDTF) {
        this.isNative = isNative;
        this.displayName = displayName;
        this.genericUDTF = genericUDTF;
    }

    public GenericUDF getGenericUDF() {
        if (this.genericUDF == null) {
            return null;
        }
        return FunctionRegistry.cloneGenericUDF(this.genericUDF);
    }

    public GenericUDTF getGenericUDTF() {
        if (this.genericUDTF == null) {
            return null;
        }
        return FunctionRegistry.cloneGenericUDTF(this.genericUDTF);
    }

    public GenericUDAFResolver getGenericUDAFResolver() {
        return this.genericUDAFResolver;
    }

    public Class<?> getFunctionClass() {
        if (this.isGenericUDF()) {
            if (this.genericUDF instanceof GenericUDFBridge) {
                return ((GenericUDFBridge)this.genericUDF).getUdfClass();
            }
            return this.genericUDF.getClass();
        }
        if (this.isGenericUDAF()) {
            if (this.genericUDAFResolver instanceof GenericUDAFBridge) {
                return ((GenericUDAFBridge)this.genericUDAFResolver).getUDAFClass();
            }
            return this.genericUDAFResolver.getClass();
        }
        if (this.isGenericUDTF()) {
            return this.genericUDTF.getClass();
        }
        return null;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public boolean isGenericUDF() {
        return null != this.genericUDF;
    }

    public boolean isGenericUDAF() {
        return null != this.genericUDAFResolver;
    }

    public boolean isGenericUDTF() {
        return null != this.genericUDTF;
    }
}

