/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.table.fill;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.sf.jasperreports.components.table.fill.TableReportGroup;
import net.sf.jasperreports.engine.JRAbstractScriptlet;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignScriptlet;
import net.sf.jasperreports.engine.type.WhenResourceMissingTypeEnum;

public class TableReportDataset
implements JRDataset {
    private final JRDataset tableSubdataset;
    private final String name;
    private final TableReportGroup[] tableGroups;
    private final List<JRGroup> groups;
    private final JRPropertiesMap properties;
    private final List<JRScriptlet> scriptlets;
    private final List<JRParameter> parameters;

    public TableReportDataset(JRDataset tableSubdataset, String name) {
        this.tableSubdataset = tableSubdataset;
        this.name = name;
        JRGroup[] datasetGroups = tableSubdataset.getGroups();
        this.groups = new ArrayList<JRGroup>();
        if (datasetGroups == null) {
            this.tableGroups = null;
        } else {
            this.tableGroups = new TableReportGroup[datasetGroups.length];
            for (int i = 0; i < datasetGroups.length; ++i) {
                this.tableGroups[i] = new TableReportGroup(datasetGroups[i]);
                this.groups.add(this.tableGroups[i]);
            }
        }
        this.properties = tableSubdataset.getPropertiesMap().cloneProperties();
        this.scriptlets = new ArrayList<JRScriptlet>();
        JRScriptlet[] datasetScriptlets = tableSubdataset.getScriptlets();
        if (datasetScriptlets != null) {
            Collections.addAll(this.scriptlets, datasetScriptlets);
        }
        JRParameter[] datasetParameters = tableSubdataset.getParameters();
        this.parameters = new ArrayList<JRParameter>();
        if (datasetParameters != null) {
            Collections.addAll(this.parameters, datasetParameters);
        }
    }

    @Override
    public JRField[] getFields() {
        return this.tableSubdataset.getFields();
    }

    @Override
    public JRExpression getFilterExpression() {
        return this.tableSubdataset.getFilterExpression();
    }

    public TableReportGroup[] getTableGroups() {
        return this.tableGroups;
    }

    @Override
    public JRGroup[] getGroups() {
        return this.groups.toArray(new JRGroup[this.groups.size()]);
    }

    public void addFirstGroup(JRGroup group) {
        this.groups.add(0, group);
    }

    @Override
    public UUID getUUID() {
        return this.tableSubdataset.getUUID();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JRParameter[] getParameters() {
        return this.parameters.toArray(new JRParameter[this.parameters.size()]);
    }

    @Override
    public JRQuery getQuery() {
        return this.tableSubdataset.getQuery();
    }

    @Override
    public String getResourceBundle() {
        return this.tableSubdataset.getResourceBundle();
    }

    @Override
    public String getScriptletClass() {
        return this.tableSubdataset.getScriptletClass();
    }

    @Override
    public JRScriptlet[] getScriptlets() {
        return this.scriptlets.toArray(new JRScriptlet[this.scriptlets.size()]);
    }

    @Override
    public JRSortField[] getSortFields() {
        return this.tableSubdataset.getSortFields();
    }

    @Override
    public JRVariable[] getVariables() {
        return this.tableSubdataset.getVariables();
    }

    @Override
    public WhenResourceMissingTypeEnum getWhenResourceMissingTypeValue() {
        return this.tableSubdataset.getWhenResourceMissingTypeValue();
    }

    @Override
    public boolean isMainDataset() {
        return true;
    }

    @Override
    public void setWhenResourceMissingType(WhenResourceMissingTypeEnum whenResourceMissingType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JRPropertiesHolder getParentProperties() {
        return this.tableSubdataset.getParentProperties();
    }

    @Override
    public JRPropertiesMap getPropertiesMap() {
        return this.properties;
    }

    @Override
    public boolean hasProperties() {
        return this.properties.hasProperties();
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    public void addScriptlet(String name, Class<? extends JRAbstractScriptlet> type) {
        JRDesignScriptlet scriptlet = new JRDesignScriptlet();
        scriptlet.setName(name);
        scriptlet.setValueClass(type);
        JRDesignParameter parameter = new JRDesignParameter();
        parameter.setName(name + "_SCRIPTLET");
        parameter.setValueClass(scriptlet.getValueClass());
        parameter.setSystemDefined(true);
        parameter.setForPrompting(false);
        this.scriptlets.add(scriptlet);
        this.parameters.add(parameter);
    }
}

