/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.mongodb.importer;

import com.jaspersoft.mongodb.connection.MongoDbConnection;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class MongoDbImporter {
    private Connection connection;
    private Statement statement;
    private static final Logger logger = Logger.getLogger(MongoDbImporter.class);
    public static final String CHARACTER_SET = "UTF-8";
    private MongoDbConnection mongodbConnection;

    public MongoDbImporter(Connection connection, MongoDbConnection mongodbConnection) throws Exception {
        this.connection = connection;
        this.mongodbConnection = mongodbConnection;
        this.createConnection();
    }

    private void createConnection() throws ClassNotFoundException {
        try {
            this.statement = this.connection.createStatement();
            logger.info((Object)"Database connection created");
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
    }

    public void shutdown() {
        if (this.mongodbConnection != null) {
            this.mongodbConnection.close();
            this.mongodbConnection = null;
        }
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            this.statement = null;
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            this.connection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importTable(String tableName) throws Exception {
        this.createConnection();
        logger.info((Object)"Initialize import");
        ResultSet resultSet = null;
        ArrayList<BasicDBObject> objectsList = new ArrayList<BasicDBObject>();
        try {
            resultSet = this.statement.executeQuery("SELECT * FROM " + tableName);
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            int count = 0;
            logger.info((Object)"Importing rows");
            DBCollection collection = null;
            if (!this.mongodbConnection.getMongoDatabase().collectionExists(tableName)) {
                logger.info((Object)("Collection \"" + tableName + "\" doesn't exist"));
                BasicDBObject options = new BasicDBObject("capped", (Object)false);
                collection = this.mongodbConnection.getMongoDatabase().createCollection(tableName, (DBObject)options);
            } else {
                logger.info((Object)("Collection \"" + tableName + "\" exists"));
                collection = this.mongodbConnection.getMongoDatabase().getCollectionFromString(tableName);
                collection.drop();
                logger.info((Object)("Collection \"" + tableName + "\" was cleaned up"));
            }
            while (resultSet.next()) {
                BasicDBObject newObject = new BasicDBObject();
                for (int index = 1; index <= columnCount; ++index) {
                    Object value = resultSet.getObject(index);
                    if (value == null) continue;
                    newObject.put(metaData.getColumnName(index), value);
                }
                objectsList.add(newObject);
                if (++count % 100 != 0) continue;
                logger.info((Object)("Processed: " + count));
                logger.info((Object)("Result: " + collection.insert(objectsList).getField("ok")));
                objectsList.clear();
            }
            if (objectsList.size() > 0) {
                collection.insert(objectsList);
                logger.info((Object)("Result: " + collection.insert(objectsList).getField("ok")));
                objectsList.clear();
            }
            logger.info((Object)("Rows added: " + count));
            logger.info((Object)"Import done");
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    public void validate(String tableName) {
        DBCollection collection = this.mongodbConnection.getMongoDatabase().getCollection(tableName);
        long size = collection.getCount();
        if (size == 0L) {
            logger.error((Object)"No data in Mongo database");
            return;
        }
        logger.info((Object)("Elements in collection: " + size));
        logger.info((Object)"Validating the first 5 entries");
        DBCursor cursor = collection.find().limit(5);
        logger.info((Object)"---------------");
        while (cursor.hasNext()) {
            DBObject object = cursor.next();
            for (String id : object.keySet()) {
                Object value = object.get(id);
                logger.info((Object)(value + " -> " + value.getClass().getName()));
            }
            logger.info((Object)"---------------");
        }
    }
}

