/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.upcean;

import org.krysalis.barcode4j.BarGroup;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.ClassicBarcodeLogicHandler;
import org.krysalis.barcode4j.impl.upcean.UPCALogicImpl;
import org.krysalis.barcode4j.impl.upcean.UPCEANLogicImpl;

public class UPCELogicImpl
extends UPCEANLogicImpl {
    private static final byte O = 0;
    private static final byte E = 1;
    private static final byte[][] NUMBER_SYSTEM_0 = new byte[][]{{1, 1, 1, 0, 0, 0}, {1, 1, 0, 1, 0, 0}, {1, 1, 0, 0, 1, 0}, {1, 1, 0, 0, 0, 1}, {1, 0, 1, 1, 0, 0}, {1, 0, 0, 1, 1, 0}, {1, 0, 0, 0, 1, 1}, {1, 0, 1, 0, 1, 0}, {1, 0, 1, 0, 0, 1}, {1, 0, 0, 1, 0, 1}};

    public UPCELogicImpl(ChecksumMode mode) {
        super(mode);
    }

    private static String substring(String s, int idx, int len) {
        return s.substring(idx, idx + len);
    }

    public static String compactMessage(String msg) {
        StringBuffer upce;
        byte check;
        block7: {
            UPCALogicImpl.validateMessage(msg);
            String upca = UPCALogicImpl.handleChecksum(msg, ChecksumMode.CP_AUTO);
            byte numberSystem = UPCELogicImpl.extractNumberSystem(upca);
            if (numberSystem != 0 && numberSystem != 1) {
                return null;
            }
            check = Byte.parseByte(upca.substring(11, 12));
            upce = new StringBuffer();
            upce.append(Byte.toString(numberSystem));
            try {
                String manufacturer = UPCELogicImpl.substring(upca, 1, 5);
                String product = UPCELogicImpl.substring(upca, 6, 5);
                String mtemp = UPCELogicImpl.substring(manufacturer, 2, 3);
                String ptemp = UPCELogicImpl.substring(product, 0, 2);
                if ("000|100|200".indexOf(mtemp) >= 0 && "00".equals(ptemp)) {
                    upce.append(UPCELogicImpl.substring(manufacturer, 0, 2));
                    upce.append(UPCELogicImpl.substring(product, 2, 3));
                    upce.append(mtemp.charAt(0));
                    break block7;
                }
                ptemp = UPCELogicImpl.substring(product, 0, 3);
                if ("300|400|500|600|700|800|900".indexOf(mtemp) >= 0 && "000".equals(ptemp)) {
                    upce.append(UPCELogicImpl.substring(manufacturer, 0, 3));
                    upce.append(UPCELogicImpl.substring(product, 3, 2));
                    upce.append("3");
                    break block7;
                }
                mtemp = UPCELogicImpl.substring(manufacturer, 3, 2);
                ptemp = UPCELogicImpl.substring(product, 0, 4);
                if ("10|20|30|40|50|60|70|80|90".indexOf(mtemp) >= 0 && "0000".equals(ptemp)) {
                    upce.append(UPCELogicImpl.substring(manufacturer, 0, 4));
                    upce.append(UPCELogicImpl.substring(product, 4, 1));
                    upce.append("4");
                    break block7;
                }
                mtemp = UPCELogicImpl.substring(manufacturer, 4, 1);
                ptemp = UPCELogicImpl.substring(product, 4, 1);
                if (!"0".equals(mtemp) && "5|6|7|8|9".indexOf(ptemp) >= 0) {
                    upce.append(manufacturer);
                    upce.append(ptemp);
                    break block7;
                }
                return null;
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        upce.append(Byte.toString(check));
        return upce.toString();
    }

    public static String expandMessage(String msg) {
        String upce;
        byte numberSystem;
        char check = '\u0000';
        if (msg.length() == 8) {
            check = msg.charAt(7);
        }
        if ((numberSystem = UPCELogicImpl.extractNumberSystem(upce = UPCELogicImpl.substring(msg, 0, 7))) != 0 && numberSystem != 1) {
            throw new IllegalArgumentException("Invalid UPC-E message: " + msg);
        }
        StringBuffer upca = new StringBuffer();
        upca.append(Byte.toString(numberSystem));
        byte mode = Byte.parseByte(UPCELogicImpl.substring(upce, 6, 1));
        if (mode >= 0 && mode <= 2) {
            upca.append(UPCELogicImpl.substring(upce, 1, 2));
            upca.append(Byte.toString(mode));
            upca.append("0000");
            upca.append(UPCELogicImpl.substring(upce, 3, 3));
        } else if (mode == 3) {
            upca.append(UPCELogicImpl.substring(upce, 1, 3));
            upca.append("00000");
            upca.append(UPCELogicImpl.substring(upce, 4, 2));
        } else if (mode == 4) {
            upca.append(UPCELogicImpl.substring(upce, 1, 4));
            upca.append("00000");
            upca.append(UPCELogicImpl.substring(upce, 5, 1));
        } else if (mode >= 5 && mode <= 9) {
            upca.append(UPCELogicImpl.substring(upce, 1, 5));
            upca.append("0000");
            upca.append(Byte.toString(mode));
        } else {
            throw new RuntimeException("Internal error");
        }
        String upcaFinished = upca.toString();
        char expectedCheck = UPCELogicImpl.calcChecksum(upcaFinished);
        if (check != '\u0000' && check != expectedCheck) {
            throw new IllegalArgumentException("Invalid checksum. Expected " + expectedCheck + " but was " + check);
        }
        return upcaFinished + expectedCheck;
    }

    private static byte extractNumberSystem(String msg) {
        return Byte.parseByte(msg.substring(0, 1));
    }

    private String convertUPCAtoUPCE(String msg) {
        if (msg.length() == 11 || msg.length() == 12) {
            String s = UPCELogicImpl.compactMessage(msg);
            if (s == null) {
                throw new IllegalArgumentException("UPC-A message cannot be compacted to UPC-E. Message: " + msg);
            }
            return s;
        }
        return msg;
    }

    public static void validateMessage(String msg) {
        UPCEANLogicImpl.validateMessage(msg);
        if (msg.length() < 7 || msg.length() > 8) {
            throw new IllegalArgumentException("Message must be 7 or 8 characters long. Message: " + msg);
        }
        byte numberSystem = UPCELogicImpl.extractNumberSystem(msg);
        if (numberSystem < 0 || numberSystem > 1) {
            throw new IllegalArgumentException("Valid number systems for UPC-E are 0 or 1. Found: " + numberSystem);
        }
    }

    private String handleChecksum(String msg) {
        ChecksumMode mode = this.getChecksumMode();
        if (mode == ChecksumMode.CP_AUTO) {
            if (msg.length() == 7) {
                mode = ChecksumMode.CP_ADD;
            } else if (msg.length() == 8) {
                mode = ChecksumMode.CP_CHECK;
            } else {
                throw new RuntimeException("Internal error");
            }
        }
        if (mode == ChecksumMode.CP_ADD) {
            if (msg.length() != 7) {
                throw new IllegalArgumentException("Message must be 7 characters long");
            }
            return msg + UPCELogicImpl.expandMessage(msg).charAt(11);
        }
        if (mode == ChecksumMode.CP_CHECK) {
            char expected;
            if (msg.length() != 8) {
                throw new IllegalArgumentException("Message must be 8 characters long");
            }
            char check = msg.charAt(7);
            if (check != (expected = UPCELogicImpl.expandMessage(msg).charAt(11))) {
                throw new IllegalArgumentException("Checksum is bad (" + check + "). Expected: " + expected);
            }
            return msg;
        }
        if (mode == ChecksumMode.CP_IGNORE) {
            if (msg.length() != 8) {
                throw new IllegalArgumentException("Message must be 8 characters long");
            }
            return msg;
        }
        throw new UnsupportedOperationException("Unknown checksum mode: " + mode);
    }

    private byte selectCharset(byte check, byte numberSystem, int position) {
        byte charset = NUMBER_SYSTEM_0[check][position];
        if (numberSystem == 1) {
            charset = charset == 0 ? (byte)1 : 0;
        }
        return charset;
    }

    protected void drawUPCERightGuard(ClassicBarcodeLogicHandler logic) {
        logic.startBarGroup(BarGroup.UPC_EAN_GUARD, null);
        logic.addBar(false, 1);
        logic.addBar(true, 1);
        logic.addBar(false, 1);
        logic.addBar(true, 1);
        logic.addBar(false, 1);
        logic.addBar(true, 1);
        logic.endBarGroup();
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler logic, String msg) {
        String supp = UPCELogicImpl.retrieveSupplemental(msg);
        String s = UPCELogicImpl.removeSupplemental(msg);
        s = this.convertUPCAtoUPCE(s);
        UPCELogicImpl.validateMessage(s);
        String canonicalMessage = s = this.handleChecksum(s);
        if (supp != null) {
            canonicalMessage = canonicalMessage + "+" + supp;
        }
        logic.startBarcode(canonicalMessage, canonicalMessage);
        this.drawSideGuard(logic);
        byte numberSystem = UPCELogicImpl.extractNumberSystem(msg);
        logic.startBarGroup(BarGroup.UPC_EAN_LEAD, Byte.toString(numberSystem));
        logic.endBarGroup();
        byte check = Byte.parseByte(s.substring(7, 8));
        logic.startBarGroup(BarGroup.UPC_EAN_GROUP, s.substring(1, 7));
        for (int i = 1; i < 7; ++i) {
            byte charset = this.selectCharset(check, numberSystem, i - 1);
            this.encodeChar(logic, s.charAt(i), charset);
        }
        logic.endBarGroup();
        logic.startBarGroup(BarGroup.UPC_EAN_CHECK, Byte.toString(check));
        logic.endBarGroup();
        this.drawUPCERightGuard(logic);
        if (supp != null) {
            this.drawSupplemental(logic, supp);
        }
        logic.endBarcode();
    }
}

