/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;
import rex.utils.S;

public class AuthenticationDialog
extends JDialog
implements LanguageChangedListener {
    private static final String usernameKey = "j_username=";
    private static final String passwordKey = "j_password=";
    JTextField username;
    JPasswordField password;
    JLabel lblUserName;
    JLabel lblPassword;
    JButton jb;
    static boolean firstCall = true;

    public AuthenticationDialog(JDialog owner) {
        super((Frame)null, I18n.getString("frame.authentication"), true);
        firstCall = false;
        this.authenticationDialog(owner);
    }

    public AuthenticationDialog(JDialog owner, String urlString) {
        super((Frame)null, I18n.getString("frame.authentication"), true);
        int userStart = urlString.indexOf(usernameKey);
        int passwordStart = urlString.indexOf(passwordKey);
        if (!firstCall || userStart == -1 || passwordStart == -1) {
            this.authenticationDialog(owner);
        } else {
            firstCall = false;
            int userEnd = urlString.indexOf(38, (userStart += usernameKey.length()) + 1);
            String sUser = userEnd == -1 ? urlString.substring(userStart) : urlString.substring(userStart, userEnd);
            int passwordEnd = urlString.indexOf(38, (passwordStart += passwordKey.length()) + 1);
            String sPassword = passwordEnd == -1 ? urlString.substring(passwordStart) : urlString.substring(passwordStart, passwordEnd - 1);
            this.username = new JTextField(sUser);
            this.password = new JPasswordField(sPassword);
        }
    }

    public void authenticationDialog(JDialog owner) {
        JPanel jl = new JPanel(new GridLayout(2, 0, 10, 10));
        JPanel jf = new JPanel(new GridLayout(2, 0, 10, 10));
        jl.setBorder(new EmptyBorder(10, 10, 10, 1));
        jf.setBorder(new EmptyBorder(10, 1, 10, 10));
        this.lblUserName = new JLabel(I18n.getString("label.userName"));
        this.lblPassword = new JLabel(I18n.getString("label.password"));
        this.jb = new JButton(I18n.getString("btn.ok"));
        jl.add(this.lblUserName);
        this.username = new JTextField();
        this.username.setFont(new Font("Monospaced", 1, 16));
        jf.add(this.username);
        jl.add(this.lblPassword);
        this.password = new JPasswordField();
        this.password.setFont(new Font("Monospaced", 1, 16));
        this.password.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                S.out("disposing...");
                AuthenticationDialog.this.dispose();
            }
        });
        jf.add(this.password);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jl, "West");
        this.getContentPane().add((Component)jf, "Center");
        this.jb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                S.out("disposing...");
                AuthenticationDialog.this.dispose();
            }
        });
        this.getContentPane().add((Component)this.jb, "South");
        Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(sd.width / 2 - 125, sd.height / 2 - 60);
        this.setResizable(false);
        I18n.addOnLanguageChangedListener(this);
        this.applyI18n();
        this.pack();
        this.setSize(260, 140);
        this.setVisible(true);
    }

    public String getPassword() {
        return new String(this.password.getPassword());
    }

    public char[] getPasswordCA() {
        return this.password.getPassword();
    }

    public String getUsername() {
        return this.username.getText();
    }

    public static void main(String[] args) {
        new AuthenticationDialog(null);
    }

    @Override
    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    @Override
    public void removeLanguageListener() {
        I18n.removeOnLanguageChangedListener(this);
    }

    public void applyI18n() {
        this.lblUserName.setText(I18n.getString("label.userName"));
        this.lblPassword.setText(I18n.getString("label.password"));
        this.jb.setText(I18n.getString("btn.ok"));
    }
}

