/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.spi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.modules.xml.xam.dom.DocumentModel;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.ValidationResult;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.util.NbBundle;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class XsdBasedValidator
implements Validator {
    protected abstract Schema getSchema(Model var1);

    public ValidationResult validate(Model model, Validation validation, Validation.ValidationType validationType) {
        Schema schema = this.getSchema(model);
        if (schema == null) {
            return null;
        }
        Handler handler = new Handler(model);
        this.validate(model, schema, handler);
        Collection<Validator.ResultItem> collection = handler.getResultItems();
        List<Model> list = Collections.singletonList(model);
        return new ValidationResult(collection, list);
    }

    protected Source getSource(Model model, Handler handler) {
        Source source = (Source)model.getModelSource().getLookup().lookup(Source.class);
        if (source != null) {
            return source;
        }
        File file = (File)model.getModelSource().getLookup().lookup(File.class);
        if (file == null) {
            return null;
        }
        try {
            source = new SAXSource(new InputSource(new FileInputStream(file)));
            source.setSystemId(file.toURI().toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (source == null) {
            String string = NbBundle.getMessage(XsdBasedValidator.class, (String)"MSG_NoSAXSource");
            handler.logValidationErrors(Validator.ResultType.WARNING, string);
        }
        return source;
    }

    protected void validate(Model model, Schema schema, Handler handler) {
        javax.xml.validation.Validator validator = schema.newValidator();
        Source source = this.getSource(model, handler);
        if (source != null) {
            validator.setErrorHandler(handler);
            assert (source instanceof SAXSource || source instanceof DOMSource) : "Source is not instance of SAXSource or DOMSource";
            try {
                validator.validate(source);
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.FINE, "validate", iOException);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
    }

    protected Schema getCompiledSchema(InputStream[] inputStreamArray, LSResourceResolver lSResourceResolver) {
        Schema schema = null;
        Source[] sourceArray = new StreamSource[inputStreamArray.length];
        for (int i = 0; i < inputStreamArray.length; ++i) {
            sourceArray[i] = new StreamSource(inputStreamArray[i]);
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setResourceResolver(lSResourceResolver);
        try {
            schema = schemaFactory.newSchema(sourceArray);
        }
        catch (SAXException sAXException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "getCompiledSchema", sAXException);
        }
        return schema;
    }

    protected Schema getCompiledSchema(Source[] sourceArray, LSResourceResolver lSResourceResolver, ErrorHandler errorHandler) {
        Schema schema = null;
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setResourceResolver(lSResourceResolver);
        schemaFactory.setErrorHandler(errorHandler);
        try {
            schema = schemaFactory.newSchema(sourceArray);
        }
        catch (SAXException sAXException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "getCompiledSchema", sAXException);
        }
        return schema;
    }

    public DocumentModel resolveResource(String string, Model model) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Handler
    implements ErrorHandler {
        private Collection<Validator.ResultItem> resultItems;
        private List<Integer> linePositions = null;
        private DocumentModel model;
        private HashMap<DocumentModel, Handler> relatedHandlers = new HashMap();

        public Handler(Model model) {
            assert (model instanceof DocumentModel) : "Invalid model class";
            this.resultItems = new ArrayList<Validator.ResultItem>();
            this.model = (DocumentModel)model;
        }

        public Collection<Validator.ResultItem> getResultItems() {
            this.addResultsFromHandlers(this.relatedHandlers.values());
            return this.resultItems;
        }

        public void addResultsFromHandlers(Collection<Handler> collection) {
            for (Handler handler : collection) {
                this.resultItems.addAll(handler.getResultItems());
            }
        }

        private void setupLinePositions() {
            this.linePositions = new ArrayList<Integer>();
            Document document = ((AbstractDocumentModel)this.model).getBaseDocument();
            if (document == null) {
                return;
            }
            try {
                String string = document.getText(0, document.getLength() - 1);
                String[] stringArray = string.split("\n");
                this.linePositions.add(-1);
                int n = 0;
                for (String string2 : stringArray) {
                    this.linePositions.add(n);
                    n += string2.length() + 1;
                }
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger(this.getClass().getName()).log(Level.FINE, "setupLinePositions", badLocationException);
            }
        }

        private int getPosition(int n, int n2) {
            if (this.linePositions == null) {
                this.setupLinePositions();
            }
            if (n < 1 || n > this.linePositions.size()) {
                return 0;
            }
            Integer n3 = this.linePositions.get(n);
            return n3 == null ? 0 : n3 + n2 - 1;
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            this.logValidationErrors(Validator.ResultType.ERROR, sAXParseException);
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.logValidationErrors(Validator.ResultType.ERROR, sAXParseException);
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.logValidationErrors(Validator.ResultType.WARNING, sAXParseException);
        }

        public void logValidationErrors(Validator.ResultType resultType, SAXParseException sAXParseException) {
            String string = sAXParseException.getSystemId();
            DocumentModel documentModel = null;
            if (string != null) {
                documentModel = XsdBasedValidator.this.resolveResource(string, this.model);
            }
            Handler handler = null;
            if (documentModel != null && this.model != documentModel && (handler = this.relatedHandlers.get(documentModel)) == null) {
                handler = new Handler(documentModel);
                this.relatedHandlers.put(documentModel, handler);
            }
            if (handler == null) {
                handler = this;
            }
            handler.logValidationErrors(resultType, sAXParseException.getMessage(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber() - 1);
        }

        public void logValidationErrors(Validator.ResultType resultType, String string, int n, int n2) {
            if (n2 <= 0) {
                n2 = 1;
            }
            if (this.model.getState().equals((Object)Model.State.VALID)) {
                int n3 = this.getPosition(n, n2);
                assert (n3 >= 0) : "Invalid position value " + n3;
                DocumentComponent documentComponent = this.model.findComponent(n3);
                if (documentComponent == null) {
                    documentComponent = this.model.getRootComponent();
                }
                this.resultItems.add(new Validator.ResultItem(XsdBasedValidator.this, resultType, documentComponent, string));
            } else {
                this.resultItems.add(new Validator.ResultItem(XsdBasedValidator.this, resultType, string, n, n2, this.model));
            }
        }

        public void logValidationErrors(Validator.ResultType resultType, String string) {
            this.logValidationErrors(resultType, string, 1, 1);
        }
    }
}

