/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.actions.AlignWithSupport;
import com.jaspersoft.ireport.designer.actions.ExMoveAction;
import com.jaspersoft.ireport.designer.undo.AddElementUndoableEdit;
import com.jaspersoft.ireport.designer.undo.AggregatedUndoableEdit;
import com.jaspersoft.ireport.designer.undo.BandChangeUndoableEdit;
import com.jaspersoft.ireport.designer.undo.DeleteElementUndoableEdit;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.designer.undo.UndoMoveChildrenUndoableEdit;
import com.jaspersoft.ireport.designer.widgets.JRDesignElementWidget;
import com.jaspersoft.ireport.designer.widgets.SelectionWidget;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.AlignWithMoveDecorator;
import org.netbeans.api.visual.action.AlignWithWidgetCollector;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportAlignWithMoveStrategyProvider
extends AlignWithSupport
implements MoveStrategy,
MoveProvider {
    private ExMoveAction action = null;
    private boolean outerBounds;
    private boolean moveEnabled = false;
    private boolean snapToGrid = false;
    private int gridSize = 13;
    List<JRDesignElement> theSelectedElements = null;
    List<AggregatedUndoableEdit> undoEdits = null;

    public int getGridSize() {
        return this.gridSize;
    }

    public void setGridSize(int gridSize) {
        this.gridSize = gridSize;
    }

    public boolean isOuterBounds() {
        return this.outerBounds;
    }

    public void setOuterBounds(boolean outerBounds) {
        this.outerBounds = outerBounds;
    }

    public boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    public void setSnapToGrid(boolean snapToGrid) {
        this.snapToGrid = snapToGrid;
    }

    public ReportAlignWithMoveStrategyProvider(AlignWithWidgetCollector collector, LayerWidget interractionLayer, AlignWithMoveDecorator decorator, boolean outerBounds) {
        super(collector, interractionLayer, decorator);
        this.outerBounds = outerBounds;
    }

    public Point locationSuggested(Widget widget, Point originalLocation, Point suggestedLocation) {
        if (!this.moveEnabled) {
            if (Math.abs(suggestedLocation.x - originalLocation.x) > 5 || Math.abs(suggestedLocation.y - originalLocation.y) > 5) {
                this.moveEnabled = true;
            } else {
                return originalLocation;
            }
        }
        if (IReportManager.getPreferences().getBoolean("noMagnetic", false)) {
            return suggestedLocation;
        }
        Point widgetLocation = widget.getLocation();
        Rectangle widgetBounds = this.outerBounds ? widget.getBounds() : widget.getClientArea();
        Rectangle bounds = widget.convertLocalToScene(widgetBounds);
        bounds.translate(suggestedLocation.x - widgetLocation.x, suggestedLocation.y - widgetLocation.y);
        Insets insets = widget.getBorder().getInsets();
        if (!this.outerBounds) {
            suggestedLocation.x += insets.left;
            suggestedLocation.y += insets.top;
        }
        Point point = new Point(suggestedLocation);
        if (this.isSnapToGrid()) {
            point = this.snapToGrid(point, this.getGridSize());
            point.x += insets.left;
            point.y += insets.top;
        } else {
            point = super.locationSuggested(widget, bounds, point, true, true, true, true);
        }
        if (!this.outerBounds) {
            point.x -= insets.left;
            point.y -= insets.top;
        }
        return widget.getParentWidget().convertSceneToLocal(point);
    }

    public void movementStarted(Widget widget) {
        JRDesignElementWidget dew;
        this.moveEnabled = false;
        this.undoEdits = new ArrayList<AggregatedUndoableEdit>();
        List selectedElements = ((AbstractReportObjectScene)widget.getScene()).getSelectionLayer().getChildren();
        this.theSelectedElements = new ArrayList<JRDesignElement>();
        for (Widget w : selectedElements) {
            if (!w.isVisible()) continue;
            dew = ((SelectionWidget)w).getRealWidget();
            this.theSelectedElements.add(dew.getElement());
        }
        for (Widget w : selectedElements) {
            if (!w.isVisible()) continue;
            dew = ((SelectionWidget)w).getRealWidget();
            JasperDesign jd = ((AbstractReportObjectScene)dew.getScene()).getJasperDesign();
            this.undoEdits.add(new ObjectPropertyUndoableEdit(dew.getElement(), "X", Integer.TYPE, new Integer(dew.getElement().getX()), new Integer(dew.getElement().getX())));
            this.undoEdits.add(new ObjectPropertyUndoableEdit(dew.getElement(), "Y", Integer.TYPE, new Integer(dew.getElement().getY()), new Integer(dew.getElement().getY())));
        }
        this.show();
    }

    public void movementFinished(Widget widget) {
        AggregatedUndoableEdit edit;
        final AbstractReportObjectScene scene = (AbstractReportObjectScene)widget.getScene();
        List selectedElements = scene.getSelectionLayer().getChildren();
        ArrayList<JRDesignElement> elements = new ArrayList<JRDesignElement>();
        for (Widget w : selectedElements) {
            if (!w.isVisible()) continue;
            JRDesignElementWidget dew = ((SelectionWidget)w).getRealWidget();
            elements.add(dew.getElement());
        }
        ArrayList<JRDesignElement> elementsToAddToSelection = new ArrayList<JRDesignElement>();
        ArrayList<Widget> changedWidgets = new ArrayList<Widget>();
        for (Widget w : selectedElements) {
            AggregatedUndoableEdit edit2;
            if (!w.isVisible()) continue;
            JRDesignElementWidget dew = ((SelectionWidget)w).getRealWidget();
            elementsToAddToSelection.add(dew.getElement());
            JRElementGroup obj = dew.getElement().getElementGroup();
            boolean changed = false;
            if (!(obj instanceof JRDesignElement && elements.contains((JRDesignElement)obj) || (edit2 = this.findBestNewParent(dew)) == null)) {
                changed = true;
                this.undoEdits.add(edit2);
            }
            if (dew.getChildrenElements() == null) continue;
            if (changed) {
                this.updateChildren(dew, scene, changedWidgets);
            }
            this.undoEdits.add(0, new UndoMoveChildrenUndoableEdit(dew));
        }
        for (int i = 0; i < this.undoEdits.size(); ++i) {
            AggregatedUndoableEdit theEdit = this.undoEdits.get(i);
            if (theEdit instanceof ObjectPropertyUndoableEdit) {
                edit = (ObjectPropertyUndoableEdit)theEdit;
                if (((ObjectPropertyUndoableEdit)edit).getNewValue() == null && ((ObjectPropertyUndoableEdit)edit).getOldValue() == null) {
                    this.undoEdits.remove(edit);
                    --i;
                    continue;
                }
                if (((ObjectPropertyUndoableEdit)edit).getNewValue() == null || ((ObjectPropertyUndoableEdit)edit).getOldValue() == null || !((ObjectPropertyUndoableEdit)edit).getNewValue().equals(((ObjectPropertyUndoableEdit)edit).getOldValue())) continue;
                this.undoEdits.remove(edit);
                --i;
                continue;
            }
            if (!(theEdit instanceof BandChangeUndoableEdit) || ((BandChangeUndoableEdit)(edit = (BandChangeUndoableEdit)theEdit)).getOldBand() != null && ((BandChangeUndoableEdit)edit).getNewBand() != null && ((BandChangeUndoableEdit)edit).getNewBand() != ((BandChangeUndoableEdit)edit).getOldBand()) continue;
            this.undoEdits.remove(edit);
            --i;
        }
        if (this.undoEdits.size() > 0) {
            AggregatedUndoableEdit masterEdit = new AggregatedUndoableEdit("Move");
            for (int i = 0; i < this.undoEdits.size(); ++i) {
                edit = this.undoEdits.get(i);
                masterEdit.concatenate(edit);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    List<Object> selectedElements = Arrays.asList(scene.getSelectedObjects().toArray());
                    for (Object obj : selectedElements) {
                        if (ReportAlignWithMoveStrategyProvider.this.theSelectedElements.contains(obj)) continue;
                        IReportManager.getInstance().removeSelectedObject(obj);
                    }
                    for (int sIndex = 0; sIndex < ReportAlignWithMoveStrategyProvider.this.theSelectedElements.size(); ++sIndex) {
                        JRDesignElement selectedelement = ReportAlignWithMoveStrategyProvider.this.theSelectedElements.get(sIndex);
                        if (selectedElements.contains(selectedelement)) continue;
                        IReportManager.getInstance().addSelectedObject(selectedelement);
                    }
                }
            });
            IReportManager.getInstance().addUndoableEdit(masterEdit);
        }
        this.hide();
    }

    public Point getOriginalLocation(Widget widget) {
        return ActionFactory.createDefaultMoveProvider().getOriginalLocation(widget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNewLocation(Widget widget, Point location) {
        Point p = widget.getPreferredLocation();
        Point delta = new Point(location);
        delta.translate(-p.x, -p.y);
        if (delta.x == 0 && delta.y == 0) {
            return;
        }
        List selectedElements = ((AbstractReportObjectScene)widget.getScene()).getSelectionLayer().getChildren();
        ArrayList<Widget> changedWidgets = new ArrayList<Widget>();
        for (Widget w : selectedElements) {
            JRDesignElementWidget dew;
            if (!w.isVisible() || changedWidgets.contains(dew = ((SelectionWidget)w).getRealWidget())) continue;
            Point loc = w.getPreferredLocation();
            loc.translate(delta.x, delta.y);
            w.setPreferredLocation(loc);
            Point dewloc = dew.getPreferredLocation();
            dewloc.translate(delta.x, delta.y);
            dewloc = dew.convertLocalToModelLocation(dewloc);
            boolean b = dew.setChanging(true);
            try {
                dew.getElement().setX(dewloc.x);
                dew.getElement().setY(dewloc.y);
                this.findEdit(dew.getElement(), "X").setNewValue(dewloc.x);
                this.findEdit(dew.getElement(), "Y").setNewValue(dewloc.y);
            }
            finally {
                dew.setChanging(b);
            }
            dew.updateBounds();
            if (dew.getChildrenElements() != null) {
                this.updateChildren(dew, (AbstractReportObjectScene)dew.getScene(), changedWidgets);
            }
            changedWidgets.add(dew);
        }
    }

    private ObjectPropertyUndoableEdit findEdit(Object obj, String property) {
        for (AggregatedUndoableEdit theEdit : this.undoEdits) {
            ObjectPropertyUndoableEdit edit;
            if (!(theEdit instanceof ObjectPropertyUndoableEdit) || (edit = (ObjectPropertyUndoableEdit)theEdit).getObject() != obj || !edit.getProperty().equals(property)) continue;
            return edit;
        }
        return null;
    }

    private void updateChildren(JRDesignElementWidget dew, AbstractReportObjectScene scene, ArrayList<Widget> changedWidgets) {
        List listOfElements = dew.getChildrenElements();
        this.updateChildren(listOfElements, scene, changedWidgets);
    }

    private void updateChildren(List listOfElements, AbstractReportObjectScene scene, ArrayList<Widget> changedWidgets) {
        for (int i = 0; i < listOfElements.size(); ++i) {
            if (listOfElements.get(i) instanceof JRDesignElement) {
                JRDesignElement element = (JRDesignElement)listOfElements.get(i);
                JRDesignElementWidget w = (JRDesignElementWidget)scene.findWidget(element);
                if (w == null || changedWidgets.contains(w)) continue;
                w.updateBounds();
                w.getSelectionWidget().updateBounds();
                if (w.getChildrenElements() != null) {
                    this.updateChildren(w, scene, changedWidgets);
                }
                changedWidgets.add(w);
                continue;
            }
            if (!(listOfElements.get(i) instanceof JRDesignElementGroup)) continue;
            this.updateChildren(((JRDesignElementGroup)listOfElements.get(i)).getChildren(), scene, changedWidgets);
        }
    }

    private AggregatedUndoableEdit findBestNewParent(JRDesignElementWidget dew) {
        if (!(dew.getScene() instanceof ReportObjectScene)) {
            return null;
        }
        boolean lookForBestNewParent = true;
        boolean forceLookForBestNewParent = false;
        if (this.getAction() != null) {
            lookForBestNewParent = (this.getAction().getModifiersEx() & 0x80) != 128;
            boolean bl = forceLookForBestNewParent = (this.getAction().getModifiersEx() & 0x40) == 64;
        }
        if (!lookForBestNewParent) {
            return null;
        }
        if (!this.moveEnabled) {
            return null;
        }
        JRDesignElement ele = dew.getElement();
        Point localLocation = new Point(dew.getLocation());
        JasperDesign jd = ((AbstractReportObjectScene)dew.getScene()).getJasperDesign();
        Rectangle parentBounds = ModelUtils.getParentBounds(jd, dew.getElement());
        if (!forceLookForBestNewParent && parentBounds.contains(new Point(ele.getX() + parentBounds.x, ele.getY() + parentBounds.y))) {
            return null;
        }
        ReportObjectScene ros = (ReportObjectScene)dew.getScene();
        JRDesignBand newParent = null;
        Point delta = new Point(0, 0);
        JRDesignBand newBand = ModelUtils.getBandAt(jd, localLocation);
        if (newBand != null) {
            newParent = newBand;
            int y1 = ModelUtils.getBandLocation((JRBand)newBand, jd);
            int x1 = jd.getLeftMargin();
            delta = new Point(localLocation.x - x1, localLocation.y - y1);
        }
        List widgets = ros.getElementsLayer().getChildren();
        for (Widget w : widgets) {
            Rectangle r;
            if (!(w instanceof JRDesignElementWidget) || !(((JRDesignElementWidget)w).getElement() instanceof JRDesignFrame) || ((JRDesignElementWidget)w).getElement() == ele || !(r = new Rectangle(w.getLocation(), w.getBounds().getSize())).contains(localLocation)) continue;
            newParent = (JRDesignFrame)((JRDesignElementWidget)w).getElement();
            int y1 = w.getLocation().y;
            int x1 = w.getLocation().x;
            delta = new Point(localLocation.x - x1, localLocation.y - y1);
        }
        if (newParent != null) {
            JRElementGroup oldElementGroup = dew.getElement().getElementGroup();
            AggregatedUndoableEdit undoEdit = new AggregatedUndoableEdit();
            int indexInChildrens = 0;
            if (oldElementGroup instanceof JRDesignFrame) {
                indexInChildrens = ((JRDesignFrame)oldElementGroup).getChildren().indexOf(ele);
                ((JRDesignFrame)oldElementGroup).getChildren().remove(ele);
            } else if (oldElementGroup instanceof JRDesignBand) {
                indexInChildrens = ((JRDesignBand)oldElementGroup).getChildren().indexOf(ele);
                ((JRDesignBand)oldElementGroup).getChildren().remove(ele);
            } else {
                return null;
            }
            ele.setX(delta.x);
            ele.setY(delta.y);
            ele.setElementGroup((JRElementGroup)newParent);
            undoEdit.addEdit(new DeleteElementUndoableEdit(ele, oldElementGroup, indexInChildrens));
            if (newParent instanceof JRDesignFrame) {
                ((JRDesignFrame)newParent).getChildren().add(ele);
            } else if (newParent instanceof JRDesignBand) {
                newParent.getChildren().add(ele);
            }
            undoEdit.addEdit(new AddElementUndoableEdit(ele, newParent));
            if (oldElementGroup instanceof JRDesignFrame) {
                ((JRDesignFrame)oldElementGroup).getEventSupport().firePropertyChange("children", null, null);
            } else if (oldElementGroup instanceof JRDesignBand) {
                ((JRDesignBand)oldElementGroup).getEventSupport().firePropertyChange("children", null, null);
            }
            if (newParent instanceof JRDesignFrame) {
                ((JRDesignFrame)newParent).getEventSupport().firePropertyChange("children", null, null);
            } else if (newParent instanceof JRDesignBand) {
                newParent.getEventSupport().firePropertyChange("children", null, null);
            }
            return undoEdit;
        }
        return null;
    }

    public ExMoveAction getAction() {
        return this.action;
    }

    public void setAction(ExMoveAction action) {
        this.action = action;
    }
}

