/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.actions.AbstractOrderChangeAction;
import com.jaspersoft.ireport.designer.outline.nodes.ElementGroupNode;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.locale.I18n;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;

public final class SendElementToBackAction
extends AbstractOrderChangeAction {
    public String getName() {
        return I18n.getString("SendElementToBackAction.Name");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.FALSE);
    }

    protected String iconResource() {
        return "com/jaspersoft/ireport/designer/resources/formatting/sendtoback.png";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        Node parent = activatedNodes[0].getParentNode();
        Children childrens = parent.getChildren();
        int[] perms = new int[childrens.getNodesCount()];
        for (int i = 0; i < perms.length; ++i) {
            perms[i] = i;
        }
        int[] indexes = new int[activatedNodes.length];
        List<Node> allNodes = Arrays.asList(childrens.getNodes());
        for (int i = 0; i < activatedNodes.length; ++i) {
            indexes[i] = allNodes.indexOf(activatedNodes[i]);
        }
        Arrays.sort(indexes);
        int backPosition = 0;
        for (int i = 0; i < indexes.length; ++i) {
            int currentPos = perms[indexes[i]];
            for (int j = 0; j < perms.length; ++j) {
                if (perms[j] >= currentPos || perms[j] < backPosition) continue;
                int n = j;
                perms[n] = perms[n] + 1;
            }
            perms[indexes[i]] = backPosition++;
        }
        AbstractOrderChangeAction.fireChangeOrder();
        ((Index.KeysChildren)parent.getChildren()).getIndex().reorder(perms);
    }

    public void swap(int[] perms, int a, int b) {
        int indexOfA = -1;
        int indexOfB = -1;
        for (int i = 0; i < perms.length; ++i) {
            if (perms[i] == a) {
                indexOfA = i;
            }
            if (perms[i] == b) {
                indexOfB = b;
            }
            if (indexOfA == -1 || indexOfB == -1) continue;
            perms[indexOfA] = b;
            perms[indexOfB] = a;
            return;
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return false;
        }
        Node parent = activatedNodes[0].getParentNode();
        if (parent == null) {
            return false;
        }
        for (int i = 0; i < activatedNodes.length; ++i) {
            JRDesignElement element;
            JRElementGroup group;
            JRDesignElement multiaxischart;
            if (activatedNodes[i].getParentNode() != parent) {
                return false;
            }
            if (activatedNodes[i].getParentNode() != null && activatedNodes[i].getParentNode() instanceof ElementNode && (multiaxischart = ((ElementNode)activatedNodes[i].getParentNode()).getElement()) instanceof JRDesignChart && ((JRDesignChart)multiaxischart).getChartType() == 19) {
                return false;
            }
            if (!(activatedNodes[i] instanceof ElementNode ? (group = (element = ((ElementNode)activatedNodes[i]).getElement()).getElementGroup()).getChildren().indexOf(element) == 0 : activatedNodes[i] instanceof ElementGroupNode && (group = (element = ((ElementGroupNode)activatedNodes[i]).getElementGroup()).getElementGroup()).getChildren().indexOf(element) == 0)) continue;
            return false;
        }
        return true;
    }
}

