/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.compiler.prompt;

import com.jaspersoft.ireport.designer.compiler.prompt.DateRangeFormatter;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.text.DefaultFormatterFactory;
import net.sf.jasperreports.types.date.DateRangeBuilder;
import org.jdesktop.swingx.JXDatePickerFormatter;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.calendar.DateSpan;
import org.jdesktop.swingx.calendar.JXMonthView;

public class DateRangeDatePicker
extends JComponent {
    private JFormattedTextField _dateField;
    private JXDatePickerPopup _popup;
    private JPanel _linkPanel;
    private long _linkDate;
    private MessageFormat _linkFormat;
    private JButton _popupButton;
    private int _popupButtonWidth = 20;
    private JXMonthView _monthView = new JXMonthView();
    private Handler _handler;
    private String _actionCommand = "selectionChanged";

    public DateRangeDatePicker() {
        this(System.currentTimeMillis());
    }

    public void setFormats(DateFormat[] formats) {
        this.getEditor().setFormatterFactory(new DefaultFormatterFactory(new DateRangeFormatter(formats)));
    }

    public DateRangeDatePicker(long millis) {
        this._monthView.setTraversable(true);
        this._dateField = new JFormattedTextField((JFormattedTextField.AbstractFormatter)new JXDatePickerFormatter());
        this._dateField.setName("dateField");
        this._dateField.setBorder(null);
        this._handler = new Handler();
        this._popupButton = new JButton();
        this._popupButton.setName("popupButton");
        this._popupButton.setRolloverEnabled(false);
        this._popupButton.addMouseListener(this._handler);
        this._popupButton.addMouseMotionListener(this._handler);
        this._popupButton.setFocusable(false);
        KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0, false);
        InputMap inputMap = this._dateField.getInputMap(0);
        inputMap.put(enterKey, "COMMIT_EDIT");
        ActionMap actionMap = this._dateField.getActionMap();
        actionMap.put("COMMIT_EDIT", new CommitEditAction());
        KeyStroke spaceKey = KeyStroke.getKeyStroke(32, 0, false);
        inputMap = this._popupButton.getInputMap(0);
        inputMap.put(spaceKey, "TOGGLE_POPUP");
        actionMap = this._popupButton.getActionMap();
        actionMap.put("TOGGLE_POPUP", new TogglePopupAction());
        this.add(this._dateField);
        this.add(this._popupButton);
        this.updateUI();
        this._linkDate = System.currentTimeMillis();
        this._linkPanel = new TodayPanel();
        this._dateField.setValue(new Date(millis));
        this.getEditor().setFormatterFactory(new DefaultFormatterFactory(new DateRangeFormatter()));
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((JComponent)this.getComponent(i)).getInputMap().remove(spaceKey);
            ((JComponent)this.getComponent(i)).getInputMap(0).remove(spaceKey);
        }
        this.getInputMap().remove(spaceKey);
        this.getInputMap(0).remove(spaceKey);
        spaceKey = KeyStroke.getKeyStroke(32, 2, false);
    }

    public void updateUI() {
        int cols = UIManager.getInt("JXDatePicker.numColumns");
        if (cols == -1) {
            cols = 10;
        }
        this._dateField.setColumns(cols);
        String str = UIManager.getString("JXDatePicker.arrowDown.tooltip");
        if (str == null) {
            str = "Show Calendar";
        }
        this._popupButton.setToolTipText(str);
        Icon icon = UIManager.getIcon("JXDatePicker.arrowDown.image");
        if (icon == null) {
            icon = (Icon)UIManager.get("Tree.expandedIcon");
        }
        this._popupButton.setIcon(icon);
        Border border = UIManager.getBorder("JXDatePicker.border");
        if (border == null) {
            border = BorderFactory.createCompoundBorder(LineBorder.createGrayLineBorder(), BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }
        this._dateField.setBorder(border);
        String formatString = UIManager.getString("JXDatePicker.linkFormat");
        if (formatString == null) {
            formatString = "Today is {0,date, dd MMMM yyyy}";
        }
        this._linkFormat = new MessageFormat(formatString);
    }

    public void setFormats(String[] formats) {
        DateFormat[] dateFormats = new DateFormat[formats.length];
        for (int counter = formats.length - 1; counter >= 0; --counter) {
            dateFormats[counter] = new SimpleDateFormat(formats[counter]);
        }
        this.setFormats(dateFormats);
    }

    public DateFormat[] getFormats() {
        JFormattedTextField.AbstractFormatter formatter;
        JFormattedTextField.AbstractFormatterFactory factory = this._dateField.getFormatterFactory();
        if (factory != null && (formatter = factory.getFormatter(this._dateField)) instanceof JXDatePickerFormatter) {
            return ((JXDatePickerFormatter)formatter).getFormats();
        }
        return null;
    }

    public void setDate(Date date) {
        this._dateField.setValue(date);
    }

    public void setDateRangeExpression(String value) {
        this._dateField.setValue(value);
    }

    public String getDateRangeExpression() {
        if (this._dateField.getValue() instanceof String) {
            return (String)this._dateField.getValue();
        }
        return null;
    }

    public void setDateInMillis(long millis) {
        this._dateField.setValue(new Date(millis));
    }

    public Date getDate() {
        return this.getFieldDate();
    }

    public long getDateInMillis() {
        return this.getFieldDate().getTime();
    }

    public JXMonthView getMonthView() {
        return this._monthView;
    }

    public void setMonthView(JXMonthView monthView) {
        this._monthView = monthView;
        this._popup = null;
    }

    public void setLinkDate(long linkDate, String linkFormatString) {
        this._linkDate = linkDate;
        this._linkFormat = new MessageFormat(linkFormatString);
    }

    public JPanel getLinkPanel() {
        return this._linkPanel;
    }

    public void setLinkPanel(JPanel linkPanel) {
        if (this._popup != null) {
            this._popup.remove(this._linkPanel);
            this._popup.add((Component)linkPanel, "South");
        }
        this._linkPanel = linkPanel;
    }

    public JFormattedTextField getEditor() {
        return this._dateField;
    }

    public boolean isEditValid() {
        return this._dateField.isEditValid();
    }

    public void commitEdit() throws ParseException {
        this._dateField.commitEdit();
    }

    public void setEnabled(boolean value) {
        if (this.isEnabled() == value) {
            return;
        }
        super.setEnabled(value);
        this._dateField.setEnabled(value);
        this._popupButton.setEnabled(value);
    }

    public String getActionCommand() {
        return this._actionCommand;
    }

    public void setActionCommand(String actionCommand) {
        this._actionCommand = actionCommand;
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    protected void fireActionPerformed() {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                e = new ActionEvent(this, 1001, this._actionCommand);
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    public void doLayout() {
        int width = this.getWidth();
        int height = this.getHeight();
        Insets insets = this.getInsets();
        this._dateField.setBounds(insets.left, insets.bottom, width - this._popupButtonWidth, height);
        this._popupButton.setBounds(width - this._popupButtonWidth + insets.left, insets.bottom, this._popupButtonWidth, height);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension dim = this._dateField.getPreferredSize();
        dim.width += this._popupButton.getPreferredSize().width;
        Insets insets = this.getInsets();
        dim.width += insets.left + insets.right;
        dim.height += insets.top + insets.bottom;
        return dim;
    }

    protected Date getFieldDate() {
        if (this._dateField.getValue() == null) {
            this._dateField.setValue(new Date(this._linkDate));
            return (Date)this._dateField.getValue();
        }
        if (this._dateField.getValue() instanceof Date) {
            return (Date)this._dateField.getValue();
        }
        if (this._dateField.getValue() instanceof String) {
            DateRangeBuilder b = new DateRangeBuilder("" + this._dateField.getValue());
            return b.toDateRange().getStart();
        }
        return null;
    }

    private final class TodayPanel
    extends JXPanel {
        TodayPanel() {
            super((LayoutManager)new FlowLayout());
            JXHyperlink todayLink = new JXHyperlink((Action)new TodayAction());
            Color textColor = new Color(16, 66, 104);
            todayLink.setUnclickedColor(textColor);
            todayLink.setClickedColor(textColor);
            this.add((Component)todayLink);
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(new Color(187, 187, 187));
            g.drawLine(0, 0, this.getWidth(), 0);
            g.setColor(new Color(221, 221, 221));
            g.drawLine(0, 1, this.getWidth(), 1);
        }

        private final class TodayAction
        extends AbstractAction {
            TodayAction() {
                super(DateRangeDatePicker.this._linkFormat.format(new Object[]{new Date(DateRangeDatePicker.this._linkDate)}));
            }

            public void actionPerformed(ActionEvent ae) {
                DateSpan span = new DateSpan(DateRangeDatePicker.this._linkDate, DateRangeDatePicker.this._linkDate);
                DateRangeDatePicker.this._monthView.ensureDateVisible(span.getStart());
            }
        }
    }

    protected class JXDatePickerPopup
    extends JPopupMenu
    implements ActionListener {
        public JXDatePickerPopup() {
            DateRangeDatePicker.this._monthView.addActionListener((ActionListener)this);
            this.setLayout(new BorderLayout());
            this.add((Component)DateRangeDatePicker.this._monthView, "Center");
            if (DateRangeDatePicker.this._linkPanel != null) {
                this.add((Component)DateRangeDatePicker.this._linkPanel, "South");
            }
        }

        public void actionPerformed(ActionEvent ev) {
            String command = ev.getActionCommand();
            DateRangeDatePicker.this._monthView;
            if ("monthViewCommit".equals(command)) {
                DateRangeDatePicker.this._dateField.setValue(DateRangeDatePicker.this._monthView.getSelectedDate());
                DateRangeDatePicker.this._popup.setVisible(false);
                DateRangeDatePicker.this.fireActionPerformed();
            }
        }
    }

    private class Handler
    implements MouseListener,
    MouseMotionListener {
        private boolean _forwardReleaseEvent = false;

        private Handler() {
        }

        public void mouseClicked(MouseEvent ev) {
        }

        public void mousePressed(MouseEvent ev) {
            if (!DateRangeDatePicker.this.isEnabled()) {
                return;
            }
            if (DateRangeDatePicker.this._dateField.isEditValid()) {
                try {
                    DateRangeDatePicker.this._dateField.commitEdit();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            this.toggleShowPopup();
        }

        public void mouseReleased(MouseEvent ev) {
            if (this._forwardReleaseEvent) {
                ev = SwingUtilities.convertMouseEvent(DateRangeDatePicker.this._popupButton, ev, (Component)DateRangeDatePicker.this._monthView);
                DateRangeDatePicker.this._monthView.dispatchEvent((AWTEvent)ev);
                this._forwardReleaseEvent = false;
            }
        }

        public void mouseEntered(MouseEvent ev) {
        }

        public void mouseExited(MouseEvent ev) {
        }

        public void mouseDragged(MouseEvent ev) {
            this._forwardReleaseEvent = true;
            if (!DateRangeDatePicker.this._popup.isShowing()) {
                return;
            }
            ev = SwingUtilities.convertMouseEvent(DateRangeDatePicker.this._popupButton, ev, (Component)DateRangeDatePicker.this._monthView);
            DateRangeDatePicker.this._monthView.dispatchEvent((AWTEvent)ev);
        }

        public void mouseMoved(MouseEvent ev) {
        }

        public void toggleShowPopup() {
            if (DateRangeDatePicker.this._popup == null) {
                DateRangeDatePicker.this._popup = new JXDatePickerPopup();
            }
            if (!DateRangeDatePicker.this._popup.isVisible()) {
                DateSpan span = new DateSpan(DateRangeDatePicker.this.getFieldDate(), DateRangeDatePicker.this.getFieldDate());
                DateRangeDatePicker.this._monthView.setSelectedDateSpan(span);
                DateRangeDatePicker.this._monthView.ensureDateVisible(DateRangeDatePicker.this.getFieldDate().getTime());
                DateRangeDatePicker.this._popup.show(DateRangeDatePicker.this, 0, DateRangeDatePicker.this.getHeight());
            } else {
                DateRangeDatePicker.this._popup.setVisible(false);
            }
        }
    }

    private class CommitEditAction
    extends AbstractAction {
        public CommitEditAction() {
            super("CommitEditPopup");
        }

        public void actionPerformed(ActionEvent ev) {
            try {
                DateRangeDatePicker.this._dateField.commitEdit();
                DateRangeDatePicker.this._dateField.setValue(DateRangeDatePicker.this._dateField.getValue());
                DateRangeDatePicker.this.fireActionPerformed();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private class TogglePopupAction
    extends AbstractAction {
        public TogglePopupAction() {
            super("TogglePopup");
        }

        public void actionPerformed(ActionEvent ev) {
            DateRangeDatePicker.this._handler.toggleShowPopup();
        }
    }
}

