/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.data.fieldsproviders;

import com.jaspersoft.ireport.designer.FieldsProvider;
import com.jaspersoft.ireport.designer.FieldsProviderEditor;
import com.jaspersoft.ireport.designer.IRLocalJasperReportsContext;
import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.connection.JDBCNBConnection;
import com.jaspersoft.ireport.designer.data.ReportQueryDialog;
import com.jaspersoft.ireport.designer.data.fieldsproviders.QueryBuilderDialog;
import com.jaspersoft.ireport.designer.data.fieldsproviders.SQLFieldsProviderEditor;
import com.jaspersoft.ireport.designer.data.fieldsproviders.SimpleValueParameter;
import java.awt.Dialog;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JDialog;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.query.JRJdbcQueryExecuter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLFieldsProvider
implements FieldsProvider {
    public static boolean useVisualDesigner = true;

    @Override
    public boolean supportsGetFieldsOperation() {
        return true;
    }

    @Override
    public JRField[] getFields(IReportConnection irConn, JRDataset reportDataset, Map parameters) throws JRException, UnsupportedOperationException {
        block29: {
            String error_msg = "";
            Connection con = null;
            JRJdbcQueryExecuter qe = null;
            if (irConn == null || !irConn.isJDBCConnection()) {
                throw new JRException("The active connection is not of type JDBC. Activate a JDBC connection first.");
            }
            try {
                Map<String, JRValueParameter> tmpMap = SQLFieldsProvider.convertMap(reportDataset, parameters);
                con = irConn.getConnection();
                tmpMap.put("REPORT_CONNECTION", new SimpleValueParameter(con));
                tmpMap.put("REPORT_PARAMETERS_MAP", new SimpleValueParameter(new HashMap()));
                tmpMap.put("REPORT_MAX_COUNT", new SimpleValueParameter(null));
                qe = new JRJdbcQueryExecuter((JasperReportsContext)IRLocalJasperReportsContext.getInstance(), reportDataset, tmpMap);
                qe.createDatasource();
                ResultSet rs = qe.getResultSet();
                if (rs == null) break block29;
                ResultSetMetaData metaData = rs.getMetaData();
                int cc = metaData.getColumnCount();
                HashSet<String> colset = new HashSet<String>();
                ArrayList<JRDesignField> columns = new ArrayList<JRDesignField>(cc);
                for (int i = 1; i <= cc; ++i) {
                    String name = metaData.getColumnLabel(i);
                    if (colset.contains(name)) continue;
                    colset.add(name);
                    JRDesignField field = new JRDesignField();
                    field.setName(name);
                    field.setValueClassName(SQLFieldsProvider.getJdbcTypeClass(metaData, i));
                    try {
                        String catalog = metaData.getCatalogName(i);
                        String schema = metaData.getSchemaName(i);
                        String table = metaData.getTableName(i);
                        ResultSet rsmc = con.getMetaData().getColumns(catalog, schema, table, name);
                        if (rsmc.next()) {
                            field.setDescription(rsmc.getString("REMARKS"));
                        }
                    }
                    catch (SQLException se) {
                        se.printStackTrace();
                    }
                    columns.add(field);
                }
                JRField[] jRFieldArray = (JRField[])columns.toArray(new JRDesignField[columns.size()]);
                return jRFieldArray;
            }
            catch (IllegalArgumentException ie) {
                throw new JRException(ie.getMessage());
            }
            catch (NoClassDefFoundError ex) {
                ex.printStackTrace();
                error_msg = "NoClassDefFoundError!!\nCheck your classpath!";
                throw new JRException(error_msg);
            }
            catch (SQLException ex) {
                error_msg = "SQL problems:\n" + ex.getMessage();
                throw new JRException(error_msg);
            }
            catch (Exception ex) {
                if (ex.getCause() != null && ex.getCause() instanceof SQLException) {
                    ex.getCause().printStackTrace();
                    throw new JRException(ex.getCause());
                }
                ex.printStackTrace();
                error_msg = "General problem:\n" + ex.getMessage() + "\n\nCheck username and password; is the DBMS active ?!";
                throw new JRException(error_msg);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new JRException(t.getMessage());
            }
            finally {
                if (qe != null) {
                    try {
                        qe.close();
                    }
                    catch (Exception e) {}
                }
                if (con != null && !(irConn instanceof JDBCNBConnection)) {
                    try {
                        con.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return new JRField[0];
    }

    public static String getJdbcTypeClass(ResultSetMetaData rsmd, int t) {
        try {
            return SQLFieldsProvider.getJRFieldType(rsmd.getColumnClassName(t));
        }
        catch (SQLException ex) {
            try {
                int type = rsmd.getColumnType(t);
                switch (type) {
                    case -1: 
                    case 1: 
                    case 12: {
                        return "java.lang.String";
                    }
                    case 2: 
                    case 3: {
                        return "java.math.BigDecimal";
                    }
                    case -7: {
                        return "java.lang.Boolean";
                    }
                    case -6: {
                        return "java.lang.Byte";
                    }
                    case 5: {
                        return "java.lang.Short";
                    }
                    case 4: {
                        return "java.lang.Integer";
                    }
                    case -5: {
                        return "java.lang.Long";
                    }
                    case 7: {
                        return "java.lang.Real";
                    }
                    case 6: 
                    case 8: {
                        return "java.lang.Double";
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        return "java.lang.Byte[]";
                    }
                    case 91: {
                        return "java.sql.Date";
                    }
                    case 92: {
                        return "java.sql.Time";
                    }
                    case 93: {
                        return "java.sql.Timestamp";
                    }
                }
            }
            catch (SQLException ex2) {
                ex2.printStackTrace();
            }
            return Object.class.getName();
        }
    }

    public static String getJRFieldType(String type) {
        if (type == null) {
            return Object.class.getName();
        }
        if (type.equals(Boolean.TYPE.getName())) {
            return Boolean.class.getName();
        }
        if (type.equals(Byte.TYPE.getName())) {
            return Byte.class.getName();
        }
        if (type.equals(Integer.TYPE.getName())) {
            return Integer.class.getName();
        }
        if (type.equals(Long.TYPE.getName())) {
            return Long.class.getName();
        }
        if (type.equals(Double.TYPE.getName())) {
            return Double.class.getName();
        }
        if (type.equals(Float.TYPE.getName())) {
            return Float.class.getName();
        }
        if (type.equals(Short.TYPE.getName())) {
            return Short.class.getName();
        }
        if (type.startsWith("[")) {
            return Object.class.getName();
        }
        return type;
    }

    private Class findParameterClass(String paramName, JRDataset reportDataset) {
        JRParameter[] params;
        for (JRParameter p : params = reportDataset.getParameters()) {
            if (!p.getName().equals(paramName)) continue;
            try {
                return p.getValueClass();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public boolean supportsAutomaticQueryExecution() {
        return true;
    }

    @Override
    public boolean hasQueryDesigner() {
        return useVisualDesigner;
    }

    @Override
    public boolean hasEditorComponent() {
        return true;
    }

    @Override
    public String designQuery(IReportConnection con, String query, ReportQueryDialog reportQueryDialog) throws JRException, UnsupportedOperationException {
        QueryBuilderDialog qbd = new QueryBuilderDialog((Dialog)(reportQueryDialog != null ? reportQueryDialog : new JDialog()), true);
        if (con.isJDBCConnection()) {
            qbd.setConnection(con.getConnection());
        }
        try {
            if (query != null && query.length() > 0) {
                qbd.setQuery(query);
            }
        }
        catch (Throwable ex) {
            if (reportQueryDialog != null) {
                reportQueryDialog.getJLabelStatusSQL().setText("I'm sorry, I'm unable to parse the query...");
                ex.printStackTrace();
            }
            ex.printStackTrace();
            return null;
        }
        qbd.setVisible(true);
        if (qbd.getDialogResult() == 0) {
            return qbd.getQuery();
        }
        return null;
    }

    @Override
    public FieldsProviderEditor getEditorComponent(ReportQueryDialog reportQueryDialog) {
        SQLFieldsProviderEditor dpe = new SQLFieldsProviderEditor();
        dpe.setReportQueryDialog(reportQueryDialog);
        return dpe;
    }

    public static Map<String, JRValueParameter> convertMap(JRDataset dataset, Map<String, ?> inmap) {
        HashMap<String, JRValueParameter> outmap = new HashMap<String, JRValueParameter>();
        for (String key : inmap.keySet()) {
            SimpleValueParameter svp = new SimpleValueParameter(inmap.get(key));
            for (JRParameter p : dataset.getParameters()) {
                if (p.getName() == null || !p.getName().equals(key)) continue;
                svp.setValueClassName(p.getValueClassName());
                break;
            }
            outmap.put(key, svp);
        }
        return outmap;
    }
}

