/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.ElementGridCell;
import net.sf.jasperreports.engine.export.EmptyGridCell;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.Grid;
import net.sf.jasperreports.engine.export.GridCellSize;
import net.sf.jasperreports.engine.export.GridCellStyle;
import net.sf.jasperreports.engine.export.GridRow;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.OccupiedGridCell;
import net.sf.jasperreports.engine.export.PrintElementIndex;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRGridLayout {
    private static final Log log = LogFactory.getLog(JRGridLayout.class);
    private final ExporterNature nature;
    private final List<JRPrintElement> elementList;
    private final Map<GridCellSize, GridCellSize> cellSizes;
    private final Map<GridCellStyle, GridCellStyle> cellStyles;
    private final Map<Pair<GridCellSize, GridCellStyle>, EmptyGridCell> emptyCells;
    private int width;
    private int height;
    private int offsetX;
    private int offsetY;
    private CutsInfo xCuts;
    private CutsInfo yCuts;
    private Grid grid;
    private Map<BoxKey, JRLineBox> boxesCache;
    private boolean hasTopMargin = true;
    private boolean hasBottomMargin = true;
    private boolean hasLeftMargin = true;
    private boolean hasRightMargin = true;
    private boolean isNested;

    public JRGridLayout(ExporterNature nature, List<JRPrintElement> elements, int width, int height, int offsetX, int offsetY) {
        this(nature, elements, width, height, offsetX, offsetY, null);
    }

    public JRGridLayout(ExporterNature nature, List<JRPrintElement> elements, int width, int height, int offsetX, int offsetY, CutsInfo xCuts) {
        this.nature = nature;
        this.elementList = elements;
        this.cellSizes = new HashMap<GridCellSize, GridCellSize>();
        this.cellStyles = new HashMap<GridCellStyle, GridCellStyle>();
        this.emptyCells = new HashMap<Pair<GridCellSize, GridCellStyle>, EmptyGridCell>();
        this.height = height;
        this.width = width;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.xCuts = xCuts;
        this.boxesCache = new HashMap<BoxKey, JRLineBox>();
        this.layoutGrid(null, elements);
    }

    protected JRGridLayout(JRGridLayout parent, List<JRPrintElement> elements, int width, int height, int offsetX, int offsetY, PrintElementIndex parentElementIndex) {
        this.nature = parent.nature;
        this.elementList = parent.elementList;
        this.cellSizes = parent.cellSizes;
        this.cellStyles = parent.cellStyles;
        this.emptyCells = parent.emptyCells;
        this.height = height;
        this.width = width;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.isNested = true;
        this.boxesCache = new HashMap<BoxKey, JRLineBox>();
        this.layoutGrid(parentElementIndex, elements);
    }

    public JRPrintElement getElement(PrintElementIndex parentIndex, int index) {
        JRPrintElement element;
        if (parentIndex == null) {
            element = this.elementList.get(index);
        } else {
            JRPrintFrame parentFrame = (JRPrintFrame)this.getElement(parentIndex.getParentIndex(), parentIndex.getIndex());
            element = parentFrame.getElements().get(index);
        }
        return element;
    }

    protected void layoutGrid(PrintElementIndex parentElementIndex, List<JRPrintElement> elements) {
        boolean createXCuts = this.xCuts == null;
        this.xCuts = createXCuts ? new CutsInfo() : this.xCuts;
        CutsInfo cutsInfo = this.yCuts = this.nature.isIgnoreLastRow() ? new CutsInfo(0) : new CutsInfo(this.height);
        if (!this.isNested && this.nature.isIgnorePageMargins()) {
            this.setMargins(elements);
            if (createXCuts && this.hasLeftMargin) {
                this.xCuts.removeCutOffset(0);
            }
            if (this.hasTopMargin) {
                this.yCuts.removeCutOffset(0);
            }
            if (this.hasBottomMargin) {
                this.yCuts.removeCutOffset(this.height);
            }
        }
        this.createCuts(elements, this.offsetX, this.offsetY, createXCuts);
        if (!(!createXCuts || !this.isNested && (this.nature.isIgnorePageMargins() && this.hasRightMargin || this.xCuts.hasCuts() && this.xCuts.getLastCutOffset() >= this.width))) {
            this.xCuts.addCutOffset(this.width);
        }
        this.xCuts.use();
        this.yCuts.use();
        int colCount = Math.max(this.xCuts.size() - 1, 0);
        int rowCount = Math.max(this.yCuts.size() - 1, 0);
        this.grid = new Grid(rowCount, colCount);
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < colCount; ++col) {
                GridCellSize size = this.cellSize(this.xCuts.getCutOffset(col + 1) - this.xCuts.getCutOffset(col), this.yCuts.getCutOffset(row + 1) - this.yCuts.getCutOffset(row), 1, 1);
                this.grid.set(row, col, this.emptyCell(size, null));
            }
        }
        this.setGridElements(parentElementIndex, elements, this.offsetX, this.offsetY, 0, 0, rowCount, colCount);
        this.width = this.xCuts.getTotalLength();
        this.height = this.yCuts.getTotalLength();
    }

    protected GridCellSize cellSize(int width, int height, int colSpan, int rowSpan) {
        GridCellSize key = new GridCellSize(width, height, colSpan, rowSpan);
        GridCellSize size = this.cellSizes.get(key);
        if (size == null) {
            size = key;
            this.cellSizes.put(key, size);
            if (log.isTraceEnabled()) {
                log.trace((Object)(this + " added cell size " + size));
            }
        }
        return size;
    }

    protected void createCuts(List<JRPrintElement> elements, int elementOffsetX, int elementOffsetY, boolean createXCuts) {
        for (JRPrintElement element : elements) {
            if (!this.nature.isToExport(element)) continue;
            if (createXCuts) {
                this.xCuts.addCutOffset(element.getX() + elementOffsetX);
                this.xCuts.addCutOffset(element.getX() + element.getWidth() + elementOffsetX);
            }
            this.yCuts.addCutOffset(element.getY() + elementOffsetY);
            this.yCuts.addCutOffset(element.getY() + element.getHeight() + elementOffsetY);
            JRPrintFrame frame = element instanceof JRPrintFrame ? (JRPrintFrame)element : null;
            if (frame == null || !this.nature.isDeep(frame)) continue;
            this.createCuts(frame.getElements(), element.getX() + elementOffsetX + frame.getLineBox().getLeftPadding(), element.getY() + elementOffsetY + frame.getLineBox().getTopPadding(), createXCuts);
        }
    }

    protected void setMargins(List<JRPrintElement> elements) {
        for (JRPrintElement element : elements) {
            if (!this.nature.isToExport(element)) continue;
            if (this.hasLeftMargin && element.getX() <= 0) {
                this.hasLeftMargin = false;
            }
            if (this.hasRightMargin && element.getX() >= this.width - element.getWidth()) {
                this.hasRightMargin = false;
            }
            if (this.hasTopMargin && element.getY() <= 0) {
                this.hasTopMargin = false;
            }
            if (!this.hasBottomMargin || element.getY() < this.height - element.getHeight()) continue;
            this.hasBottomMargin = false;
        }
    }

    protected void setGridElements(PrintElementIndex parentIndex, List<JRPrintElement> elements, int elementOffsetX, int elementOffsetY, int startRow, int startCol, int endRow, int endCol) {
        ListIterator<JRPrintElement> it = elements.listIterator(elements.size());
        while (it.hasPrevious()) {
            JRPrintFrame frame;
            JRPrintElement element = it.previous();
            int elementIndex = it.nextIndex();
            if (!this.nature.isToExport(element)) continue;
            int x = element.getX() + elementOffsetX;
            int y = element.getY() + elementOffsetY;
            int col1 = this.xCuts.indexOfCutOffset(x);
            int row1 = this.yCuts.indexOfCutOffset(y);
            int col2 = this.xCuts.indexOfCutOffset(x + element.getWidth());
            int row2 = this.yCuts.indexOfCutOffset(y + element.getHeight());
            if (this.isOverlap(row1, col1, row2, col2)) continue;
            JRPrintFrame jRPrintFrame = frame = element instanceof JRPrintFrame ? (JRPrintFrame)element : null;
            if (frame != null && this.nature.isDeep(frame)) {
                PrintElementIndex frameIndex = new PrintElementIndex(parentIndex, elementIndex);
                this.setGridElements(frameIndex, frame.getElements(), x + frame.getLineBox().getLeftPadding(), y + frame.getLineBox().getTopPadding(), row1, col1, row2, col2);
                this.setFrameCellsStyle(frame, row1, col1, row2, col2);
                continue;
            }
            this.setGridElement(element, parentIndex, elementIndex, row1, col1, row2, col2);
        }
        if (this.nature.isHorizontallyMergeEmptyCells()) {
            this.horizontallyMergeEmptyCells(startRow, startCol, endRow, endCol);
        }
    }

    protected EmptyGridCell emptyCell(GridCellSize size, GridCellStyle style) {
        Pair<GridCellSize, GridCellStyle> key = new Pair<GridCellSize, GridCellStyle>(size, style);
        EmptyGridCell cell = this.emptyCells.get(key);
        if (cell == null) {
            cell = new EmptyGridCell(size, style);
            this.emptyCells.put(key, cell);
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + " created empty cell for " + size + " and " + style));
            }
        }
        return cell;
    }

    protected void horizontallyMergeEmptyCells(int startRow, int startCol, int endRow, int endCol) {
        for (int row = startRow; row < endRow; ++row) {
            int col;
            int startSpan = -1;
            int spanWidth = 0;
            for (col = startCol; col < endCol; ++col) {
                JRExporterGridCell cell = this.grid.get(row, col);
                if (this.isEmpty(cell)) {
                    if (startSpan == -1) {
                        startSpan = col;
                    }
                    spanWidth += cell.getWidth();
                    continue;
                }
                if (startSpan != -1 && col - startSpan > 1) {
                    this.spanEmptyCell(row, startSpan, spanWidth, col - startSpan);
                }
                startSpan = -1;
                spanWidth = 0;
            }
            if (startSpan == -1 || col - startSpan <= 1) continue;
            this.spanEmptyCell(row, startSpan, spanWidth, col - startSpan);
        }
    }

    protected void spanEmptyCell(int row, int col, int spanWidth, int colSpan) {
        EmptyGridCell spanCell = (EmptyGridCell)this.grid.get(row, col);
        GridCellSize newSize = this.cellSize(spanWidth, spanCell.getHeight(), colSpan, spanCell.getRowSpan());
        this.grid.set(row, col, this.emptyCell(newSize, spanCell.getStyle()));
    }

    protected boolean isEmpty(JRExporterGridCell cell) {
        return cell.getType() == 1 && ((EmptyGridCell)cell).isEmpty();
    }

    protected boolean isOverlap(int row1, int col1, int row2, int col2) {
        boolean isOverlap;
        block4: {
            isOverlap = false;
            if (this.nature.isSpanCells()) {
                for (int row = row1; row < row2; ++row) {
                    for (int col = col1; col < col2; ++col) {
                        if (this.isEmpty(this.grid.get(row, col))) continue;
                        isOverlap = true;
                        break block4;
                    }
                }
            } else {
                isOverlap = !this.isEmpty(this.grid.get(row1, col1));
            }
        }
        return isOverlap;
    }

    protected void setGridElement(JRPrintElement element, PrintElementIndex parentIndex, int elementIndex, int row1, int col1, int row2, int col2) {
        this.yCuts.addUsage(row1, 1);
        this.xCuts.addUsage(col1, 1);
        int rowSpan = this.nature.isSpanCells() ? row2 - row1 : 1;
        int colSpan = this.nature.isSpanCells() ? col2 - col1 : 1;
        ElementGridCell gridCell = new ElementGridCell(this, parentIndex, elementIndex, this.cellSize(element.getWidth(), element.getHeight(), colSpan, rowSpan));
        this.nature.setXProperties(this.xCuts, element, row1, col1, row2, col2);
        this.nature.setYProperties(this.yCuts, element, row1, col1, row2, col2);
        if (this.nature.isSpanCells()) {
            OccupiedGridCell occupiedGridCell = new OccupiedGridCell(gridCell);
            for (int row = row1; row < row2; ++row) {
                for (int col = col1; col < col2; ++col) {
                    this.grid.set(row, col, occupiedGridCell);
                }
                this.yCuts.addUsage(row, 2);
            }
            for (int col = col1; col < col2; ++col) {
                this.xCuts.addUsage(col, 2);
            }
        }
        if (col2 - col1 != 0 && row2 - row1 != 0) {
            JRLineBox box = element instanceof JRBoxContainer ? ((JRBoxContainer)((Object)element)).getLineBox() : null;
            gridCell.setStyle(this.cellStyle(null, null, box));
            if (this.nature.isBreakBeforeRow(element)) {
                this.yCuts.addUsage(row1, 4);
            }
            if (this.nature.isBreakAfterRow(element)) {
                this.yCuts.addUsage(row1 + rowSpan, 4);
            }
            this.grid.set(row1, col1, gridCell);
        }
    }

    protected GridCellStyle cellStyle(Color backcolor, Color forecolor, JRLineBox box) {
        if (backcolor == null && forecolor == null && box == null) {
            return null;
        }
        GridCellStyle key = new GridCellStyle(backcolor, forecolor, box);
        GridCellStyle style = this.cellStyles.get(key);
        if (style == null) {
            style = key;
            this.cellStyles.put(key, style);
            if (log.isTraceEnabled()) {
                log.trace((Object)(this + " added cell style " + style));
            }
        }
        return style;
    }

    protected void setFrameCellsStyle(JRPrintFrame frame, int row1, int col1, int row2, int col2) {
        Color backcolor = frame.getModeValue() == ModeEnum.OPAQUE ? frame.getBackcolor() : null;
        for (int row = row1; row < row2; ++row) {
            for (int col = col1; col < col2; ++col) {
                Color cellForecolor;
                JRExporterGridCell cell = this.grid.get(row, col);
                boolean modifiedStyle = false;
                Color cellBackcolor = cell.getBackcolor();
                if (cellBackcolor == null && frame.getModeValue() == ModeEnum.OPAQUE) {
                    cellBackcolor = backcolor;
                    modifiedStyle = true;
                }
                if ((cellForecolor = cell.getForecolor()) == null) {
                    cellForecolor = frame.getForecolor();
                    modifiedStyle = true;
                }
                boolean keepLeft = col == col1;
                boolean keepRight = col == col2 - cell.getColSpan();
                boolean keepTop = row == row1;
                boolean keepBottom = row == row2 - cell.getRowSpan();
                JRLineBox cellBox = cell.getBox();
                if (keepLeft || keepRight || keepTop || keepBottom) {
                    BoxKey key = new BoxKey(frame.getLineBox(), cellBox, keepLeft, keepRight, keepTop, keepBottom);
                    JRLineBox modBox = this.boxesCache.get(key);
                    if (modBox == null) {
                        modBox = JRBoxUtil.copyBordersNoPadding(frame.getLineBox(), keepLeft, keepRight, keepTop, keepBottom, cellBox);
                        this.boxesCache.put(key, modBox);
                    }
                    cellBox = modBox;
                    modifiedStyle = true;
                }
                if (!modifiedStyle) continue;
                GridCellStyle newStyle = this.cellStyle(cellBackcolor, cellForecolor, cellBox);
                this.grid.set(row, col, this.changeStyle(cell, newStyle));
            }
        }
    }

    protected JRExporterGridCell changeStyle(JRExporterGridCell cell, GridCellStyle newStyle) {
        if (cell.getType() == 1) {
            return this.emptyCell(cell.getSize(), newStyle);
        }
        cell.setStyle(newStyle);
        return cell;
    }

    public Grid getGrid() {
        return this.grid;
    }

    public CutsInfo getXCuts() {
        return this.xCuts;
    }

    public CutsInfo getYCuts() {
        return this.yCuts;
    }

    public int getWidth() {
        return this.width;
    }

    public int getColumnWidth(int col) {
        return this.xCuts.getCutOffset(col + 1) - this.xCuts.getCutOffset(col);
    }

    public int getRowHeight(int row) {
        return this.yCuts.getCutOffset(row + 1) - this.yCuts.getCutOffset(row);
    }

    public int getMaxRowHeight(int rowIndex) {
        GridRow row = this.grid.getRow(rowIndex);
        int maxRowHeight = row.get(0).getHeight();
        int rowSize = row.size();
        for (int col = 0; col < rowSize; ++col) {
            JRExporterGridCell cell = row.get(col);
            if (cell.getType() == 2 || maxRowHeight >= cell.getHeight()) continue;
            maxRowHeight = cell.getHeight();
        }
        return maxRowHeight;
    }

    public static int getRowHeight(GridRow row) {
        int col;
        JRExporterGridCell firstCell = row.get(0);
        if (firstCell.getRowSpan() == 1 && firstCell.getType() != 2) {
            return firstCell.getHeight();
        }
        int rowHeight = 0;
        int minSpanIdx = 0;
        int colCount = row.size();
        for (col = 0; col < colCount; ++col) {
            JRExporterGridCell cell = row.get(col);
            if (cell.getType() == 2) continue;
            if (cell.getRowSpan() == 1) {
                rowHeight = cell.getHeight();
                break;
            }
            if (cell.getRowSpan() >= row.get(minSpanIdx).getRowSpan()) continue;
            minSpanIdx = col;
        }
        if (col >= colCount) {
            rowHeight = row.get(minSpanIdx).getHeight();
        }
        return rowHeight;
    }

    public static CutsInfo calculateXCuts(ExporterNature nature, List<JRPrintPage> pages, int startPageIndex, int endPageIndex, int width, int offsetX) {
        CutsInfo xCuts = new CutsInfo();
        for (int pageIndex = startPageIndex; pageIndex <= endPageIndex; ++pageIndex) {
            JRPrintPage page = pages.get(pageIndex);
            JRGridLayout.addXCuts(nature, page.getElements(), offsetX, xCuts);
        }
        int lastCut = xCuts.getLastCutOffset();
        if (lastCut < width) {
            xCuts.addCutOffset(width);
        }
        return xCuts;
    }

    protected static void addXCuts(ExporterNature nature, List<JRPrintElement> elementsList, int elementOffsetX, CutsInfo xCuts) {
        for (JRPrintElement element : elementsList) {
            if (!nature.isToExport(element)) continue;
            xCuts.addCutOffset(element.getX() + elementOffsetX);
            xCuts.addCutOffset(element.getX() + element.getWidth() + elementOffsetX);
            if (element instanceof JRPrintFrame) {
                JRPrintFrame frame = (JRPrintFrame)element;
                JRGridLayout.addXCuts(nature, frame.getElements(), element.getX() + elementOffsetX + frame.getLineBox().getLeftPadding(), xCuts);
            }
            nature.setXProperties(xCuts.getPropertiesMap(), element);
        }
    }

    protected static class BoxKey {
        final JRLineBox box;
        final JRLineBox cellBox;
        final boolean left;
        final boolean right;
        final boolean top;
        final boolean bottom;
        final int hashCode;

        BoxKey(JRLineBox box, JRLineBox cellBox, boolean left, boolean right, boolean top, boolean bottom) {
            this.box = box;
            this.cellBox = cellBox;
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
            int hash = box.hashCode();
            if (cellBox != null) {
                hash = 31 * hash + cellBox.hashCode();
            }
            hash = 31 * hash + (left ? 1231 : 1237);
            hash = 31 * hash + (right ? 1231 : 1237);
            hash = 31 * hash + (top ? 1231 : 1237);
            this.hashCode = hash = 31 * hash + (bottom ? 1231 : 1237);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            BoxKey b = (BoxKey)obj;
            return b.box.equals(this.box) && (b.cellBox == null ? this.cellBox == null : this.cellBox != null && b.cellBox.equals(this.cellBox)) && b.left == this.left && b.right == this.right && b.top == this.top && b.bottom == this.bottom;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

