/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.Arrays;

public class SortedIntList {
    private int size = 0;
    private int[] values = new int[64];

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index " + index + " out of bounds, size " + this.size);
        }
        return this.values[index];
    }

    public boolean add(int value) {
        int index;
        int idx = Arrays.binarySearch(this.values, 0, this.size, value);
        if (idx >= 0) {
            return false;
        }
        if (this.size >= this.values.length) {
            int newLength = this.values.length + (this.values.length >> 1);
            this.values = Arrays.copyOf(this.values, newLength);
        }
        if ((index = -idx - 1) < this.size) {
            System.arraycopy(this.values, index, this.values, index + 1, this.size - index);
        }
        this.values[index] = value;
        ++this.size;
        return true;
    }

    public boolean remove(int value) {
        int index = Arrays.binarySearch(this.values, 0, this.size, value);
        if (index < 0) {
            return false;
        }
        if (index < this.size - 1) {
            System.arraycopy(this.values, index + 1, this.values, index, this.size - index - 1);
        }
        --this.size;
        return true;
    }

    public int indexOf(int value) {
        int idx = Arrays.binarySearch(this.values, 0, this.size, value);
        if (idx < 0) {
            idx = -1;
        }
        return idx;
    }
}

