/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.diff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.netbeans.modules.xml.xdm.XDMModel;
import org.netbeans.modules.xml.xdm.diff.Add;
import org.netbeans.modules.xml.xdm.diff.Change;
import org.netbeans.modules.xml.xdm.diff.Delete;
import org.netbeans.modules.xml.xdm.diff.DiffFinder;
import org.netbeans.modules.xml.xdm.diff.Difference;
import org.netbeans.modules.xml.xdm.diff.NodeInfo;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.Element;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.NodeImpl;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeDiff {
    private XDMModel model;

    public void merge(XDMModel xDMModel, List<Difference> list) {
        Node node;
        Set set;
        Object object;
        this.model = xDMModel;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap<Integer, Node> hashMap3 = new HashMap<Integer, Node>();
        for (Difference object2 : list) {
            if (object2 instanceof Change) {
                object = (Change)object2;
                if (((Change)object).isAttributeChanged() || ((Change)object).isTokenChanged()) {
                    this.addDiffToMap(((Difference)object).getOldNodeInfo().getNode(), object, hashMap);
                }
                if (!((Change)object).isPositionChanged()) continue;
                this.addDiffToMap(object2.getOldNodeInfo().getParent(), object, hashMap2);
                continue;
            }
            this.addDiffToMap(object2.getOldNodeInfo().getParent(), object2, hashMap2);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object = this.getCurrentNode((Node)entry.getKey(), hashMap3);
            assert (object != null) : "target " + ((Node)entry.getKey()).getId() + "is no longer inTree";
            set = (Set)entry.getValue();
            node = this.applyChanges(set, (Node)object);
            assert (node.getId() == object.getId()) : "changed id should not change";
            hashMap3.put(node.getId(), node);
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            object = this.getCurrentNode((Node)entry.getKey(), hashMap3);
            assert (object != null) : "target " + ((Node)entry.getKey()).getId() + "is no longer inTree";
            set = (Set)entry.getValue();
            node = this.applyChildrenDiffs(set, (Node)object);
            assert (node.getId() == object.getId()) : "processed id should not change";
        }
    }

    private <T extends Difference> void addDiffToMap(Node node, T t, HashMap<Node, Set<T>> hashMap) {
        Set<T> set = hashMap.get(node);
        if (set == null) {
            set = new HashSet<T>();
            hashMap.put(node, set);
        }
        set.add(t);
    }

    private Node getCurrentNode(Node node, HashMap<Integer, Node> hashMap) {
        List<Node> list;
        Node node2 = hashMap.get(node.getId());
        if (!(node2 != null && node2.isInTree() || (list = DiffFinder.getPathToRoot(node)) == null || list.isEmpty())) {
            node2 = list.get(0);
            hashMap.put(node.getId(), node2);
        }
        return node2;
    }

    private Node applyChildrenDiffs(Set<Difference> set, Node node) {
        int n = node.getId();
        TreeMap<Integer, Difference> treeMap = new TreeMap<Integer, Difference>();
        for (Difference difference : set) {
            if (difference instanceof Delete) {
                this.delete(difference.getOldNodeInfo());
                node = difference.getNewParent();
                assert (n == node.getId());
                continue;
            }
            if (difference instanceof Add) {
                treeMap.put(difference.getNewNodeInfo().getPosition(), difference);
                continue;
            }
            if (!(difference instanceof Change)) continue;
            Change change = (Change)difference;
            assert (change.isPositionChanged() && change.getOldNodeInfo().getParent().getId() == node.getId());
            treeMap.put(change.getNewNodeInfo().getPosition(), change);
        }
        node = this.processAddOrReorder(node, treeMap);
        assert (n == node.getId());
        for (Difference difference : set) {
            difference.setNewParent(node);
            assert (this.getReleventDiffNodeInfo(difference).getNode().isInTree()) : "Processed child not in tree: " + difference;
        }
        return node;
    }

    private NodeInfo getReleventDiffNodeInfo(Difference difference) {
        if (difference instanceof Add) {
            return difference.getNewNodeInfo();
        }
        if (difference instanceof Change) {
            Change change = (Change)difference;
            if (change.isAttributeChanged() || change.isTokenChanged()) {
                return change.getNewNodeInfo();
            }
            return change.getOldNodeInfo();
        }
        if (difference instanceof Delete) {
            return difference.getOldNodeInfo();
        }
        throw new IllegalArgumentException("Invald diff type");
    }

    private List<Node> getChildrenNodes(Node node) {
        NodeList nodeList = node.getChildNodes();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            arrayList.add((Node)nodeList.item(i));
        }
        return arrayList;
    }

    private NodeInfo getReorderNodeInfo(Change change) {
        assert (change.isPositionChanged());
        if (change.isAttributeChanged() || change.isTokenChanged()) {
            return change.getNewNodeInfo();
        }
        return change.getOldNodeInfo();
    }

    private Node processAddOrReorder(Node node, SortedMap<Integer, Difference> sortedMap) {
        Map.Entry<Integer, Difference> entry3;
        Difference difference;
        Map.Entry<Integer, Difference> entry22;
        int n = node.getId();
        List<Node> list = this.getChildrenNodes(node);
        block0: for (Map.Entry<Integer, Difference> entry22 : sortedMap.entrySet()) {
            difference = entry22.getValue();
            if (!(difference instanceof Change) || list.remove(entry3 = this.getReorderNodeInfo((Change)difference).getNode())) continue;
            Iterator<Node> iterator = list.iterator();
            while (iterator.hasNext()) {
                Node node2 = iterator.next();
                if (node2.getId() != entry3.getId()) continue;
                iterator.remove();
                continue block0;
            }
        }
        for (Map.Entry<Integer, Difference> entry22 : sortedMap.entrySet()) {
            int n2;
            difference = entry22.getValue();
            if (difference instanceof Change) {
                entry3 = this.getReorderNodeInfo((Change)difference).getNode();
                n2 = difference.getNewNodeInfo().getPosition();
                list.add(n2, (Node)((Object)entry3));
                continue;
            }
            if (!(difference instanceof Add)) continue;
            this.add(node, (Add)difference);
            node = difference.getNewParent();
            assert (n == node.getId());
            entry3 = ((Add)difference).getNewNodeInfo().getNode();
            n2 = ((Add)difference).getNewNodeInfo().getPosition();
            list.add(n2, (Node)((Object)entry3));
        }
        assert (node.getChildNodes().getLength() == list.size()) : "Failed " + sortedMap.values();
        Object object = new int[list.size()];
        entry22 = node.getChildNodes();
        for (int i = 0; i < entry22.getLength(); ++i) {
            entry3 = (Node)entry22.item(i);
            int n3 = -1;
            for (int j = 0; j < list.size(); ++j) {
                Node node3 = list.get(j);
                if (entry3 != node3 && !node3.isEquivalentNode((Node)((Object)entry3))) continue;
                n3 = j;
                break;
            }
            assert (n3 > -1) : "current item " + i + " is not on worksheet";
            object[i] = n3;
        }
        node = this.reorder(node, (int[])object);
        for (Map.Entry<Integer, Difference> entry3 : sortedMap.entrySet()) {
            Change change;
            Difference difference2 = (Difference)entry3.getValue();
            if (!(difference2 instanceof Change) || !(change = (Change)difference2).isPositionChanged() || change.isAttributeChanged() || change.isTokenChanged()) continue;
            change.getNewNodeInfo().setNode(change.getOldNodeInfo().getNode());
        }
        return node;
    }

    private Node applyChanges(Set<Change> set, Node node) {
        Node node2 = null;
        for (Change change : set) {
            node = this.applyChange(change, node);
            node2 = change.getNewParent();
        }
        for (Change change : set) {
            change.getNewNodeInfo().setNode(node);
            change.setNewParent(node2);
        }
        return node;
    }

    private Node applyChange(Change change, Node node) {
        Node node2 = change.getOldNodeInfo().getNode();
        assert (node.getId() == node2.getId()) : "change target node id != old node id";
        Node node3 = change.getNewNodeInfo().getNode();
        if (change.isTokenChanged()) {
            NodeImpl nodeImpl = this.createClone(node);
            nodeImpl.copyTokens(node3);
            change.setNewParent(this.modify(node2, nodeImpl));
            node = nodeImpl;
        }
        if (change.isAttributeChanged()) {
            assert (node2.getLocalName().equals(node3.getLocalName()));
            this.applyAttrTokenChange(node, change);
        } else if (change.isTokenChanged()) {
            change.getNewNodeInfo().setNode(node);
        }
        return change.getNewNodeInfo().getNode();
    }

    private void applyAttrTokenChange(Node node, Change change) {
        NodeImpl nodeImpl;
        Cloneable cloneable;
        Node node2 = change.getNewNodeInfo().getNode();
        List<Node> list = DiffFinder.getPathToRoot(node);
        NamedNodeMap namedNodeMap = node2.getAttributes();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            cloneable = (Attribute)namedNodeMap.item(i);
            assert (((Attribute)cloneable).getName() != null);
            hashMap.put(((Attribute)cloneable).getName(), new Integer(i));
        }
        List<Change.AttributeDiff> list2 = change.getAttrChanges();
        cloneable = new TreeMap();
        for (Change.AttributeDiff object : list2) {
            Object object2;
            nodeImpl = object.getOldAttribute();
            Attribute attribute = object.getNewAttribute();
            if (nodeImpl != null) {
                if (attribute == null) {
                    list = this.model.delete(nodeImpl);
                    continue;
                }
                object2 = this.createClone(nodeImpl);
                ((NodeImpl)object2).copyTokens(attribute);
                list = this.model.modify(nodeImpl, (Node)object2);
                continue;
            }
            if (attribute == null) continue;
            object2 = (Integer)hashMap.get(attribute.getName());
            assert (object2 != null) : "Attribute " + attribute.getName() + " \n" + change + hashMap + " \n" + cloneable;
            cloneable.put(object2, attribute);
        }
        for (Map.Entry entry : cloneable.entrySet()) {
            nodeImpl = this.createCopy((Node)entry.getValue());
            node2 = (Element)list.get(0);
            list = this.model.add(node2, nodeImpl, (Integer)entry.getKey());
        }
        node2 = (Element)list.get(0);
        change.getNewNodeInfo().setNode(node2);
        assert (list.get(1).isInTree()) : "new parent not intree";
        change.setNewParent(list.get(1));
    }

    private NodeImpl createCopy(Node node) {
        NodeImpl nodeImpl = (NodeImpl)((NodeImpl)node).cloneNode(true, false);
        return nodeImpl;
    }

    private NodeImpl createClone(Node node) {
        NodeImpl nodeImpl = (NodeImpl)((NodeImpl)node).clone(false, false, false);
        return nodeImpl;
    }

    private void add(Node node, Difference difference) {
        NodeInfo nodeInfo = difference.getNewNodeInfo();
        int n = nodeInfo.getPosition();
        assert (n <= node.getChildNodes().getLength());
        NodeImpl nodeImpl = null;
        nodeImpl = difference instanceof Change ? this.createClone(nodeInfo.getNode()) : this.createCopy(nodeInfo.getNode());
        difference.setNewParent(this.model.add(node, nodeImpl, n).get(0));
        nodeInfo.setNode(nodeImpl);
    }

    private Node reorder(Node node, int[] nArray) {
        return this.model.reorderChildren(node, nArray).get(0);
    }

    private void delete(NodeInfo nodeInfo) {
        nodeInfo.setNewParent(this.model.delete(nodeInfo.getNode()).get(0));
    }

    private Node modify(Node node, Node node2) {
        List<Node> list = this.model.modify(node, node2);
        return list.isEmpty() ? null : list.get(0);
    }
}

