/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.FunctionSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.SessionState;

public final class SemanticAnalyzerFactory {
    static HashMap<Integer, HiveOperation> commandType = new HashMap();
    static HashMap<Integer, HiveOperation[]> tablePartitionCommandType = new HashMap();

    public static BaseSemanticAnalyzer get(HiveConf conf, ASTNode tree) throws SemanticException {
        if (tree.getToken() == null) {
            throw new RuntimeException("Empty Syntax Tree");
        }
        SemanticAnalyzerFactory.setSessionCommandType(commandType.get(tree.getToken().getType()));
        switch (tree.getToken().getType()) {
            case 171: {
                return new ExplainSemanticAnalyzer(conf);
            }
            case 64: {
                return new LoadSemanticAnalyzer(conf);
            }
            case 65: {
                return new ExportSemanticAnalyzer(conf);
            }
            case 66: {
                return new ImportSemanticAnalyzer(conf);
            }
            case 87: 
            case 89: 
            case 92: 
            case 94: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 113: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 151: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 225: 
            case 229: {
                return new DDLSemanticAnalyzer(conf);
            }
            case 96: {
                HiveOperation commandType = null;
                Integer type = ((ASTNode)tree.getChild(1)).getToken().getType();
                commandType = tree.getChild(0).getChildCount() > 1 ? tablePartitionCommandType.get(type)[1] : tablePartitionCommandType.get(type)[0];
                SemanticAnalyzerFactory.setSessionCommandType(commandType);
                return new DDLSemanticAnalyzer(conf);
            }
            case 162: 
            case 163: {
                return new FunctionSemanticAnalyzer(conf);
            }
        }
        return new SemanticAnalyzer(conf);
    }

    private static void setSessionCommandType(HiveOperation commandType) {
        if (SessionState.get() != null) {
            SessionState.get().setCommandType(commandType);
        }
    }

    private SemanticAnalyzerFactory() {
    }

    static {
        commandType.put(171, HiveOperation.EXPLAIN);
        commandType.put(64, HiveOperation.LOAD);
        commandType.put(65, HiveOperation.EXPORT);
        commandType.put(66, HiveOperation.IMPORT);
        commandType.put(87, HiveOperation.CREATEDATABASE);
        commandType.put(127, HiveOperation.DROPDATABASE);
        commandType.put(126, HiveOperation.SWITCHDATABASE);
        commandType.put(88, HiveOperation.CREATETABLE);
        commandType.put(128, HiveOperation.DROPTABLE);
        commandType.put(94, HiveOperation.DESCTABLE);
        commandType.put(95, HiveOperation.DESCFUNCTION);
        commandType.put(117, HiveOperation.MSCK);
        commandType.put(98, HiveOperation.ALTERTABLE_ADDCOLS);
        commandType.put(101, HiveOperation.ALTERTABLE_REPLACECOLS);
        commandType.put(99, HiveOperation.ALTERTABLE_RENAMECOL);
        commandType.put(97, HiveOperation.ALTERTABLE_RENAME);
        commandType.put(103, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(102, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(105, HiveOperation.ALTERTABLE_TOUCH);
        commandType.put(106, HiveOperation.ALTERTABLE_ARCHIVE);
        commandType.put(107, HiveOperation.ALTERTABLE_UNARCHIVE);
        commandType.put(113, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(151, HiveOperation.ALTERTABLE_CLUSTER_SORT);
        commandType.put(118, HiveOperation.SHOWDATABASES);
        commandType.put(119, HiveOperation.SHOWTABLES);
        commandType.put(122, HiveOperation.SHOW_TABLESTATUS);
        commandType.put(120, HiveOperation.SHOWFUNCTIONS);
        commandType.put(223, HiveOperation.SHOWINDEXES);
        commandType.put(121, HiveOperation.SHOWPARTITIONS);
        commandType.put(123, HiveOperation.SHOWLOCKS);
        commandType.put(162, HiveOperation.CREATEFUNCTION);
        commandType.put(163, HiveOperation.DROPFUNCTION);
        commandType.put(164, HiveOperation.CREATEVIEW);
        commandType.put(165, HiveOperation.DROPVIEW);
        commandType.put(89, HiveOperation.CREATEINDEX);
        commandType.put(92, HiveOperation.DROPINDEX);
        commandType.put(115, HiveOperation.ALTERINDEX_REBUILD);
        commandType.put(116, HiveOperation.ALTERINDEX_PROPS);
        commandType.put(166, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(167, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(168, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(5, HiveOperation.QUERY);
        commandType.put(124, HiveOperation.LOCKTABLE);
        commandType.put(125, HiveOperation.UNLOCKTABLE);
        commandType.put(197, HiveOperation.CREATEROLE);
        commandType.put(198, HiveOperation.DROPROLE);
        commandType.put(199, HiveOperation.GRANT_PRIVILEGE);
        commandType.put(200, HiveOperation.REVOKE_PRIVILEGE);
        commandType.put(201, HiveOperation.SHOW_GRANT);
        commandType.put(220, HiveOperation.GRANT_ROLE);
        commandType.put(221, HiveOperation.REVOKE_ROLE);
        commandType.put(222, HiveOperation.SHOW_ROLE_GRANT);
        commandType.put(229, HiveOperation.ALTERDATABASE);
        commandType.put(225, HiveOperation.DESCDATABASE);
        tablePartitionCommandType.put(104, new HiveOperation[]{HiveOperation.ALTERTABLE_PROTECTMODE, HiveOperation.ALTERPARTITION_PROTECTMODE});
        tablePartitionCommandType.put(111, new HiveOperation[]{HiveOperation.ALTERTABLE_FILEFORMAT, HiveOperation.ALTERPARTITION_FILEFORMAT});
        tablePartitionCommandType.put(112, new HiveOperation[]{HiveOperation.ALTERTABLE_LOCATION, HiveOperation.ALTERPARTITION_LOCATION});
        tablePartitionCommandType.put(230, new HiveOperation[]{HiveOperation.ALTERTABLE_MERGEFILES, HiveOperation.ALTERPARTITION_MERGEFILES});
        tablePartitionCommandType.put(109, new HiveOperation[]{HiveOperation.ALTERTABLE_SERIALIZER, HiveOperation.ALTERPARTITION_SERIALIZER});
        tablePartitionCommandType.put(108, new HiveOperation[]{HiveOperation.ALTERTABLE_SERDEPROPERTIES, HiveOperation.ALTERPARTITION_SERDEPROPERTIES});
        tablePartitionCommandType.put(100, new HiveOperation[]{null, HiveOperation.ALTERTABLE_RENAMEPART});
    }
}

