/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map.fill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.components.map.ItemData;
import net.sf.jasperreports.components.map.MapComponent;
import net.sf.jasperreports.components.map.MapPrintElement;
import net.sf.jasperreports.components.map.fill.FillContextProvider;
import net.sf.jasperreports.components.map.fill.FillItemData;
import net.sf.jasperreports.components.map.type.MapImageTypeEnum;
import net.sf.jasperreports.components.map.type.MapScaleEnum;
import net.sf.jasperreports.components.map.type.MapTypeEnum;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.component.BaseFillComponent;
import net.sf.jasperreports.engine.component.FillContext;
import net.sf.jasperreports.engine.component.FillPrepareResult;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateGenericElement;
import net.sf.jasperreports.engine.fill.JRTemplateGenericPrintElement;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;

public class MapFillComponent
extends BaseFillComponent
implements FillContextProvider {
    private final MapComponent mapComponent;
    private Float latitude;
    private Float longitude;
    private Integer zoom;
    private String language;
    private MapTypeEnum mapType;
    private MapScaleEnum mapScale;
    private MapImageTypeEnum imageType;
    private OnErrorTypeEnum onErrorType;
    private String clientId;
    private String signature;
    private String key;
    private String version;
    private FillItemData markerData;
    private List<FillItemData> pathStyleList;
    private List<FillItemData> pathDataList;
    private List<Map<String, Object>> markers;
    private Map<String, Map<String, Object>> styles;
    private List<Map<String, Object>> paths;
    JRFillObjectFactory factory;

    public MapFillComponent(MapComponent map) {
        this.mapComponent = map;
    }

    public MapFillComponent(MapComponent map, JRFillObjectFactory factory) {
        this.mapComponent = map;
        this.factory = factory;
        if (this.mapComponent.getMarkerData() != null) {
            this.markerData = new FillItemData(this, this.mapComponent.getMarkerData(), factory);
        }
        if (this.mapComponent.getPathStyleList() != null) {
            this.pathStyleList = new ArrayList<FillItemData>();
            for (ItemData pathStyle : this.mapComponent.getPathStyleList()) {
                this.pathStyleList.add(new FillItemData(this, pathStyle, factory));
            }
        }
        if (this.mapComponent.getPathDataList() != null) {
            this.pathDataList = new ArrayList<FillItemData>();
            for (ItemData pathData : this.mapComponent.getPathDataList()) {
                this.pathDataList.add(new FillItemData(this, pathData, factory));
            }
        }
    }

    protected MapComponent getMap() {
        return this.mapComponent;
    }

    @Override
    public FillContext getFillContext() {
        return this.fillContext;
    }

    @Override
    public void evaluate(byte evaluation) throws JRException {
        if (this.isEvaluateNow()) {
            this.evaluateMap(evaluation);
        }
    }

    protected void evaluateMap(byte evaluation) throws JRException {
        this.latitude = (Float)this.fillContext.evaluate(this.mapComponent.getLatitudeExpression(), evaluation);
        this.longitude = (Float)this.fillContext.evaluate(this.mapComponent.getLongitudeExpression(), evaluation);
        this.zoom = (Integer)this.fillContext.evaluate(this.mapComponent.getZoomExpression(), evaluation);
        Integer n = this.zoom = this.zoom == null ? MapComponent.DEFAULT_ZOOM : this.zoom;
        if (this.mapComponent.getLanguageExpression() != null) {
            this.language = (String)this.fillContext.evaluate(this.mapComponent.getLanguageExpression(), evaluation);
        } else {
            Locale locale = this.fillContext.getReportLocale();
            if (locale != null) {
                this.language = locale.getLanguage();
            }
        }
        this.mapType = this.mapComponent.getMapType() == null ? MapTypeEnum.ROADMAP : this.mapComponent.getMapType();
        this.mapScale = this.mapComponent.getMapScale();
        this.imageType = this.mapComponent.getImageType();
        JRPropertiesHolder propertiesHolder = this.fillContext.getComponentElement().getParentProperties();
        JRPropertiesUtil util = JRPropertiesUtil.getInstance(this.fillContext.getFiller().getJasperReportsContext());
        this.clientId = util.getProperty(propertiesHolder, "net.sf.jasperreports.components.map.client.id");
        this.signature = util.getProperty(propertiesHolder, "net.sf.jasperreports.components.map.signature");
        this.key = util.getProperty(propertiesHolder, "net.sf.jasperreports.components.map.key");
        this.version = util.getProperty(propertiesHolder, "net.sf.jasperreports.components.map.version");
        if (this.mapComponent.getMarkerData() != null) {
            this.markers = this.markerData.getEvaluateItems(evaluation);
        }
        if (this.pathDataList != null) {
            this.addPathStyles(evaluation);
            this.paths = new ArrayList<Map<String, Object>>();
            HashMap<String, Map<String, Object>> pathIds = new HashMap<String, Map<String, Object>>();
            for (FillItemData pathData : this.pathDataList) {
                List<Map<String, Object>> currentItemList = pathData.getEvaluateItems(evaluation);
                if (currentItemList == null || currentItemList.isEmpty()) continue;
                for (Map<String, Object> currentItem : currentItemList) {
                    if (currentItem == null) continue;
                    String pathName = currentItem.get("name") != null ? (String)currentItem.get("name") : "DEFAULT_PATH_NAME";
                    Map<String, Object> pathMap = null;
                    if (pathIds.containsKey(pathName)) {
                        pathMap = (Map)pathIds.get(pathName);
                    } else {
                        pathMap = new HashMap();
                        pathMap.put("locations", new ArrayList());
                        pathIds.put(pathName, pathMap);
                        this.paths.add(pathMap);
                    }
                    this.setStyle((String)currentItem.get("style"), pathMap);
                    boolean coordSet = false;
                    for (String key : currentItem.keySet()) {
                        if ("name".equals(key) || "style".equals(key)) continue;
                        if ("latitude".equals(key) || "longitude".equals(key)) {
                            if (coordSet) continue;
                            if (currentItem.get("latitude") == null || currentItem.get("longitude") == null) {
                                throw new JRException("Null values are not allowed for latitude and longitude");
                            }
                            HashMap<String, Object> location = new HashMap<String, Object>();
                            location.put("latitude", currentItem.get("latitude"));
                            location.put("longitude", currentItem.get("longitude"));
                            ((List)pathMap.get("locations")).add(location);
                            coordSet = true;
                            continue;
                        }
                        pathMap.put(key, currentItem.get(key));
                    }
                }
            }
        }
        this.onErrorType = this.mapComponent.getOnErrorType();
    }

    protected void addPathStyles(byte evaluation) throws JRException {
        this.styles = new HashMap<String, Map<String, Object>>();
        if (this.pathStyleList != null) {
            for (FillItemData styleData : this.pathStyleList) {
                List<Map<String, Object>> currentStyleList = styleData.getEvaluateItems(evaluation);
                if (currentStyleList == null || currentStyleList.isEmpty()) continue;
                for (Map<String, Object> currentStyle : currentStyleList) {
                    String styleName = (String)currentStyle.get("name");
                    if (styleName == null) {
                        throw new JRException("Null value is not allowed for the style name");
                    }
                    HashMap<String, Object> styleMap = null;
                    if (this.styles.containsKey(styleName)) {
                        styleMap = this.styles.get(styleName);
                    } else {
                        styleMap = new HashMap();
                        this.styles.put(styleName, styleMap);
                    }
                    this.setStyle(currentStyle, styleMap);
                }
            }
        }
    }

    protected void setStyle(String styleName, Map<String, Object> styleMap) {
        Map<String, Object> parentStyleMap;
        if (styleName != null && (parentStyleMap = this.styles.get(styleName)) != null && !parentStyleMap.isEmpty()) {
            String parentStyleName = (String)parentStyleMap.get("style");
            if (parentStyleName != null) {
                this.setStyle(parentStyleName, styleMap);
            }
            this.setStyle(parentStyleMap, styleMap);
        }
    }

    protected void setStyle(Map<String, Object> parentStyleMap, Map<String, Object> styleMap) {
        if (parentStyleMap != null) {
            for (String styleProperty : parentStyleMap.keySet()) {
                if ("name".equals(styleProperty) || "latitude".equals(styleProperty) || "longitude".equals(styleProperty) || parentStyleMap.get(styleProperty) == null || parentStyleMap.get(styleProperty).toString().length() <= 0) continue;
                styleMap.put(styleProperty, parentStyleMap.get(styleProperty));
            }
        }
    }

    protected boolean isEvaluateNow() {
        return this.mapComponent.getEvaluationTime() == EvaluationTimeEnum.NOW;
    }

    @Override
    public FillPrepareResult prepare(int availableHeight) {
        return FillPrepareResult.PRINT_NO_STRETCH;
    }

    @Override
    public JRPrintElement fill() {
        JRComponentElement element = this.fillContext.getComponentElement();
        JRTemplateGenericElement template = new JRTemplateGenericElement(this.fillContext.getElementOrigin(), this.fillContext.getDefaultStyleProvider(), MapPrintElement.MAP_ELEMENT_TYPE);
        template = this.deduplicate(template);
        JRTemplateGenericPrintElement printElement = new JRTemplateGenericPrintElement(template, this.printElementOriginator);
        printElement.setUUID(element.getUUID());
        printElement.setX(element.getX());
        printElement.setY(this.fillContext.getElementPrintY());
        printElement.setWidth(element.getWidth());
        printElement.setHeight(element.getHeight());
        if (this.isEvaluateNow()) {
            this.copy(printElement);
        } else {
            this.fillContext.registerDelayedEvaluation(printElement, this.mapComponent.getEvaluationTime(), this.mapComponent.getEvaluationGroup());
        }
        return printElement;
    }

    @Override
    public void evaluateDelayedElement(JRPrintElement element, byte evaluation) throws JRException {
        this.evaluateMap(evaluation);
        this.copy((JRGenericPrintElement)element);
    }

    protected void copy(JRGenericPrintElement printElement) {
        printElement.setParameterValue("latitude", this.latitude);
        printElement.setParameterValue("longitude", this.longitude);
        printElement.setParameterValue("zoom", this.zoom);
        String reqParams = "";
        if (this.language != null) {
            reqParams = reqParams + "&language=" + this.language;
        }
        if (this.clientId != null) {
            reqParams = reqParams + "&client=" + this.clientId;
            if (this.signature != null) {
                reqParams = reqParams + "&signature=" + this.signature;
            }
        } else if (this.key != null) {
            reqParams = reqParams + "&key=" + this.key;
        }
        if (this.version != null) {
            reqParams = reqParams + "&v=" + this.version;
        }
        if (reqParams.length() > 0) {
            printElement.setParameterValue("reqParams", reqParams);
        }
        if (this.mapType != null) {
            printElement.setParameterValue("mapType", this.mapType.getName());
        }
        if (this.mapScale != null) {
            printElement.setParameterValue("mapScale", this.mapScale.getName());
        }
        if (this.imageType != null) {
            printElement.setParameterValue("imageType", this.imageType.getName());
        }
        if (this.onErrorType != null) {
            printElement.setParameterValue("onErrorType", this.onErrorType.getName());
        }
        if (this.markers != null && !this.markers.isEmpty()) {
            printElement.setParameterValue("markers", this.markers);
        }
        if (this.paths != null && !this.paths.isEmpty()) {
            printElement.setParameterValue("paths", this.paths);
        }
    }
}

