/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.io.IOException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.export.oasis.BorderStyle;
import net.sf.jasperreports.engine.export.oasis.WriterHelper;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class FrameStyle
extends BorderStyle {
    private String fill;
    private String backcolor;

    public FrameStyle(WriterHelper styleWriter, JRPrintElement element) {
        super(styleWriter);
        if (element.getModeValue() == ModeEnum.OPAQUE) {
            this.fill = "solid";
            this.backcolor = JRColorUtil.getColorHexa(element.getBackcolor());
        } else {
            this.fill = "none";
        }
    }

    @Override
    public String getId() {
        return this.fill + "|" + this.backcolor + "|" + super.getId();
    }

    @Override
    public void write(String frameStyleName) throws IOException {
        this.styleWriter.write("<style:style style:name=\"");
        this.styleWriter.write(frameStyleName);
        this.styleWriter.write("\" style:family=\"graphic\"");
        this.styleWriter.write(">\n");
        this.styleWriter.write(" <style:graphic-properties");
        this.styleWriter.write(" style:vertical-pos=\"from-top\"");
        this.styleWriter.write(" style:vertical-rel=\"page\"");
        this.styleWriter.write(" style:horizontal-pos=\"from-left\"");
        this.styleWriter.write(" style:horizontal-rel=\"page\"");
        this.styleWriter.write(" draw:fill=\"");
        this.styleWriter.write(this.fill);
        this.styleWriter.write("\" draw:fill-color=\"#");
        this.styleWriter.write(this.backcolor);
        this.styleWriter.write("\"");
        this.writeBorder(0);
        this.writeBorder(1);
        this.writeBorder(2);
        this.writeBorder(3);
        this.styleWriter.write("/>\n");
        this.styleWriter.write("</style:style>\n");
    }
}

