/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.PrintElementVisitor;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRTemplateGenericElement;
import net.sf.jasperreports.engine.fill.JRTemplatePrintElement;
import net.sf.jasperreports.engine.fill.PrintElementOriginator;
import net.sf.jasperreports.engine.virtualization.VirtualizationInput;
import net.sf.jasperreports.engine.virtualization.VirtualizationOutput;

public class JRTemplateGenericPrintElement
extends JRTemplatePrintElement
implements JRGenericPrintElement {
    private static final long serialVersionUID = 10200L;
    private Map<String, Object> parameters;

    public JRTemplateGenericPrintElement() {
    }

    public JRTemplateGenericPrintElement(JRTemplateGenericElement template) {
        super(template);
        this.parameters = new LinkedHashMap<String, Object>();
    }

    public JRTemplateGenericPrintElement(JRTemplateGenericElement template, int sourceElementId) {
        super((JRTemplateElement)template, sourceElementId);
        this.parameters = new LinkedHashMap<String, Object>();
    }

    public JRTemplateGenericPrintElement(JRTemplateGenericElement template, PrintElementOriginator originator) {
        super((JRTemplateElement)template, originator);
        this.parameters = new LinkedHashMap<String, Object>();
    }

    public JRTemplateGenericPrintElement(JRTemplateGenericElement template, int sourceElementId, int parameterCount) {
        super((JRTemplateElement)template, sourceElementId);
        this.parameters = new LinkedHashMap<String, Object>(parameterCount * 4 / 3, 0.75f);
    }

    public JRTemplateGenericPrintElement(JRTemplateGenericElement template, PrintElementOriginator originator, int parameterCount) {
        super((JRTemplateElement)template, originator);
        this.parameters = new LinkedHashMap<String, Object>(parameterCount * 4 / 3, 0.75f);
    }

    @Override
    public JRGenericElementType getGenericType() {
        return ((JRTemplateGenericElement)this.template).getGenericType();
    }

    @Override
    public Set<String> getParameterNames() {
        return this.parameters.keySet();
    }

    @Override
    public Object getParameterValue(String name) {
        return this.parameters.get(name);
    }

    @Override
    public boolean hasParameter(String name) {
        return this.parameters.containsKey(name);
    }

    @Override
    public void setParameterValue(String name, Object value) {
        this.parameters.put(name, value);
    }

    @Override
    public <T> void accept(PrintElementVisitor<T> visitor, T arg) {
        visitor.visit(this, arg);
    }

    @Override
    public void writeVirtualized(VirtualizationOutput out) throws IOException {
        super.writeVirtualized(out);
        out.writeIntCompressed(this.parameters.size());
        for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
            out.writeJRObject(entry.getKey());
            out.writeJRObject(entry.getValue());
        }
    }

    @Override
    public void readVirtualized(VirtualizationInput in) throws IOException {
        super.readVirtualized(in);
        int paramsCount = in.readIntCompressed();
        this.parameters = new LinkedHashMap<String, Object>(paramsCount * 4 / 3, 0.75f);
        for (int i = 0; i < paramsCount; ++i) {
            String key = (String)in.readJRObject();
            Object value = in.readJRObject();
            this.parameters.put(key, value);
        }
    }
}

