/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.dnd.ReportObjectPaletteTransferable;
import com.jaspersoft.ireport.designer.outline.nodes.IRAbstractNode;
import com.jaspersoft.ireport.designer.outline.nodes.VariablesNode;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.sheet.properties.InitialValueExpressionProperty;
import com.jaspersoft.ireport.designer.sheet.properties.VariableExpressionProperty;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.type.IncrementTypeEnum;
import net.sf.jasperreports.engine.type.ResetTypeEnum;
import org.openide.ErrorManager;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.RenameAction;
import org.openide.actions.ReorderAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class VariableNode
extends IRAbstractNode
implements PropertyChangeListener {
    JasperDesign jd = null;
    private JRDesignVariable variable = null;

    public VariableNode(JasperDesign jd, JRDesignVariable variable, Lookup doLkp) {
        super(Children.LEAF, (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.fixed((Object[])new Object[]{jd, variable})}));
        this.jd = jd;
        this.variable = variable;
        this.setDisplayName(variable.getName());
        super.setName(variable.getName());
        if (variable.isSystemDefined()) {
            this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/variable-16.png");
        } else {
            this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/variable-16.png");
        }
        variable.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public String getDisplayName() {
        return this.variable.getName();
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = Sheet.createPropertiesSet();
        JRDesignDataset dataset = (JRDesignDataset)this.getParentNode().getLookup().lookup(JRDesignDataset.class);
        set.put((Node.Property)new NameProperty(this.getVariable(), dataset));
        set.put((Node.Property)new ValueClassNameProperty(this.getVariable()));
        if (!this.getVariable().isSystemDefined()) {
            set.put((Node.Property)new CalculationProperty(this.getVariable()));
            set.put((Node.Property)new ResetTypeProperty(this.getVariable(), dataset));
            set.put((Node.Property)new ResetGroupProperty(this.getVariable(), dataset));
            set.put((Node.Property)new IncrementTypeProperty(this.getVariable(), dataset));
            set.put((Node.Property)new IncrementGroupProperty(this.getVariable(), dataset));
            set.put((Node.Property)new IncrementerFactoryClassNameProperty(this.getVariable()));
            set.put((Node.Property)new VariableExpressionProperty(this.getVariable(), dataset));
            set.put((Node.Property)new InitialValueExpressionProperty(this.getVariable(), dataset));
        }
        sheet.put(set);
        return sheet;
    }

    public boolean canCut() {
        return !this.variable.isSystemDefined();
    }

    public boolean canRename() {
        return !this.variable.isSystemDefined();
    }

    public boolean canDestroy() {
        return !this.variable.isSystemDefined();
    }

    public Transferable clipboardCut() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)4);
    }

    public Transferable clipboardCopy() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)1);
    }

    public void destroy() throws IOException {
        if (!this.getVariable().isSystemDefined()) {
            JRDesignDataset dataset = (JRDesignDataset)this.getParentNode().getLookup().lookup(JRDesignDataset.class);
            dataset.removeVariable((JRVariable)this.getVariable());
            super.destroy();
        }
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{SystemAction.get(CopyAction.class), SystemAction.get(CutAction.class), SystemAction.get(RenameAction.class), SystemAction.get(ReorderAction.class), null, SystemAction.get(DeleteAction.class)};
    }

    public Transferable drag() throws IOException {
        ExTransferable tras = ExTransferable.create((Transferable)this.clipboardCut());
        tras.put((ExTransferable.Single)new ReportObjectPaletteTransferable("com.jaspersoft.ireport.designer.palette.actions.CreateTextFieldFromVariableAction", this.getVariable()));
        return tras;
    }

    public void setName(String s) {
        if (s.equals("")) {
            throw new IllegalArgumentException("Variable name not valid.");
        }
        List currentVariables = null;
        JRDesignDataset dataset = (JRDesignDataset)this.getParentNode().getLookup().lookup(JRDesignDataset.class);
        currentVariables = dataset.getVariablesList();
        for (JRVariable pa : currentVariables) {
            JRDesignVariable p = (JRDesignVariable)pa;
            if (p == this.getVariable() || !p.getName().equals(s)) continue;
            throw new IllegalArgumentException("Variable name already in use.");
        }
        String oldName = this.getVariable().getName();
        this.getVariable().setName(s);
        dataset.getVariablesMap().remove(oldName);
        dataset.getVariablesMap().put(s, this.getVariable());
        ObjectPropertyUndoableEdit opue = new ObjectPropertyUndoableEdit(this.getVariable(), "Name", String.class, oldName, s);
        IReportManager.getInstance().addUndoableEdit(opue);
    }

    public JRDesignVariable getVariable() {
        return this.variable;
    }

    public void setVariable(JRDesignVariable variable) {
        this.variable = variable;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        IReportManager.getInstance().notifyReportChange();
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("name")) {
            super.setName(this.getVariable().getName());
            this.setDisplayName(this.getVariable().getName());
            if (this.getParentNode() != null && this.getParentNode() instanceof VariablesNode) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ((VariablesNode)VariableNode.this.getParentNode()).updateSorting();
                    }
                });
            }
        }
        this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    public static final class IncrementerFactoryClassNameProperty
    extends PropertySupport.ReadWrite {
        JRDesignVariable variable = null;

        public IncrementerFactoryClassNameProperty(JRDesignVariable variable) {
            super("incrementerFactoryClass", String.class, I18n.getString("VariableNode.Property.IncrementerFactoryClass"), I18n.getString("VariableNode.Property.IncrementerFactoryClassdetail"));
            this.variable = variable;
            this.setValue("oneline", Boolean.TRUE);
        }

        public boolean canWrite() {
            return !this.getVariable().isSystemDefined();
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.getVariable().getIncrementerFactoryClassName() == null ? "" : this.getVariable().getIncrementerFactoryClassName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            String s;
            String string = s = val == null ? null : val + "";
            if (s != null && (s.trim().length() == 0 || s.equals("null"))) {
                s = null;
            }
            String oldName = this.getVariable().getIncrementerFactoryClassName();
            this.getVariable().setIncrementerFactoryClassName(s);
            ObjectPropertyUndoableEdit opue = new ObjectPropertyUndoableEdit(this.getVariable(), "IncrementerFactoryClassName", String.class, oldName, this.getVariable().getName());
            IReportManager.getInstance().addUndoableEdit(opue);
        }

        public JRDesignVariable getVariable() {
            return this.variable;
        }

        public void setVariable(JRDesignVariable variable) {
            this.variable = variable;
        }
    }

    private static final class IncrementGroupProperty
    extends PropertySupport
    implements PropertyChangeListener {
        private JRDesignDataset dataset = null;
        private JRDesignVariable variable = null;
        private ComboBoxPropertyEditor editor;

        public IncrementGroupProperty(JRDesignVariable variable, JRDesignDataset dataset) {
            super("incrementGroup", JRGroup.class, I18n.getString("VariableNode.Property.Incrementgroup"), I18n.getString("VariableNode.Property.Incrementgroupdetail"), true, true);
            this.variable = variable;
            this.dataset = dataset;
            dataset.getEventSupport().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)dataset.getEventSupport()));
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public boolean canWrite() {
            return !this.variable.isSystemDefined() && this.variable.getIncrementTypeValue() == IncrementTypeEnum.GROUP;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                this.editor = new ComboBoxPropertyEditor(false, this.getListOfTags());
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.variable.getIncrementGroup() == null ? "" : this.variable.getIncrementGroup();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof JRGroup) {
                JRGroup oldValue = this.variable.getIncrementGroup();
                JRGroup newValue = (JRGroup)val;
                this.variable.setIncrementGroup(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.variable, "IncrementGroup", JRGroup.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (this.editor == null) {
                return;
            }
            if (evt.getPropertyName() == null) {
                return;
            }
            if (evt.getPropertyName().equals("groups") || evt.getPropertyName().equals("name")) {
                this.editor.setTagValues(this.getListOfTags());
            }
        }

        private ArrayList getListOfTags() {
            ArrayList<Tag> l = new ArrayList<Tag>();
            List groups = this.dataset.getGroupsList();
            l.add(new Tag(null, ""));
            for (int i = 0; i < groups.size(); ++i) {
                JRDesignGroup group = (JRDesignGroup)groups.get(i);
                l.add(new Tag(group, group.getName()));
                group.getEventSupport().removePropertyChangeListener("name", (PropertyChangeListener)this);
                group.getEventSupport().addPropertyChangeListener("name", WeakListeners.propertyChange((PropertyChangeListener)this, (Object)group.getEventSupport()));
            }
            return l;
        }
    }

    private static final class IncrementTypeProperty
    extends PropertySupport {
        private JRDesignDataset dataset = null;
        private JRDesignVariable variable = null;
        private ComboBoxPropertyEditor editor;

        public IncrementTypeProperty(JRDesignVariable variable, JRDesignDataset dataset) {
            super("incrementType", IncrementTypeEnum.class, I18n.getString("VariableNode.Property.Incrementtype"), I18n.getString("VariableNode.Property.Incrementtypedetail"), true, true);
            this.variable = variable;
            this.dataset = dataset;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public boolean isDefaultValue() {
            return this.variable.getIncrementTypeValue() == IncrementTypeEnum.NONE;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setPropertyValue(IncrementTypeEnum.NONE);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> l = new ArrayList<Tag>();
                l.add(new Tag(IncrementTypeEnum.REPORT, I18n.getString("VariableNode.Property.Report")));
                l.add(new Tag(IncrementTypeEnum.COLUMN, I18n.getString("VariableNode.Property.Column")));
                l.add(new Tag(IncrementTypeEnum.GROUP, I18n.getString("VariableNode.Property.Group")));
                l.add(new Tag(IncrementTypeEnum.NONE, I18n.getString("VariableNode.Property.None")));
                l.add(new Tag(IncrementTypeEnum.PAGE, I18n.getString("VariableNode.Property.Page")));
                this.editor = new ComboBoxPropertyEditor(false, l);
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.variable.getIncrementTypeValue();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof IncrementTypeEnum) {
                this.setPropertyValue((IncrementTypeEnum)val);
            }
        }

        private void setPropertyValue(IncrementTypeEnum val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            IncrementTypeEnum oldValue = this.variable.getIncrementTypeValue();
            IncrementTypeEnum newValue = val;
            this.variable.setIncrementType(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.variable, "IncrementType", IncrementTypeEnum.class, oldValue, newValue);
            JRGroup oldGroupValue = this.variable.getIncrementGroup();
            JRGroup newGroupValue = null;
            if (val == IncrementTypeEnum.GROUP) {
                if (this.dataset.getGroupsList().isEmpty()) {
                    IllegalArgumentException iae = this.annotateException(I18n.getString("VariableNode.Property.Message"));
                    throw iae;
                }
                newGroupValue = (JRGroup)this.dataset.getGroupsList().get(0);
            }
            if (oldGroupValue != newGroupValue) {
                ObjectPropertyUndoableEdit urobGroup = new ObjectPropertyUndoableEdit(this.variable, "IncrementGroup", JRGroup.class, oldGroupValue, newGroupValue);
                this.variable.setIncrementGroup(newGroupValue);
                urob.concatenate(urobGroup);
            }
            IReportManager.getInstance().addUndoableEdit(urob);
        }

        public IllegalArgumentException annotateException(String msg) {
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
            return iae;
        }
    }

    private static final class ResetGroupProperty
    extends PropertySupport
    implements PropertyChangeListener {
        private JRDesignDataset dataset = null;
        private JRDesignVariable variable = null;
        private ComboBoxPropertyEditor editor;

        public ResetGroupProperty(JRDesignVariable variable, JRDesignDataset dataset) {
            super("resetGroup", JRGroup.class, I18n.getString("VariableNode.Property.Resetgroup"), I18n.getString("VariableNode.Property.Resetgroupdetail"), true, true);
            this.variable = variable;
            this.dataset = dataset;
            dataset.getEventSupport().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)dataset.getEventSupport()));
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public boolean canWrite() {
            return !this.variable.isSystemDefined() && this.variable.getResetTypeValue() == ResetTypeEnum.GROUP;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                this.editor = new ComboBoxPropertyEditor(false, this.getListOfTags());
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.variable.getResetGroup() == null ? "" : this.variable.getResetGroup();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof JRGroup) {
                JRGroup oldValue = this.variable.getResetGroup();
                JRGroup newValue = (JRGroup)val;
                this.variable.setResetGroup(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.variable, "ResetGroup", JRGroup.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (this.editor == null) {
                return;
            }
            if (evt.getPropertyName() == null) {
                return;
            }
            if (evt.getPropertyName().equals("groups") || evt.getPropertyName().equals("name")) {
                this.editor.setTagValues(this.getListOfTags());
            }
        }

        private ArrayList getListOfTags() {
            ArrayList<Tag> l = new ArrayList<Tag>();
            List groups = this.dataset.getGroupsList();
            l.add(new Tag(null, ""));
            for (int i = 0; i < groups.size(); ++i) {
                JRDesignGroup group = (JRDesignGroup)groups.get(i);
                l.add(new Tag(group, group.getName()));
                group.getEventSupport().removePropertyChangeListener("name", (PropertyChangeListener)this);
                group.getEventSupport().addPropertyChangeListener("name", WeakListeners.propertyChange((PropertyChangeListener)this, (Object)group.getEventSupport()));
            }
            return l;
        }
    }

    private static final class ResetTypeProperty
    extends PropertySupport {
        private JRDesignDataset dataset = null;
        private JRDesignVariable variable = null;
        private ComboBoxPropertyEditor editor;

        public ResetTypeProperty(JRDesignVariable variable, JRDesignDataset dataset) {
            super("resetType", ResetTypeEnum.class, I18n.getString("VariableNode.Property.Resettype"), I18n.getString("VariableNode.Property.Resettypedetail"), true, true);
            this.variable = variable;
            this.dataset = dataset;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public boolean isDefaultValue() {
            return this.variable.getResetTypeValue() == ResetTypeEnum.REPORT;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setPropertyValue(ResetTypeEnum.REPORT);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> l = new ArrayList<Tag>();
                l.add(new Tag(ResetTypeEnum.REPORT, I18n.getString("VariableNode.Property.Report")));
                l.add(new Tag(ResetTypeEnum.COLUMN, I18n.getString("VariableNode.Property.Column")));
                l.add(new Tag(ResetTypeEnum.GROUP, I18n.getString("VariableNode.Property.Group")));
                l.add(new Tag(ResetTypeEnum.NONE, I18n.getString("VariableNode.Property.None")));
                l.add(new Tag(ResetTypeEnum.PAGE, I18n.getString("VariableNode.Property.Page")));
                this.editor = new ComboBoxPropertyEditor(false, l);
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.variable.getResetTypeValue();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof ResetTypeEnum) {
                this.setPropertyValue((ResetTypeEnum)val);
            }
        }

        private void setPropertyValue(ResetTypeEnum val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            ResetTypeEnum oldValue = this.variable.getResetTypeValue();
            ResetTypeEnum newValue = val;
            this.variable.setResetType(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.variable, "ResetType", Byte.TYPE, oldValue, newValue);
            JRGroup oldGroupValue = this.variable.getResetGroup();
            JRGroup newGroupValue = null;
            if (val == ResetTypeEnum.GROUP) {
                if (this.dataset.getGroupsList().size() == 0) {
                    IllegalArgumentException iae = this.annotateException(I18n.getString("VariableNode.Property.Message"));
                    throw iae;
                }
                newGroupValue = (JRGroup)this.dataset.getGroupsList().get(0);
            }
            if (oldGroupValue != newGroupValue) {
                ObjectPropertyUndoableEdit urobGroup = new ObjectPropertyUndoableEdit(this.variable, "ResetGroup", JRGroup.class, oldGroupValue, newGroupValue);
                this.variable.setResetGroup(newGroupValue);
                urob.concatenate(urobGroup);
            }
            IReportManager.getInstance().addUndoableEdit(urob);
        }

        public IllegalArgumentException annotateException(String msg) {
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
            return iae;
        }
    }

    private static final class CalculationProperty
    extends PropertySupport {
        private JRDesignVariable variable = null;
        private ComboBoxPropertyEditor editor;

        public CalculationProperty(JRDesignVariable variable) {
            super("calculation", CalculationEnum.class, I18n.getString("VariableNode.Property.Calculation"), I18n.getString("VariableNode.Property.Calculationdetail"), true, true);
            this.variable = variable;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public boolean isDefaultValue() {
            return this.variable.getCalculationValue() == CalculationEnum.NOTHING;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(CalculationEnum.NOTHING);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> l = new ArrayList<Tag>();
                l.add(new Tag(CalculationEnum.NOTHING, I18n.getString("VariableNode.Property.Nothing")));
                l.add(new Tag(CalculationEnum.COUNT, I18n.getString("VariableNode.Property.Count")));
                l.add(new Tag(CalculationEnum.DISTINCT_COUNT, I18n.getString("VariableNode.Property.DistinctCount")));
                l.add(new Tag(CalculationEnum.SUM, I18n.getString("VariableNode.Property.Sum")));
                l.add(new Tag(CalculationEnum.AVERAGE, I18n.getString("VariableNode.Property.Average")));
                l.add(new Tag(CalculationEnum.LOWEST, I18n.getString("VariableNode.Property.Lowest")));
                l.add(new Tag(CalculationEnum.HIGHEST, I18n.getString("VariableNode.Property.Highest")));
                l.add(new Tag(CalculationEnum.STANDARD_DEVIATION, I18n.getString("VariableNode.Property.StandardDeviation")));
                l.add(new Tag(CalculationEnum.VARIANCE, I18n.getString("VariableNode.Property.Variance")));
                l.add(new Tag(CalculationEnum.SYSTEM, I18n.getString("VariableNode.Property.System")));
                l.add(new Tag(CalculationEnum.FIRST, I18n.getString("VariableNode.Property.First")));
                this.editor = new ComboBoxPropertyEditor(false, l);
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.variable.getCalculationValue();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof CalculationEnum) {
                CalculationEnum oldValue = this.variable.getCalculationValue();
                CalculationEnum newValue = (CalculationEnum)val;
                this.variable.setCalculation(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.variable, "Calculation", CalculationEnum.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }

    private static final class ValueClassNameProperty
    extends PropertySupport.ReadWrite {
        JRDesignVariable variable = null;
        PropertyEditor editor = null;

        public ValueClassNameProperty(JRDesignVariable variable) {
            super("valueClassName", String.class, I18n.getString("VariableNode.Property.VariableClass"), I18n.getString("VariableNode.Property.VariableClass"));
            this.variable = variable;
        }

        public boolean canWrite() {
            return !this.getVariable().isSystemDefined();
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.getVariable().getValueClassName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null) {
                return;
            }
            if (val instanceof String) {
                ObjectPropertyUndoableEdit urob2;
                String s = ((String)val).trim();
                if (s.length() == 0) {
                    s = "java.lang.String";
                }
                String oldValue = this.getVariable().getValueClassName();
                String newValue = s;
                this.getVariable().setValueClassName(s);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.getVariable(), "ValueClassName", String.class, oldValue, newValue);
                if (this.getVariable().getExpression() != null) {
                    ((JRDesignExpression)this.getVariable().getExpression()).setValueClassName(s);
                    urob2 = new ObjectPropertyUndoableEdit((JRDesignExpression)this.getVariable().getExpression(), "ValueClassName", String.class, oldValue, newValue);
                    urob.addEdit(urob2);
                }
                if (this.getVariable().getInitialValueExpression() != null) {
                    ((JRDesignExpression)this.getVariable().getInitialValueExpression()).setValueClassName(s);
                    urob2 = new ObjectPropertyUndoableEdit((JRDesignExpression)this.getVariable().getInitialValueExpression(), "ValueClassName", String.class, oldValue, newValue);
                    urob.addEdit(urob2);
                }
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.getVariable().getValueClassName().equals("java.lang.String");
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            super.restoreDefaultValue();
            this.setValue("java.lang.String");
            this.editor.setValue("java.lang.String");
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public JRDesignVariable getVariable() {
            return this.variable;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                if (this.getVariable().isSystemDefined()) {
                    this.editor = super.getPropertyEditor();
                } else {
                    ArrayList<Tag> classes = new ArrayList<Tag>();
                    classes.add(new Tag("java.lang.Boolean"));
                    classes.add(new Tag("java.lang.Byte"));
                    classes.add(new Tag("java.util.Date"));
                    classes.add(new Tag("java.sql.Timestamp"));
                    classes.add(new Tag("java.sql.Time"));
                    classes.add(new Tag("java.lang.Double"));
                    classes.add(new Tag("java.lang.Float"));
                    classes.add(new Tag("java.lang.Integer"));
                    classes.add(new Tag("java.lang.Long"));
                    classes.add(new Tag("java.lang.Short"));
                    classes.add(new Tag("java.math.BigDecimal"));
                    classes.add(new Tag("java.lang.Number"));
                    classes.add(new Tag("java.lang.String"));
                    classes.add(new Tag("java.util.Collection"));
                    classes.add(new Tag("java.util.List"));
                    classes.add(new Tag("java.lang.Object"));
                    classes.add(new Tag("java.io.InputStream"));
                    classes.add(new Tag("net.sf.jasperreports.engine.JREmptyDataSource"));
                    this.editor = new ComboBoxPropertyEditor(true, classes);
                }
            }
            return this.editor;
        }

        public Object getValue(String attributeName) {
            if ("canEditAsText".equals(attributeName)) {
                return true;
            }
            if ("oneline".equals(attributeName)) {
                return true;
            }
            if ("suppressCustomEditor".equals(attributeName)) {
                return false;
            }
            return super.getValue(attributeName);
        }
    }

    public static final class NameProperty
    extends PropertySupport.ReadWrite {
        JRDesignVariable variable = null;
        JRDesignDataset dataset = null;

        public NameProperty(JRDesignVariable variable, JRDesignDataset dataset) {
            super("name", String.class, I18n.getString("VariableNode.Property.Name"), I18n.getString("VariableNode.Property.Namedetail"));
            this.variable = variable;
            this.dataset = dataset;
            this.setValue("oneline", Boolean.TRUE);
        }

        public boolean canWrite() {
            return !this.getVariable().isSystemDefined();
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.getVariable().getName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val.equals("")) {
                IllegalArgumentException iae = this.annotateException(I18n.getString("VariableNode.Property.VariableInvalid"));
                throw iae;
            }
            String s = val + "";
            List currentVariables = null;
            currentVariables = this.getDataset().getVariablesList();
            for (JRVariable pa : currentVariables) {
                JRDesignVariable p = (JRDesignVariable)pa;
                if (p == this.getVariable() || !p.getName().equals(s)) continue;
                IllegalArgumentException iae = this.annotateException(I18n.getString("VariableNode.Property.VariableInUse"));
                throw iae;
            }
            String oldName = this.getVariable().getName();
            this.getVariable().setName(s);
            this.dataset.getVariablesMap().remove(oldName);
            this.dataset.getVariablesMap().put(s, this.getVariable());
            ObjectPropertyUndoableEdit opue = new ObjectPropertyUndoableEdit(this.getVariable(), "Name", String.class, oldName, this.getVariable().getName());
            IReportManager.getInstance().addUndoableEdit(opue);
        }

        public JRDesignDataset getDataset() {
            return this.dataset;
        }

        public void setDataset(JRDesignDataset dataset) {
            this.dataset = dataset;
        }

        public JRDesignVariable getVariable() {
            return this.variable;
        }

        public void setVariable(JRDesignVariable variable) {
            this.variable = variable;
        }

        public IllegalArgumentException annotateException(String msg) {
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
            return iae;
        }
    }
}

