/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.util.Locale;
import java.util.ResourceBundle;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ResourceBundleEditor
extends PropertyEditorSupport {
    public static final String BASE_NAME_SEPARATOR = "_";

    /*
     * WARNING - void declaration
     */
    public void setAsText(String text) throws IllegalArgumentException {
        ResourceBundle indexOfBaseNameSeparator;
        Assert.hasText(text, "'text' must not be empty");
        String string = text.trim();
        int rawBaseName = string.indexOf(BASE_NAME_SEPARATOR);
        if (rawBaseName == -1) {
            indexOfBaseNameSeparator = ResourceBundle.getBundle(string);
        } else {
            void bundle;
            String baseName = bundle.substring(0, rawBaseName);
            if (!StringUtils.hasText(baseName)) {
                throw new IllegalArgumentException("Bad ResourceBundle name : received '" + text + "' as argument to 'setAsText(String value)'.");
            }
            String localeString = bundle.substring(rawBaseName + 1);
            Locale locale = StringUtils.parseLocaleString(localeString);
            indexOfBaseNameSeparator = StringUtils.hasText(localeString) ? ResourceBundle.getBundle(baseName, locale) : ResourceBundle.getBundle(baseName);
        }
        this.setValue(indexOfBaseNameSeparator);
    }
}

