/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.util.BinaryToStringConverter;
import org.netbeans.modules.db.dataview.util.DataViewUtils;
import org.netbeans.modules.db.dataview.util.DateType;
import org.netbeans.modules.db.dataview.util.TimeType;
import org.netbeans.modules.db.dataview.util.TimestampType;

public class DBReadWriteHelper {
    private static Logger mLogger = Logger.getLogger(DBReadWriteHelper.class.getName());

    public static Object readResultSet(ResultSet resultSet, int n, int n2) throws SQLException {
        switch (n) {
            case -7: 
            case 16: {
                boolean bl = resultSet.getBoolean(n2);
                if (resultSet.wasNull()) {
                    return null;
                }
                return new Boolean(bl);
            }
            case 92: {
                Time time = resultSet.getTime(n2);
                if (resultSet.wasNull()) {
                    return null;
                }
                return time;
            }
            case 91: {
                Date date = resultSet.getDate(n2);
                if (resultSet.wasNull()) {
                    return null;
                }
                return date;
            }
            case -100: 
            case 93: {
                try {
                    Timestamp timestamp = resultSet.getTimestamp(n2);
                    if (resultSet.wasNull()) {
                        return null;
                    }
                    return timestamp;
                }
                catch (SQLException sQLException) {
                    if (sQLException.getSQLState().equals("S1009")) {
                        return null;
                    }
                    throw sQLException;
                }
            }
            case -5: {
                long l = resultSet.getLong(n2);
                if (resultSet.wasNull()) {
                    return null;
                }
                return new Long(l);
            }
            case 8: {
                double d = resultSet.getDouble(n2);
                if (resultSet.wasNull()) {
                    return null;
                }
                return new Double(d);
            }
            case 6: 
            case 7: {
                float f = resultSet.getFloat(n2);
                if (resultSet.wasNull()) {
                    return null;
                }
                return new Float(f);
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = resultSet.getBigDecimal(n2);
                if (resultSet.wasNull()) {
                    return null;
                }
                return bigDecimal;
            }
            case 4: {
                int n3 = resultSet.getInt(n2);
                if (resultSet.wasNull()) {
                    return null;
                }
                return new Integer(n3);
            }
            case 5: {
                short s = resultSet.getShort(n2);
                if (resultSet.wasNull()) {
                    return null;
                }
                return new Short(s);
            }
            case -6: {
                byte by = resultSet.getByte(n2);
                if (resultSet.wasNull()) {
                    return null;
                }
                return new Byte(by);
            }
            case -15: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                String string = resultSet.getString(n2);
                if (resultSet.wasNull()) {
                    return null;
                }
                return string;
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] byArray = resultSet.getBytes(n2);
                if (resultSet.wasNull()) {
                    return null;
                }
                Byte[] byteArray = new Byte[byArray.length];
                for (int i = 0; i < byArray.length; ++i) {
                    byteArray[i] = new Byte(byArray[i]);
                }
                return BinaryToStringConverter.convertToString(byteArray, 2, true);
            }
            case 2004: {
                Blob blob = resultSet.getBlob(n2);
                if (resultSet.wasNull()) {
                    return null;
                }
                byte[] byArray = null;
                if (blob != null) {
                    byArray = blob.getBytes(1L, 255);
                }
                Byte[] byteArray = new Byte[byArray.length];
                for (int i = 0; i < byArray.length; ++i) {
                    byteArray[i] = new Byte(byArray[i]);
                }
                return BinaryToStringConverter.convertToString(byteArray, 16, false);
            }
            case 2005: {
                Clob clob = resultSet.getClob(n2);
                if (resultSet.wasNull()) {
                    return null;
                }
                if (clob == null) break;
                return clob.getSubString(1L, 255);
            }
        }
        return resultSet.getObject(n2);
    }

    public static void setAttributeValue(PreparedStatement preparedStatement, int n, int n2, Object object) throws DBException {
        Number number = null;
        try {
            if (object == null) {
                preparedStatement.setNull(n, n2);
                return;
            }
            switch (n2) {
                case 8: {
                    number = object instanceof Number ? (Number)((Number)object) : (Number)Double.valueOf(object.toString());
                    preparedStatement.setDouble(n, number.doubleValue());
                    break;
                }
                case 3: {
                    number = object instanceof Number ? (Number)object : new BigDecimal(object.toString());
                    preparedStatement.setDouble(n, number.doubleValue());
                    break;
                }
                case -5: 
                case 2: {
                    BigDecimal bigDecimal = new BigDecimal(object.toString());
                    preparedStatement.setBigDecimal(n, bigDecimal);
                    break;
                }
                case 6: 
                case 7: {
                    number = object instanceof Number ? (Number)((Number)object) : (Number)Float.valueOf(object.toString());
                    preparedStatement.setFloat(n, number.floatValue());
                    break;
                }
                case 4: {
                    number = object instanceof Number ? (Number)((Number)object) : (Number)Integer.valueOf(object.toString());
                    preparedStatement.setInt(n, number.intValue());
                    break;
                }
                case -6: 
                case 5: {
                    number = object instanceof Number ? (Number)((Number)object) : (Number)Short.valueOf(object.toString());
                    preparedStatement.setShort(n, number.shortValue());
                    break;
                }
                case 93: {
                    preparedStatement.setTimestamp(n, (Timestamp)new TimestampType().convert(object));
                    break;
                }
                case 91: {
                    preparedStatement.setDate(n, (Date)new DateType().convert(object));
                    break;
                }
                case 92: {
                    preparedStatement.setTime(n, (Time)new TimeType().convert(object));
                    break;
                }
                case -3: 
                case -2: {
                    preparedStatement.setBytes(n, object.toString().getBytes());
                    break;
                }
                case -4: 
                case 2004: {
                    byte[] byArray = object.toString().getBytes();
                    preparedStatement.setBinaryStream(n, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
                    break;
                }
                case -15: 
                case -9: 
                case -8: 
                case 1: 
                case 12: {
                    preparedStatement.setString(n, object.toString());
                    break;
                }
                case -1: 
                case 2005: {
                    String string = object.toString();
                    preparedStatement.setCharacterStream(n, (Reader)new StringReader(string), string.length());
                    break;
                }
                default: {
                    preparedStatement.setObject(n, object, n2);
                    break;
                }
            }
        }
        catch (Exception exception) {
            mLogger.log(Level.SEVERE, "Invalid Data for" + n2 + "type --", exception);
            throw new DBException("Invalid Data for " + n2 + " type ", exception);
        }
    }

    public static Object validate(Object object, DBColumn dBColumn) throws DBException {
        int n = dBColumn.getJdbcType();
        if (object == null) {
            return null;
        }
        try {
            switch (n) {
                case -7: 
                case 16: {
                    return object instanceof Boolean ? object : new Boolean(object.toString());
                }
                case 93: {
                    return object instanceof Timestamp ? object : new TimestampType().convert(object);
                }
                case 91: {
                    return object instanceof Date ? object : new DateType().convert(object);
                }
                case 92: {
                    return object instanceof Time ? object : new TimeType().convert(object);
                }
                case -5: {
                    return object instanceof Long ? object : new Long(object.toString());
                }
                case 8: {
                    return object instanceof Double ? object : new Double(object.toString());
                }
                case 6: 
                case 7: {
                    return object instanceof Float ? object : new Float(object.toString());
                }
                case 2: 
                case 3: {
                    return object instanceof BigDecimal ? object : new BigDecimal(object.toString());
                }
                case 4: {
                    return object instanceof Integer ? object : new Integer(object.toString());
                }
                case 5: {
                    return object instanceof Short ? object : new Short(object.toString());
                }
                case -6: {
                    return object instanceof Byte ? object : new Byte(object.toString());
                }
                case -15: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: {
                    if (object.toString().length() > dBColumn.getPrecision()) {
                        String string = dBColumn.getQualifiedName();
                        String string2 = "Too large data '" + object + "' for column " + string;
                        throw new DBException(string2);
                    }
                    return object;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: 
                case 2005: {
                    char[] cArray = object.toString().toCharArray();
                    Byte[] byteArray = new Byte[cArray.length];
                    for (int i = 0; i < cArray.length; ++i) {
                        byteArray[i] = new Byte((byte)cArray[i]);
                    }
                    return BinaryToStringConverter.convertToString(byteArray, 2, true);
                }
            }
            return object;
        }
        catch (Exception exception) {
            String string = DataViewUtils.getStdSqlType(n);
            String string3 = dBColumn.getQualifiedName();
            String string4 = "Please enter valid data for " + string3 + " of " + string + " type";
            throw new DBException(string4);
        }
    }

    public static boolean isNullString(String string) {
        return string == null || string.trim().length() == 0;
    }
}

