/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.widgets.JRDesignElementWidget;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyboardElementMoveAction
extends WidgetAction.Adapter {
    public WidgetAction.State keyPressed(Widget widget, WidgetAction.WidgetKeyEvent event) {
        if (!(event.isControlDown() || event.getKeyCode() != 37 && event.getKeyCode() != 39 && event.getKeyCode() != 38 && event.getKeyCode() != 40)) {
            int len = event.isShiftDown() ? 10 : 1;
            Point delta = new Point(0, 0);
            switch (event.getKeyCode()) {
                case 37: {
                    delta.x -= len;
                    break;
                }
                case 39: {
                    delta.x = len;
                    break;
                }
                case 38: {
                    delta.y -= len;
                    break;
                }
                case 40: {
                    delta.y = len;
                }
            }
            ArrayList<JRDesignElementWidget> widgets = new ArrayList<JRDesignElementWidget>();
            AbstractReportObjectScene scene = (AbstractReportObjectScene)widget.getScene();
            for (Object obj : scene.getSelectedObjects()) {
                Widget w = scene.findWidget(obj);
                if (!(w instanceof JRDesignElementWidget)) continue;
                widgets.add((JRDesignElementWidget)w);
            }
            this.move(widgets, delta);
            return WidgetAction.State.CHAIN_ONLY;
        }
        return WidgetAction.State.REJECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void move(List<JRDesignElementWidget> widgets, Point delta) {
        ArrayList<Widget> changedWidgets = new ArrayList<Widget>();
        for (JRDesignElementWidget dew : widgets) {
            Point dewloc = dew.getPreferredLocation();
            dewloc.translate(delta.x, delta.y);
            dewloc = dew.convertLocalToModelLocation(dewloc);
            boolean b = dew.setChanging(true);
            try {
                dew.getElement().setX(dewloc.x);
                dew.getElement().setY(dewloc.y);
            }
            finally {
                dew.setChanging(b);
            }
            dew.updateBounds();
            dew.getSelectionWidget().updateBounds();
            changedWidgets.add(dew);
        }
        for (JRDesignElementWidget dew : widgets) {
            if (dew.getChildrenElements() == null) continue;
            this.updateChildren(dew, (AbstractReportObjectScene)dew.getScene(), changedWidgets);
        }
    }

    private void updateChildren(JRDesignElementWidget dew, AbstractReportObjectScene scene, ArrayList<Widget> changedWidgets) {
        List listOfElements = dew.getChildrenElements();
        for (int i = 0; i < listOfElements.size(); ++i) {
            JRDesignElement element;
            JRDesignElementWidget w;
            if (!(listOfElements.get(i) instanceof JRDesignElement) || changedWidgets.contains(w = (JRDesignElementWidget)scene.findWidget(element = (JRDesignElement)listOfElements.get(i)))) continue;
            w.updateBounds();
            w.getSelectionWidget().updateBounds();
            if (w.getChildrenElements() != null) {
                this.updateChildren(w, scene, changedWidgets);
            }
            changedWidgets.add(w);
        }
    }
}

