/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.welcome;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.EmptyBorder;
import org.openide.util.ImageUtilities;

public abstract class LinkButton
extends JButton
implements MouseListener,
ActionListener,
FocusListener {
    public static final String BULLET_IMAGE = "com/jaspersoft/ireport/designer/welcome/bullet.png";
    public static final Color LINK_COLOR = new Color(22, 75, 123);
    public static final Color LINK_IN_FOCUS_COLOR = new Color(22, 75, 123);
    public static final Color MOUSE_OVER_LINK_COLOR = new Color(255, 142, 0);
    public static final Color VISITED_LINK_COLOR = new Color(22, 75, 123);
    public static final Stroke LINK_IN_FOCUS_STROKE = new BasicStroke(1.0f, 2, 2, 0.0f, new float[]{0.0f, 2.0f}, 0.0f);
    public static final Font BUTTON_FONT = new Font(null, 1, 12);
    private boolean underline = false;
    final ImageIcon BULLET_ICON = new ImageIcon(ImageUtilities.loadImage((String)"com/jaspersoft/ireport/designer/welcome/bullet.png"));

    public LinkButton(String label, boolean showBullet) {
        super(label);
        this.setForeground(LINK_COLOR);
        this.setFont(BUTTON_FONT);
        this.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setHorizontalAlignment(2);
        this.addMouseListener(this);
        this.setFocusable(true);
        if (showBullet) {
            this.setIcon(this.BULLET_ICON);
        }
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setRolloverEnabled(true);
        this.setContentAreaFilled(false);
        this.addActionListener(this);
        this.addFocusListener(this);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        if (this.isEnabled()) {
            this.underline = true;
            this.setForeground(LINK_IN_FOCUS_COLOR);
            this.repaint();
            this.onMouseEntered(e);
            this.setForeground(MOUSE_OVER_LINK_COLOR);
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.isEnabled()) {
            this.underline = false;
            this.setForeground(this.isVisited() ? VISITED_LINK_COLOR : LINK_COLOR);
            this.repaint();
            this.onMouseExited(e);
        }
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Map rhints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (rhints == null && Boolean.getBoolean("swing.aatext")) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else if (rhints != null) {
            g2.addRenderingHints(rhints);
        }
        super.paintComponent(g2);
        Dimension size = this.getSize();
        if (this.hasFocus() && this.isEnabled()) {
            g2.setStroke(LINK_IN_FOCUS_STROKE);
            g2.setColor(LINK_IN_FOCUS_COLOR);
            g2.drawRect(0, 0, size.width - 1, size.height - 1);
        }
    }

    public void focusLost(FocusEvent e) {
    }

    public void focusGained(FocusEvent e) {
        Rectangle rect = this.getBounds();
        rect.grow(0, 12);
        this.scrollRectToVisible(rect);
    }

    protected void onMouseExited(MouseEvent e) {
    }

    protected void onMouseEntered(MouseEvent e) {
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.underline && this.isEnabled()) {
            Font f = this.getFont();
            FontMetrics fm = this.getFontMetrics(f);
            int iconWidth = 0;
            if (null != this.getIcon()) {
                iconWidth = this.getIcon().getIconWidth() + this.getIconTextGap();
            }
            int x1 = iconWidth;
            int y1 = fm.getHeight();
            int x2 = fm.stringWidth(this.getText()) + iconWidth;
            if (this.getText().length() > 0) {
                g.drawLine(x1, y1, x2, y1);
            }
        }
    }

    protected boolean isVisited() {
        return false;
    }
}

