/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.AbstractExporterNature;
import net.sf.jasperreports.engine.export.Cut;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.ExporterFilter;

public class JRXlsAbstractExporterNature
extends AbstractExporterNature {
    public static final String PROPERTY_BREAK_BEFORE_ROW = "net.sf.jasperreports.export.xls.break.before.row";
    public static final String PROPERTY_BREAK_AFTER_ROW = "net.sf.jasperreports.export.xls.break.after.row";
    protected boolean isIgnoreGraphics;
    protected boolean isIgnorePageMargins;

    protected JRXlsAbstractExporterNature(JasperReportsContext jasperReportsContext, ExporterFilter filter, boolean isIgnoreGraphics, boolean isIgnorePageMargins) {
        super(jasperReportsContext, filter);
        this.isIgnoreGraphics = isIgnoreGraphics;
        this.isIgnorePageMargins = isIgnorePageMargins;
    }

    protected JRXlsAbstractExporterNature(ExporterFilter filter, boolean isIgnoreGraphics) {
        this(DefaultJasperReportsContext.getInstance(), filter, isIgnoreGraphics, false);
    }

    protected JRXlsAbstractExporterNature(ExporterFilter filter, boolean isIgnoreGraphics, boolean isIgnorePageMargins) {
        this(DefaultJasperReportsContext.getInstance(), filter, isIgnoreGraphics, isIgnorePageMargins);
    }

    @Override
    public JRPropertiesUtil getPropertiesUtil() {
        return this.propertiesUtil;
    }

    @Override
    public boolean isToExport(JRPrintElement element) {
        return !(this.isIgnoreGraphics && !(element instanceof JRPrintText) && !(element instanceof JRPrintFrame) && !(element instanceof JRGenericPrintElement) || this.filter != null && !this.filter.isToExport(element));
    }

    @Override
    public boolean isDeep(JRPrintFrame frame) {
        return true;
    }

    @Override
    public boolean isSpanCells() {
        return true;
    }

    @Override
    public boolean isIgnoreLastRow() {
        return false;
    }

    @Override
    public boolean isHorizontallyMergeEmptyCells() {
        return false;
    }

    @Override
    public boolean isIgnorePageMargins() {
        return this.isIgnorePageMargins;
    }

    @Override
    public boolean isBreakBeforeRow(JRPrintElement element) {
        return element.hasProperties() && JRPropertiesUtil.asBoolean(element.getPropertiesMap().getProperty(PROPERTY_BREAK_BEFORE_ROW));
    }

    @Override
    public boolean isBreakAfterRow(JRPrintElement element) {
        return element.hasProperties() && JRPropertiesUtil.asBoolean(element.getPropertiesMap().getProperty(PROPERTY_BREAK_AFTER_ROW));
    }

    public Boolean getRowAutoFit(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.auto.fit.row")) {
            return this.getPropertiesUtil().getBooleanProperty(element, "net.sf.jasperreports.export.xls.auto.fit.row", false);
        }
        return null;
    }

    public Boolean getColumnAutoFit(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.auto.fit.column")) {
            return this.getPropertiesUtil().getBooleanProperty(element, "net.sf.jasperreports.export.xls.auto.fit.column", false);
        }
        return null;
    }

    public Boolean getShowGridlines(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.show.gridlines")) {
            return this.getPropertiesUtil().getBooleanProperty(element, "net.sf.jasperreports.export.xls.show.gridlines", true);
        }
        return null;
    }

    public Integer getCustomColumnWidth(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.column.width")) {
            return this.getPropertiesUtil().getIntegerProperty(element, "net.sf.jasperreports.export.xls.column.width", 0);
        }
        return null;
    }

    public Float getColumnWidthRatio(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.column.width.ratio")) {
            return Float.valueOf(this.getPropertiesUtil().getFloatProperty(element, "net.sf.jasperreports.export.xls.column.width.ratio", 0.0f));
        }
        return null;
    }

    public List<JRPropertiesUtil.PropertySuffix> getRowLevelSuffixes(JRPrintElement element) {
        if (element.hasProperties()) {
            return JRPropertiesUtil.getProperties(element, "net.sf.jasperreports.export.xls.row.outline.level.");
        }
        return null;
    }

    public String getSheetName(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.sheet.name")) {
            return this.getPropertiesUtil().getProperty(element, "net.sf.jasperreports.export.xls.sheet.name");
        }
        return null;
    }

    public Integer getPageScale(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.page.scale")) {
            return this.getPropertiesUtil().getIntegerProperty(element, "net.sf.jasperreports.export.xls.page.scale", 0);
        }
        return null;
    }

    public Integer getFirstPageNumber(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.first.page.number")) {
            return this.getPropertiesUtil().getIntegerProperty(element, "net.sf.jasperreports.export.xls.first.page.number", 0);
        }
        return null;
    }

    @Override
    public void setXProperties(CutsInfo xCuts, JRPrintElement element, int row1, int col1, int row2, int col2) {
        Map<String, Object> xCutsProperties = xCuts.getPropertiesMap();
        Cut cut = xCuts.getCut(col1);
        Boolean columnAutoFit = this.getColumnAutoFit(element);
        if (columnAutoFit != null) {
            if (!cut.hasProperty("net.sf.jasperreports.export.xls.auto.fit.column")) {
                cut.setProperty("net.sf.jasperreports.export.xls.auto.fit.column", columnAutoFit);
            } else {
                cut.setProperty("net.sf.jasperreports.export.xls.auto.fit.column", (Boolean)cut.getProperty("net.sf.jasperreports.export.xls.auto.fit.column") != false && columnAutoFit != false);
            }
        }
        Integer columnCustomWidth = this.getCustomColumnWidth(element);
        Integer cutColumnCustomWidth = (Integer)cut.getProperty("net.sf.jasperreports.export.xls.column.width");
        if (columnCustomWidth != null && (cutColumnCustomWidth == null || cutColumnCustomWidth < columnCustomWidth)) {
            cut.setProperty("net.sf.jasperreports.export.xls.column.width", columnCustomWidth);
        }
        this.setXProperties(xCutsProperties, element);
    }

    @Override
    public void setXProperties(Map<String, Object> xCutsProperties, JRPrintElement element) {
        Float widthRatio = this.getColumnWidthRatio(element);
        Float xCutsWidthRatio = (Float)xCutsProperties.get("net.sf.jasperreports.export.xls.column.width.ratio");
        if (widthRatio != null && (xCutsWidthRatio == null || xCutsWidthRatio.floatValue() < widthRatio.floatValue())) {
            xCutsProperties.put("net.sf.jasperreports.export.xls.column.width.ratio", widthRatio);
        }
    }

    @Override
    public void setYProperties(CutsInfo yCuts, JRPrintElement element, int row1, int col1, int row2, int col2) {
        Boolean showGridlines;
        Integer firstPageNumber;
        Integer pageScale;
        String sheetName;
        List<JRPropertiesUtil.PropertySuffix> rowLevelSuffixes;
        Map<String, Object> yCutsProperties = yCuts.getPropertiesMap();
        Cut cut = yCuts.getCut(row1);
        Boolean rowAutoFit = this.getRowAutoFit(element);
        if (rowAutoFit != null) {
            if (!cut.hasProperty("net.sf.jasperreports.export.xls.auto.fit.row")) {
                cut.setProperty("net.sf.jasperreports.export.xls.auto.fit.row", rowAutoFit);
            } else {
                cut.setProperty("net.sf.jasperreports.export.xls.auto.fit.row", (Boolean)cut.getProperty("net.sf.jasperreports.export.xls.auto.fit.row") != false && rowAutoFit != false);
            }
        }
        if ((rowLevelSuffixes = this.getRowLevelSuffixes(element)) != null && !rowLevelSuffixes.isEmpty()) {
            TreeMap<String, Boolean> levelMap = new TreeMap<String, Boolean>();
            for (JRPropertiesUtil.PropertySuffix suffix : rowLevelSuffixes) {
                String level = suffix.getSuffix();
                String marker = suffix.getValue();
                levelMap.put(level, "end".equalsIgnoreCase(marker));
            }
            cut.setProperty("net.sf.jasperreports.export.xls.row.outline.level.", levelMap);
        }
        if ((sheetName = this.getSheetName(element)) != null) {
            cut.setProperty("net.sf.jasperreports.export.xls.sheet.name", sheetName);
        }
        if ((pageScale = this.getPageScale(element)) != null && pageScale > 9 && pageScale < 401) {
            cut.setProperty("net.sf.jasperreports.export.xls.page.scale", pageScale);
        }
        if ((firstPageNumber = this.getFirstPageNumber(element)) != null) {
            cut.setProperty("net.sf.jasperreports.export.xls.first.page.number", firstPageNumber);
        }
        if ((showGridlines = this.getShowGridlines(element)) != null) {
            cut.setProperty("net.sf.jasperreports.export.xls.show.gridlines", showGridlines);
        }
        this.setYProperties(yCutsProperties, element);
    }

    @Override
    public void setYProperties(Map<String, Object> yCutsProperties, JRPrintElement element) {
    }
}

