/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.table;

import com.jaspersoft.ireport.components.table.TableObjectScene;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRCommonText;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.fill.JRMeasuredText;
import net.sf.jasperreports.engine.fill.JRTextMeasurer;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import net.sf.jasperreports.engine.util.JRTextMeasurerUtil;
import org.netbeans.api.visual.animator.AnimatorEvent;
import org.netbeans.api.visual.animator.AnimatorListener;
import org.netbeans.api.visual.animator.SceneAnimator;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class DefaultTableCellElementsLayout {
    public static final int VERTICAL_LAYOUT = 0;
    public static final int HORIZONTAL_LAYOUT = 1;
    private static DefaultTableCellElementsLayout instance;

    public static DefaultTableCellElementsLayout getInstance() {
        if (instance == null) {
            instance = new DefaultTableCellElementsLayout();
        }
        return instance;
    }

    public static void doLayout(final DesignCell cell, final TableObjectScene scene, final int type) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DefaultTableCellElementsLayout.getInstance().organizeCellElements(cell, scene, type);
            }
        });
    }

    public static void doLayout(DesignCell cell, TableObjectScene scene) {
        DefaultTableCellElementsLayout.doLayout(cell, scene, 0);
    }

    private void organizeCellElements(DesignCell cell, TableObjectScene sc, int type) {
        Rectangle cellBounds = sc.getTableMatrix().getCellBounds(cell);
        Insets padding = new Insets(0, 0, 0, 0);
        if (cell.getStyle() != null && cell.getStyle().getLineBox() != null) {
            if (cell.getStyle().getLineBox().getLeftPadding() != null) {
                padding.left = cell.getStyle().getLineBox().getLeftPadding();
            }
            if (cell.getStyle().getLineBox().getRightPadding() != null) {
                padding.right = cell.getStyle().getLineBox().getRightPadding();
            }
            if (cell.getStyle().getLineBox().getTopPadding() != null) {
                padding.top = cell.getStyle().getLineBox().getTopPadding();
            }
            if (cell.getStyle().getLineBox().getBottomPadding() != null) {
                padding.bottom = cell.getStyle().getLineBox().getBottomPadding();
            }
        }
        if (cellBounds == null) {
            return;
        }
        int cW = cellBounds.width - padding.left - padding.right;
        int cH = cellBounds.height - padding.top - padding.bottom;
        List children = cell.getChildren();
        int y = padding.top;
        int x = padding.left;
        if (children.size() == 0) {
            return;
        }
        int h = cH / children.size();
        int wd = cW / children.size();
        SceneAnimator animator = new SceneAnimator((Scene)sc);
        CellAnimatorListener listener = new CellAnimatorListener();
        animator.getPreferredBoundsAnimator().addAnimatorListener((AnimatorListener)listener);
        animator.getPreferredLocationAnimator().addAnimatorListener((AnimatorListener)listener);
        listener.addAnimation();
        listener.addAnimation();
        for (int i = 0; i < children.size(); ++i) {
            if (!(children.get(i) instanceof JRDesignElement)) continue;
            JRDesignElement element = (JRDesignElement)children.get(i);
            if (type == 0) {
                listener.getNewSizes().put(element, new Rectangle(0, i * h, cW, h));
                continue;
            }
            if (type != 1) continue;
            listener.getNewSizes().put(element, new Rectangle(i * wd, 0, wd, cH));
        }
        for (JRDesignElement element : listener.getNewSizes().keySet()) {
            Rectangle rectangle = listener.getNewSizes().get(element);
            Widget w = sc.findWidget(element);
            if (w == null) continue;
            Rectangle r = w.getPreferredBounds();
            r.width = rectangle.width;
            r.height = rectangle.height;
            animator.animatePreferredBounds(w, r);
            Point p = new Point(w.getLocation());
            p.x += rectangle.x - element.getX();
            p.y += rectangle.y - element.getY();
            animator.animatePreferredLocation(w, p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CellAnimatorListener
    implements AnimatorListener {
        private HashMap<JRDesignElement, Rectangle> newSizes = new HashMap();
        int animations = 0;

        private CellAnimatorListener() {
        }

        public void addAnimation() {
            ++this.animations;
        }

        public void animatorStarted(AnimatorEvent arg0) {
        }

        public void animatorReset(AnimatorEvent arg0) {
        }

        public void animatorFinished(AnimatorEvent arg0) {
            --this.animations;
            if (this.animations == 0) {
                block0: for (JRDesignElement element : this.getNewSizes().keySet()) {
                    Rectangle rectangle = this.getNewSizes().get(element);
                    element.setX(rectangle.x);
                    element.setY(rectangle.y);
                    element.setWidth(rectangle.width);
                    element.setHeight(rectangle.height);
                    if (!(element instanceof JRDesignTextElement)) continue;
                    JRStyledTextParser styledTextParser = JRStyledTextParser.getInstance();
                    JRDesignTextElement dte = (JRDesignTextElement)element;
                    dte.setFontSize((Integer)null);
                    for (int i = dte.getFontSize() - 1; i > 1; --i) {
                        String text = "test";
                        Map attributes = JRFontUtil.getAttributes(new HashMap(), (JRFont)dte, (Locale)Locale.getDefault());
                        JRStyledText styledText = styledTextParser.getStyledText(attributes, text, "styled".equals(dte.getMarkup()), Locale.getDefault());
                        JRTextMeasurer measurer = JRTextMeasurerUtil.getInstance((JasperReportsContext)DefaultJasperReportsContext.getInstance()).createTextMeasurer((JRCommonText)dte);
                        JRMeasuredText measuredText = measurer.measure(styledText, 0, dte.getHeight(), true);
                        if (!(measuredText.getTextHeight() > (float)dte.getHeight()) || i <= 1) continue block0;
                        dte.setFontSize(i);
                    }
                }
            }
        }

        public void animatorPreTick(AnimatorEvent arg0) {
        }

        public void animatorPostTick(AnimatorEvent arg0) {
        }

        public HashMap<JRDesignElement, Rectangle> getNewSizes() {
            return this.newSizes;
        }
    }
}

