/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.table.actions;

import com.jaspersoft.ireport.components.table.TableElementNode;
import com.jaspersoft.ireport.components.table.TableModelUtils;
import com.jaspersoft.ireport.components.table.nodes.TableCellNode;
import com.jaspersoft.ireport.components.table.nodes.TableColumnGroupNode;
import com.jaspersoft.ireport.components.table.nodes.TableNullCellNode;
import com.jaspersoft.ireport.components.table.nodes.TableSectionNode;
import com.jaspersoft.ireport.components.table.undo.AddTableColumnUndoableEdit;
import com.jaspersoft.ireport.designer.IReportManager;
import java.util.List;
import javax.swing.undo.UndoableEdit;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AddTableColumnAction
extends NodeAction {
    public static final int BEFORE = 0;
    public static final int AFTER = 1;
    public static final int AT_THE_END = 2;
    public static final int AT_THE_START = 3;

    public abstract int getWhere();

    public abstract String getName();

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    public BaseColumn createNewColumn() {
        StandardColumn subColumn = new StandardColumn();
        subColumn.setWidth(Integer.valueOf(90));
        DesignCell detailCell = new DesignCell();
        detailCell.setHeight(Integer.valueOf(30));
        subColumn.setDetailCell((Cell)detailCell);
        DesignCell tableHeaderCell = new DesignCell();
        tableHeaderCell.setHeight(Integer.valueOf(30));
        subColumn.setTableHeader((Cell)tableHeaderCell);
        DesignCell columnHeaderCell = new DesignCell();
        columnHeaderCell.setHeight(Integer.valueOf(30));
        subColumn.setColumnHeader((Cell)columnHeaderCell);
        DesignCell tableFooterCell = new DesignCell();
        tableFooterCell.setHeight(Integer.valueOf(30));
        subColumn.setColumnFooter((Cell)tableFooterCell);
        DesignCell columnFooterCell = new DesignCell();
        columnFooterCell.setHeight(Integer.valueOf(30));
        subColumn.setTableFooter((Cell)columnFooterCell);
        return subColumn;
    }

    protected void performAction(Node[] activatedNodes) {
        Object cellNode;
        BaseColumn newColumn = this.createNewColumn();
        StandardTable table = null;
        JasperDesign jd = null;
        int index = -1;
        Object container = null;
        if (activatedNodes[0] instanceof TableElementNode) {
            TableElementNode tableNode = (TableElementNode)activatedNodes[0];
            index = this.calculateIndex(tableNode.getTable().getColumns(), -1, this.getWhere());
            container = tableNode.getTable();
            jd = tableNode.getJasperDesign();
            table = tableNode.getTable();
        } else if (activatedNodes[0] instanceof TableSectionNode) {
            TableSectionNode tableSectionNode = (TableSectionNode)activatedNodes[0];
            index = this.calculateIndex(tableSectionNode.getTable().getColumns(), -1, this.getWhere());
            container = tableSectionNode.getTable();
            jd = tableSectionNode.getJasperDesign();
            table = tableSectionNode.getTable();
        } else if (activatedNodes[0] instanceof TableColumnGroupNode) {
            TableColumnGroupNode columnNode = (TableColumnGroupNode)activatedNodes[0];
            index = this.calculateIndex(columnNode.getColumnGroup().getColumns(), -1, this.getWhere());
            container = columnNode.getColumnGroup();
            jd = columnNode.getJasperDesign();
            table = columnNode.getTable();
        } else if (activatedNodes[0] instanceof TableCellNode) {
            cellNode = (TableCellNode)activatedNodes[0];
            BaseColumn col = ((TableCellNode)cellNode).getColumn();
            container = this.findParentColumn(((TableCellNode)cellNode).getTable(), col);
            List columns = container instanceof StandardTable ? container.getColumns() : ((StandardColumnGroup)container).getColumns();
            index = this.calculateIndex(columns, columns.indexOf(col), this.getWhere());
            jd = ((TableCellNode)cellNode).getJasperDesign();
            table = ((TableCellNode)cellNode).getTable();
        } else if (activatedNodes[0] instanceof TableNullCellNode) {
            cellNode = (TableNullCellNode)activatedNodes[0];
            BaseColumn col = ((TableNullCellNode)((Object)cellNode)).getColumn();
            container = this.findParentColumn(((TableNullCellNode)((Object)cellNode)).getTable(), col);
            List columns = container instanceof StandardTable ? container.getColumns() : ((StandardColumnGroup)container).getColumns();
            index = this.calculateIndex(columns, columns.indexOf(col), this.getWhere());
            jd = (JasperDesign)cellNode.getLookup().lookup(JasperDesign.class);
            table = ((TableNullCellNode)((Object)cellNode)).getTable();
        } else {
            cellNode = null;
            for (Node parent = activatedNodes[0].getParentNode(); parent != null; parent = parent.getParentNode()) {
                if (!(parent instanceof TableCellNode)) continue;
                cellNode = (TableCellNode)parent;
                break;
            }
            if (cellNode != null) {
                BaseColumn col = ((TableCellNode)cellNode).getColumn();
                container = this.findParentColumn(((TableCellNode)cellNode).getTable(), col);
                List columns = container instanceof StandardTable ? container.getColumns() : ((StandardColumnGroup)container).getColumns();
                index = this.calculateIndex(columns, columns.indexOf(col), this.getWhere());
                jd = ((TableCellNode)cellNode).getJasperDesign();
                table = ((TableCellNode)cellNode).getTable();
            }
        }
        if (container != null && index != -1) {
            UndoableEdit edit = this.addColumn(table, jd, container, newColumn, index);
            IReportManager.getInstance().addUndoableEdit(edit);
            TableModelUtils.fixTableLayout(table, jd);
        }
    }

    protected UndoableEdit addColumn(StandardTable table, JasperDesign jd, Object container, BaseColumn newColumn, int index) {
        List columns = container instanceof StandardTable ? ((StandardTable)container).getColumns() : ((StandardColumnGroup)container).getColumns();
        columns.add(index, newColumn);
        if (container instanceof StandardTable) {
            ((StandardTable)container).getEventSupport().fireCollectionElementAddedEvent("columns", null, index);
        } else {
            ((StandardColumnGroup)container).getEventSupport().fireCollectionElementAddedEvent("columns", null, index);
        }
        AddTableColumnUndoableEdit edit = new AddTableColumnUndoableEdit(table, jd, newColumn, container, index);
        return edit;
    }

    protected Object findParentColumn(StandardTable table, BaseColumn col) {
        if (table.getColumns().contains(col)) {
            return table;
        }
        List columns = table.getColumns();
        for (BaseColumn c : columns) {
            Object obj;
            if (!(c instanceof StandardColumnGroup) || (obj = this.findColumn((StandardColumnGroup)c, col)) == null) continue;
            return obj;
        }
        return null;
    }

    public Object findColumn(StandardColumnGroup group, BaseColumn col) {
        if (group.getColumns().contains(col)) {
            return group;
        }
        List columns = group.getColumns();
        for (BaseColumn c : columns) {
            Object obj;
            if (!(c instanceof StandardColumnGroup) || (obj = this.findColumn((StandardColumnGroup)c, col)) == null) continue;
            return obj;
        }
        return null;
    }

    protected int calculateIndex(List<BaseColumn> columns, int currentIndex, int where) {
        switch (where) {
            case 0: {
                if (currentIndex >= 0) {
                    return currentIndex;
                }
            }
            case 3: {
                return 0;
            }
            case 1: {
                if (currentIndex >= 0) {
                    return currentIndex + 1;
                }
            }
            case 2: {
                return columns.size();
            }
        }
        return 0;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        if (activatedNodes[0] instanceof TableElementNode || activatedNodes[0] instanceof TableSectionNode || activatedNodes[0] instanceof TableColumnGroupNode || activatedNodes[0] instanceof TableCellNode || activatedNodes[0] instanceof TableNullCellNode) {
            return true;
        }
        for (Node parent = activatedNodes[0].getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (!(parent instanceof TableCellNode)) continue;
            return true;
        }
        return false;
    }
}

