/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.base;

import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.base.JRBaseChartDataset;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBaseXyDataset
extends JRBaseChartDataset
implements JRXyDataset {
    private static final long serialVersionUID = 10200L;
    protected JRXySeries[] xySeries;

    public JRBaseXyDataset(JRChartDataset dataset) {
        super(dataset);
    }

    public JRBaseXyDataset(JRXyDataset dataset, JRBaseObjectFactory factory) {
        super(dataset, factory);
        JRXySeries[] srcXySeries = dataset.getSeries();
        if (srcXySeries != null && srcXySeries.length > 0) {
            this.xySeries = new JRXySeries[srcXySeries.length];
            int i = 0;
            while (i < this.xySeries.length) {
                this.xySeries[i] = factory.getXySeries(srcXySeries[i]);
                ++i;
            }
        }
    }

    @Override
    public JRXySeries[] getSeries() {
        return this.xySeries;
    }

    @Override
    public byte getDatasetType() {
        return 3;
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void validate(JRVerifier verifier) {
        verifier.verify(this);
    }

    @Override
    public Object clone() {
        JRBaseXyDataset clone = (JRBaseXyDataset)super.clone();
        clone.xySeries = (JRXySeries[])JRCloneUtils.cloneArray((JRCloneable[])this.xySeries);
        return clone;
    }
}

