/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.sort;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.components.sort.FilterTypesEnum;
import net.sf.jasperreports.engine.type.SortOrderEnum;

public class SortElementUtils {
    private static Map<String, SortOrderEnum> sortOrderMapping = new HashMap<String, SortOrderEnum>();

    static {
        sortOrderMapping.put("Asc", SortOrderEnum.ASCENDING);
        sortOrderMapping.put("Dsc", SortOrderEnum.DESCENDING);
    }

    public static String[] extractColumnInfo(String sortColumn) {
        return sortColumn.split(":");
    }

    public static String packSortColumnInfo(String columnName, String columnType, String sortOrder) {
        StringBuffer sb = new StringBuffer();
        sb.append(columnName).append(":").append(columnType).append(":").append(sortOrder);
        return sb.toString();
    }

    public static boolean isValidSortData(String sortData) {
        return sortData != null && sortData.indexOf(":") >= 0 && sortData.split(":").length > 1;
    }

    public static SortOrderEnum getSortOrder(String sortOrder) {
        return sortOrderMapping.get(sortOrder);
    }

    public static FilterTypesEnum getFilterType(Class<?> clazz) {
        FilterTypesEnum result = null;
        if (Number.class.isAssignableFrom(clazz)) {
            result = FilterTypesEnum.NUMERIC;
        } else if (String.class.isAssignableFrom(clazz)) {
            result = FilterTypesEnum.TEXT;
        } else if (Date.class.isAssignableFrom(clazz)) {
            result = FilterTypesEnum.DATE;
        } else if (Boolean.class.isAssignableFrom(clazz)) {
            result = FilterTypesEnum.BOOLEAN;
        }
        return result;
    }
}

