/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.sort;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.sort.FieldFilter;
import net.sf.jasperreports.components.sort.SortElementUtils;
import net.sf.jasperreports.engine.CompositeDatasetFilter;
import net.sf.jasperreports.engine.DatasetFilter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.ParameterContributor;
import net.sf.jasperreports.engine.ParameterContributorContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.design.JRAbstractCompiler;
import net.sf.jasperreports.engine.design.JRDesignSortField;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;
import net.sf.jasperreports.engine.type.SortOrderEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SortParameterContributor
implements ParameterContributor {
    private static final Log log = LogFactory.getLog(SortParameterContributor.class);
    private final ParameterContributorContext context;

    public SortParameterContributor(ParameterContributorContext context) {
        this.context = context;
    }

    @Override
    public void contributeParameters(Map<String, Object> parameterValues) throws JRException {
        ReportContext reportContext = (ReportContext)parameterValues.get("REPORT_CONTEXT");
        if (reportContext != null) {
            String reportActionData = (String)reportContext.getParameterValue("jr.sort");
            String paramTableName = (String)reportContext.getParameterValue("jr.dsr");
            JasperReport jasperReport = (JasperReport)this.context.getParameterValues().get("JASPER_REPORT");
            String currentDataset = JRAbstractCompiler.getUnitName(jasperReport, this.context.getDataset());
            if (paramTableName == null || !paramTableName.equals(currentDataset)) {
                return;
            }
            String currentTableSortFieldsParam = String.valueOf(paramTableName) + ".SORT_FIELDS";
            String currentTableFiltersParam = String.valueOf(paramTableName) + ".FILTER";
            List existingFields = (List)reportContext.getParameterValue(currentTableSortFieldsParam);
            ArrayList<JRSortField> sortFields = new ArrayList<JRSortField>();
            if (existingFields != null) {
                sortFields.addAll(existingFields);
            }
            if (reportActionData != null) {
                String[] tokens = reportActionData.split(",");
                int i = 0;
                while (i < tokens.length) {
                    String token = tokens[i];
                    String[] chunks = SortElementUtils.extractColumnInfo(token);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Adding sort " + token));
                    }
                    this.overwriteExistingSortField(sortFields, new JRDesignSortField(chunks[0], SortFieldTypeEnum.getByName(chunks[1]), SortElementUtils.getSortOrder(chunks[2])));
                    ++i;
                }
            }
            parameterValues.put("SORT_FIELDS", sortFields);
            reportContext.setParameterValue(currentTableSortFieldsParam, sortFields);
            String paramFieldName = (String)reportContext.getParameterValue("jr.fltrFld");
            String paramFieldValueStart = (String)reportContext.getParameterValue("jr.fltrVlStrt");
            String paramFieldValueEnd = (String)reportContext.getParameterValue("jr.fltrVlEnd");
            String paramFilterType = (String)reportContext.getParameterValue("jr.fltrTp");
            String paramFilterTypeOperator = (String)reportContext.getParameterValue("jr.fltrTpOprtr");
            String paramFilterPattern = (String)reportContext.getParameterValue("jr.fltrPtrn");
            DatasetFilter existingFilter = (DatasetFilter)reportContext.getParameterValue(currentTableFiltersParam);
            DatasetFilter combined = null;
            if (paramFieldName != null && paramFieldValueStart != null && paramFilterType != null && paramFilterTypeOperator != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Filtering by " + paramFieldName + ": " + paramFieldValueStart));
                }
                if (existingFilter != null) {
                    ArrayList<DatasetFilter> filters = new ArrayList<DatasetFilter>();
                    this.getFieldFilters(existingFilter, filters, null);
                    FieldFilter filterForCurrentField = null;
                    for (DatasetFilter df : filters) {
                        if (!((FieldFilter)df).getField().equals(paramFieldName)) continue;
                        filterForCurrentField = (FieldFilter)df;
                        break;
                    }
                    if (filterForCurrentField != null) {
                        filterForCurrentField.setFilterTypeOperator(paramFilterTypeOperator);
                        filterForCurrentField.setFilterValueEnd(paramFieldValueEnd);
                        filterForCurrentField.setFilterValueStart(paramFieldValueStart);
                        filterForCurrentField.setIsValid(null);
                        combined = new CompositeDatasetFilter(filters);
                    } else {
                        FieldFilter filter = new FieldFilter(paramFieldName, paramFieldValueStart, paramFieldValueEnd, paramFilterType, paramFilterTypeOperator);
                        filter.setFilterPattern(paramFilterPattern);
                        combined = CompositeDatasetFilter.combine(existingFilter, filter);
                    }
                } else {
                    FieldFilter filter = new FieldFilter(paramFieldName, paramFieldValueStart, paramFieldValueEnd, paramFilterType, paramFilterTypeOperator);
                    filter.setFilterPattern(paramFilterPattern);
                    combined = CompositeDatasetFilter.combine(existingFilter, filter);
                }
            }
            if (combined != null) {
                parameterValues.put("FILTER", combined);
                reportContext.setParameterValue(currentTableFiltersParam, combined);
            } else if (existingFilter != null) {
                parameterValues.put("FILTER", existingFilter);
                reportContext.setParameterValue(currentTableFiltersParam, existingFilter);
            }
            String filterForFieldToRemove = (String)reportContext.getParameterValue("jr.rmvFltr");
            if (filterForFieldToRemove != null && existingFilter != null) {
                ArrayList<DatasetFilter> filters = new ArrayList<DatasetFilter>();
                this.getFieldFilters(existingFilter, filters, null);
                FieldFilter filterToRemove = null;
                for (DatasetFilter df : filters) {
                    if (!((FieldFilter)df).getField().equals(filterForFieldToRemove)) continue;
                    filterToRemove = (FieldFilter)df;
                    break;
                }
                if (filterToRemove != null) {
                    filters.remove(filterToRemove);
                    combined = new CompositeDatasetFilter(filters);
                    parameterValues.put("FILTER", combined);
                    reportContext.setParameterValue(currentTableFiltersParam, combined);
                }
            }
        }
    }

    private void overwriteExistingSortField(List<JRSortField> sortFields, JRSortField newSortField) {
        int indexOfExistingSortField = sortFields.indexOf(newSortField);
        if (indexOfExistingSortField != -1) {
            boolean mustRemove = sortFields.get(indexOfExistingSortField).getOrderValue().equals(SortOrderEnum.DESCENDING);
            if (mustRemove) {
                sortFields.remove(indexOfExistingSortField);
            } else {
                ((JRDesignSortField)sortFields.get(indexOfExistingSortField)).setOrder(newSortField.getOrderValue());
            }
        } else if (newSortField.getOrderValue() != null) {
            sortFields.add(newSortField);
        }
    }

    private void getFieldFilters(DatasetFilter existingFilter, List<DatasetFilter> fieldFilters, String fieldName) {
        if (existingFilter instanceof FieldFilter) {
            if (fieldName == null || fieldName != null && ((FieldFilter)existingFilter).getField().equals(fieldName)) {
                fieldFilters.add(existingFilter);
            }
        } else if (existingFilter instanceof CompositeDatasetFilter) {
            for (DatasetFilter datasetFilter : ((CompositeDatasetFilter)existingFilter).getFilters()) {
                this.getFieldFilters(datasetFilter, fieldFilters, fieldName);
            }
        }
    }

    @Override
    public void dispose() {
    }
}

