/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRLoader;

public final class JRPropertiesUtil {
    public static final String PROPERTY_PREFIX = "net.sf.jasperreports.";
    private JasperReportsContext jasperReportsContext;

    private JRPropertiesUtil(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public static JRPropertiesUtil getInstance(JasperReportsContext jasperReportsContext) {
        return new JRPropertiesUtil(jasperReportsContext);
    }

    public static Properties loadProperties(String name, Properties defaults) throws JRException {
        Properties properties = null;
        InputStream is = null;
        try {
            is = JRLoader.getLocationInputStream(name);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (is != null) {
            properties = new Properties(defaults);
            try {
                try {
                    properties.load(is);
                }
                catch (IOException e) {
                    throw new JRException("Failed to load properties file \"" + name + "\"", e);
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    public String getProperty(String key) {
        return this.jasperReportsContext.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.jasperReportsContext.setProperty(key, value);
    }

    public void removeProperty(String key) {
        this.jasperReportsContext.removeProperty(key);
    }

    public boolean getBooleanProperty(String key) {
        return JRPropertiesUtil.asBoolean(this.getProperty(key));
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        return JRPropertiesUtil.asBoolean(this.getProperty(key), defaultValue);
    }

    public int getIntegerProperty(String key) {
        return JRPropertiesUtil.asInteger(this.getProperty(key));
    }

    public float getFloatProperty(String key) {
        return JRPropertiesUtil.asFloat(this.getProperty(key));
    }

    public static boolean asBoolean(String value) {
        return Boolean.valueOf(value == null ? value : value.trim());
    }

    public static boolean asBoolean(String value, boolean defaultValue) {
        return value == null ? defaultValue : Boolean.valueOf(value.trim());
    }

    public static int asInteger(String value) {
        return Integer.parseInt(value == null ? value : value.trim());
    }

    public static float asFloat(String value) {
        return Float.parseFloat(value == null ? value : value.trim());
    }

    public List<PropertySuffix> getProperties(String prefix) {
        Map<String, String> properties = this.jasperReportsContext.getProperties();
        int prefixLength = prefix.length();
        ArrayList<PropertySuffix> values = new ArrayList<PropertySuffix>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String name = entry.getKey();
            if (!name.startsWith(prefix)) continue;
            String suffix = name.substring(prefixLength);
            String value = entry.getValue();
            values.add(new PropertySuffix(name, suffix, value));
        }
        return values;
    }

    public static List<PropertySuffix> getProperties(JRPropertiesHolder propertiesHolder, String prefix) {
        return JRPropertiesUtil.getProperties(JRPropertiesUtil.getOwnProperties(propertiesHolder), prefix);
    }

    public List<PropertySuffix> getAllProperties(JRPropertiesHolder propertiesHolder, String prefix) {
        return this.getAllProperties(JRPropertiesUtil.getOwnProperties(propertiesHolder), prefix);
    }

    public static List<PropertySuffix> getProperties(JRPropertiesMap propertiesMap, String prefix) {
        int prefixLength = prefix.length();
        ArrayList<PropertySuffix> values = new ArrayList<PropertySuffix>();
        if (propertiesMap != null) {
            String[] propertyNames = propertiesMap.getPropertyNames();
            int i = 0;
            while (i < propertyNames.length) {
                String name = propertyNames[i];
                if (name.startsWith(prefix)) {
                    String suffix = name.substring(prefixLength);
                    String value = propertiesMap.getProperty(name);
                    values.add(new PropertySuffix(name, suffix, value));
                }
                ++i;
            }
        }
        return values;
    }

    public List<PropertySuffix> getAllProperties(JRPropertiesMap propertiesMap, String prefix) {
        List<PropertySuffix> collected;
        List<PropertySuffix> own = JRPropertiesUtil.getProperties(propertiesMap, prefix);
        List<PropertySuffix> global = this.getProperties(prefix);
        if (own.isEmpty()) {
            collected = global;
        } else {
            if (!global.isEmpty()) {
                HashSet<String> ownSuffixes = new HashSet<String>();
                for (PropertySuffix prop : own) {
                    ownSuffixes.add(prop.getSuffix());
                }
                for (PropertySuffix prop : global) {
                    if (ownSuffixes.contains(prop.getSuffix())) continue;
                    own.add(prop);
                }
            }
            collected = own;
        }
        return collected;
    }

    public String getProperty(JRPropertiesHolder propertiesHolder, String key) {
        String value = null;
        while (propertiesHolder != null && value == null) {
            if (propertiesHolder.hasProperties()) {
                value = propertiesHolder.getPropertiesMap().getProperty(key);
            }
            propertiesHolder = propertiesHolder.getParentProperties();
        }
        if (value == null) {
            value = this.getProperty(key);
        }
        return value;
    }

    public String getProperty(String key, JRPropertiesHolder ... propertiesHolders) {
        String value = null;
        JRPropertiesHolder[] jRPropertiesHolderArray = propertiesHolders;
        int n = propertiesHolders.length;
        int n2 = 0;
        block0: while (n2 < n) {
            JRPropertiesHolder propertiesHolder = jRPropertiesHolderArray[n2];
            while (propertiesHolder != null) {
                String prop;
                if (propertiesHolder.hasProperties() && (prop = propertiesHolder.getPropertiesMap().getProperty(key)) != null) {
                    value = prop;
                    break block0;
                }
                propertiesHolder = propertiesHolder.getParentProperties();
            }
            ++n2;
        }
        if (value == null) {
            value = this.getProperty(key);
        }
        return value;
    }

    public String getProperty(JRPropertiesMap propertiesMap, String key) {
        String value = null;
        if (propertiesMap != null) {
            value = propertiesMap.getProperty(key);
        }
        if (value == null) {
            value = this.getProperty(key);
        }
        return value;
    }

    public boolean getBooleanProperty(JRPropertiesHolder propertiesHolder, String key, boolean defaultValue) {
        String value = this.getProperty(propertiesHolder, key);
        return value == null ? defaultValue : JRPropertiesUtil.asBoolean(value);
    }

    public boolean getBooleanProperty(String key, boolean defaultValue, JRPropertiesHolder ... propertiesHolders) {
        String value = this.getProperty(key, propertiesHolders);
        return value == null ? defaultValue : JRPropertiesUtil.asBoolean(value);
    }

    public boolean getBooleanProperty(JRPropertiesMap propertiesMap, String key, boolean defaultValue) {
        String value = this.getProperty(propertiesMap, key);
        return value == null ? defaultValue : JRPropertiesUtil.asBoolean(value);
    }

    public Boolean getBooleanProperty(JRPropertiesMap propertiesMap, String key) {
        String value = this.getProperty(propertiesMap, key);
        return value == null ? null : Boolean.valueOf(JRPropertiesUtil.asBoolean(value));
    }

    public Integer getIntegerProperty(JRPropertiesHolder propertiesHolder, String key) {
        String value = this.getProperty(propertiesHolder, key);
        return value == null ? null : Integer.valueOf(JRPropertiesUtil.asInteger(value));
    }

    public int getIntegerProperty(JRPropertiesHolder propertiesHolder, String key, int defaultValue) {
        String value = this.getProperty(propertiesHolder, key);
        return value == null ? defaultValue : JRPropertiesUtil.asInteger(value);
    }

    public int getIntegerProperty(JRPropertiesMap propertiesMap, String key, int defaultValue) {
        String value = this.getProperty(propertiesMap, key);
        return value == null ? defaultValue : JRPropertiesUtil.asInteger(value);
    }

    public int getIntegerProperty(String key, int defaultValue) {
        String value = this.getProperty(key);
        return value == null ? defaultValue : JRPropertiesUtil.asInteger(value);
    }

    public Float getFloatProperty(JRPropertiesHolder propertiesHolder, String key) {
        String value = this.getProperty(propertiesHolder, key);
        return value == null ? null : Float.valueOf(JRPropertiesUtil.asFloat(value));
    }

    public float getFloatProperty(JRPropertiesHolder propertiesHolder, String key, float defaultValue) {
        String value = this.getProperty(propertiesHolder, key);
        return value == null ? defaultValue : JRPropertiesUtil.asFloat(value);
    }

    public float getFloatProperty(JRPropertiesMap propertiesMap, String key, float defaultValue) {
        String value = this.getProperty(propertiesMap, key);
        return value == null ? defaultValue : JRPropertiesUtil.asFloat(value);
    }

    public float getFloatProperty(String key, float defaultValue) {
        String value = this.getProperty(key);
        return value == null ? defaultValue : JRPropertiesUtil.asFloat(value);
    }

    public static long asLong(String value) {
        return Long.parseLong(value == null ? value : value.trim());
    }

    public long getLongProperty(String key) {
        return JRPropertiesUtil.asLong(this.getProperty(key));
    }

    public long getLongProperty(JRPropertiesMap propertiesMap, String key, int defaultValue) {
        return this.getLongProperty(propertiesMap, key, (long)defaultValue);
    }

    public long getLongProperty(JRPropertiesHolder propertiesHolder, String key, int defaultValue) {
        return this.getLongProperty(propertiesHolder, key, (long)defaultValue);
    }

    public long getLongProperty(JRPropertiesMap propertiesMap, String key, long defaultValue) {
        String value = this.getProperty(propertiesMap, key);
        return value == null ? defaultValue : JRPropertiesUtil.asLong(value);
    }

    public long getLongProperty(JRPropertiesHolder propertiesHolder, String key, long defaultValue) {
        String value = this.getProperty(propertiesHolder, key);
        return value == null ? defaultValue : JRPropertiesUtil.asLong(value);
    }

    protected static JRPropertiesMap getOwnProperties(JRPropertiesHolder propertiesHolder) {
        return propertiesHolder.hasProperties() ? propertiesHolder.getPropertiesMap() : null;
    }

    public void transferProperties(JRPropertiesHolder source, JRPropertiesHolder destination, String tranferPropertiesPrefix) {
        if (!source.hasProperties()) {
            return;
        }
        this.transfer(source.getPropertiesMap(), destination, tranferPropertiesPrefix);
    }

    public void transferProperties(JRPropertiesMap source, JRPropertiesHolder destination, String tranferPropertiesPrefix) {
        if (source == null || !source.hasProperties()) {
            return;
        }
        this.transfer(source, destination, tranferPropertiesPrefix);
    }

    public void transferProperties(JRPropertiesMap source, JRPropertiesHolder destination, List<String> propertyNames) {
        if (source == null || !source.hasProperties() || propertyNames == null || propertyNames.isEmpty()) {
            return;
        }
        JRPropertiesMap destinationProperties = destination.getPropertiesMap();
        for (String property : propertyNames) {
            String value = source.getProperty(property);
            destinationProperties.setProperty(property, value);
        }
    }

    protected void transfer(JRPropertiesMap source, JRPropertiesHolder destination, String tranferPropertiesPrefix) {
        List<PropertySuffix> transferPrefixProps = this.getProperties(tranferPropertiesPrefix);
        for (PropertySuffix transferPrefixProp : transferPrefixProps) {
            String transferPrefix = transferPrefixProp.getValue();
            if (transferPrefix == null || transferPrefix.length() <= 0) continue;
            List<PropertySuffix> transferProps = JRPropertiesUtil.getProperties(source, transferPrefix);
            for (PropertySuffix property : transferProps) {
                String value = property.getValue();
                destination.getPropertiesMap().setProperty(property.getKey(), value);
            }
        }
    }

    public Character getCharacterProperty(String key) {
        return JRPropertiesUtil.asCharacter(this.getProperty(key));
    }

    public Character getCharacterProperty(JRPropertiesHolder propertiesHolder, String key) {
        String value = this.getProperty(propertiesHolder, key);
        return JRPropertiesUtil.asCharacter(value);
    }

    public Character getCharacterProperty(JRPropertiesMap propertiesMap, String key) {
        String value = this.getProperty(propertiesMap, key);
        return JRPropertiesUtil.asCharacter(value);
    }

    public static Character asCharacter(String value) {
        return value == null || value.length() == 0 ? null : new Character(value.charAt(0));
    }

    public static String getOwnProperty(JRPropertiesHolder propertiesHolder, String key) {
        String value = null;
        if (propertiesHolder.hasProperties()) {
            value = propertiesHolder.getPropertiesMap().getProperty(key);
        }
        return value;
    }

    public static class PropertySuffix {
        protected final String key;
        protected final String suffix;
        protected final String value;

        public PropertySuffix(String key, String suffix, String value) {
            this.key = key;
            this.suffix = suffix;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public String getValue() {
            return this.value;
        }
    }
}

