/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.util.ElementsVisitorUtils;

public class JRFillElementGroup
implements JRElementGroup,
JRFillCloneable {
    protected List<JRChild> children = new ArrayList<JRChild>();
    protected JRElementGroup elementGroup;
    protected JRFillElement[] elements;
    private JRElement topElementInGroup;
    private JRElement bottomElementInGroup;
    private int stretchHeightDiff;

    protected JRFillElementGroup(JRElementGroup elementGrp, JRFillObjectFactory factory) {
        if (elementGrp != null) {
            factory.put(elementGrp, this);
            List<JRChild> list = elementGrp.getChildren();
            if (list != null && list.size() > 0) {
                int i = 0;
                while (i < list.size()) {
                    JRChild child = list.get(i);
                    child = (JRChild)factory.getVisitResult(child);
                    this.children.add(child);
                    ++i;
                }
            }
            this.getElements();
            this.elementGroup = (JRElementGroup)factory.getVisitResult(elementGrp.getElementGroup());
        }
    }

    protected JRFillElementGroup(JRFillElementGroup elementGrp, JRFillCloneFactory factory) {
        factory.put(elementGrp, this);
        List<JRChild> list = elementGrp.getChildren();
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                JRFillCloneable child = (JRFillCloneable)((Object)list.get(i));
                JRFillCloneable clone = child.createClone(factory);
                this.children.add((JRChild)((Object)clone));
                ++i;
            }
        }
        this.getElements();
        this.elementGroup = (JRFillElementGroup)factory.getClone((JRFillElementGroup)elementGrp.getElementGroup());
    }

    @Override
    public List<JRChild> getChildren() {
        return this.children;
    }

    @Override
    public JRElementGroup getElementGroup() {
        return this.elementGroup;
    }

    @Override
    public JRElement[] getElements() {
        if (this.elements == null && this.children != null) {
            ArrayList<JRElement> allElements = new ArrayList<JRElement>();
            JRChild child = null;
            JRElement[] childElementArray = null;
            int i = 0;
            while (i < this.children.size()) {
                child = this.children.get(i);
                if (child instanceof JRFillElement) {
                    allElements.add((JRElement)child);
                } else if (child instanceof JRFillElementGroup && (childElementArray = ((JRFillElementGroup)child).getElements()) != null) {
                    allElements.addAll(Arrays.asList(childElementArray));
                }
                ++i;
            }
            this.elements = new JRFillElement[allElements.size()];
            allElements.toArray(this.elements);
        }
        return this.elements;
    }

    @Override
    public JRElement getElementByKey(String key) {
        return null;
    }

    protected void reset() {
        this.topElementInGroup = null;
    }

    protected int getStretchHeightDiff() {
        if (this.topElementInGroup == null) {
            this.stretchHeightDiff = 0;
            this.setTopBottomElements();
            JRElement[] allElements = this.getElements();
            if (allElements != null && allElements.length > 0) {
                JRFillElement topElem = null;
                JRFillElement bottomElem = null;
                int i = 0;
                while (i < allElements.length) {
                    JRFillElement element = (JRFillElement)allElements[i];
                    if (element.isToPrint()) {
                        if (topElem == null || element.getRelativeY() + element.getStretchHeight() < topElem.getRelativeY() + topElem.getStretchHeight()) {
                            topElem = element;
                        }
                        if (bottomElem == null || element.getRelativeY() + element.getStretchHeight() > bottomElem.getRelativeY() + bottomElem.getStretchHeight()) {
                            bottomElem = element;
                        }
                    }
                    ++i;
                }
                if (topElem != null) {
                    this.stretchHeightDiff = bottomElem.getRelativeY() + bottomElem.getStretchHeight() - topElem.getRelativeY() - (this.bottomElementInGroup.getY() + this.bottomElementInGroup.getHeight() - this.topElementInGroup.getY());
                }
                if (this.stretchHeightDiff < 0) {
                    this.stretchHeightDiff = 0;
                }
            }
        }
        return this.stretchHeightDiff;
    }

    private void setTopBottomElements() {
        JRElement[] allElements = this.getElements();
        if (allElements != null && allElements.length > 0) {
            int i = 0;
            while (i < allElements.length) {
                if (this.topElementInGroup == null || allElements[i].getY() + allElements[i].getHeight() < this.topElementInGroup.getY() + this.topElementInGroup.getHeight()) {
                    this.topElementInGroup = allElements[i];
                }
                if (this.bottomElementInGroup == null || allElements[i].getY() + allElements[i].getHeight() > this.bottomElementInGroup.getY() + this.bottomElementInGroup.getHeight()) {
                    this.bottomElementInGroup = allElements[i];
                }
                ++i;
            }
        }
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitElementGroup(this);
        if (ElementsVisitorUtils.visitDeepElements(visitor)) {
            ElementsVisitorUtils.visitElements(visitor, this.children);
        }
    }

    @Override
    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        return new JRFillElementGroup(this, factory);
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object clone(JRElementGroup parentGroup) {
        throw new UnsupportedOperationException();
    }
}

