/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.olap;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mondrian.olap.Connection;
import mondrian.olap.Query;
import mondrian.olap.Result;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import net.sf.jasperreports.olap.JRMondrianDataSource;
import net.sf.jasperreports.olap.mondrian.JRMondrianResult;
import net.sf.jasperreports.olap.result.JROlapHierarchy;
import net.sf.jasperreports.olap.result.JROlapHierarchyLevel;
import net.sf.jasperreports.olap.result.JROlapMember;
import net.sf.jasperreports.olap.result.JROlapMemberTuple;
import net.sf.jasperreports.olap.result.JROlapResultAxis;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRMondrianQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog(JRMondrianQueryExecuter.class);
    private Connection connection = (Connection)this.getParameterValue("MONDRIAN_CONNECTION");
    private Result result;

    public JRMondrianQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        super(jasperReportsContext, dataset, parametersMap);
        if (this.connection == null) {
            log.warn((Object)"The supplied mondrian.olap.Connection object is null.");
        }
        this.parseQuery();
    }

    public JRMondrianQueryExecuter(JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        this(DefaultJasperReportsContext.getInstance(), dataset, parametersMap);
    }

    @Override
    protected String getCanonicalQueryLanguage() {
        return "MDX";
    }

    @Override
    protected String getParameterReplacement(String parameterName) {
        return String.valueOf(this.getParameterValue(parameterName));
    }

    @Override
    public JRDataSource createDatasource() throws JRException {
        JRMondrianDataSource dataSource = null;
        String queryStr = this.getQueryString();
        if (this.connection != null && queryStr != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("MDX query: " + queryStr));
            }
            Query query = this.connection.parseQuery(queryStr);
            this.result = this.connection.execute(query);
            this.logResult();
            dataSource = new JRMondrianDataSource(this.dataset, this.result);
        }
        return dataSource;
    }

    @Override
    public void close() {
        if (this.result != null) {
            this.result.close();
            this.result = null;
        }
    }

    @Override
    public boolean cancelQuery() throws JRException {
        return false;
    }

    public Result getResult() {
        return this.result;
    }

    protected void logResult() {
        if (!log.isDebugEnabled()) {
            return;
        }
        JRMondrianResult monResult = new JRMondrianResult(this.result);
        HashSet<String> measureNames = new HashSet<String>();
        ArrayList allLevelExpressions = new ArrayList();
        int axisCount = 0;
        int levelCount = 0;
        JROlapResultAxis[] jROlapResultAxisArray = monResult.getAxes();
        int n = jROlapResultAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            JROlapResultAxis axis = jROlapResultAxisArray[n2];
            log.debug((Object)("Axis: " + axisCount));
            String prefix = axisCount == 0 ? "Columns" : "Rows";
            JROlapHierarchy[] jROlapHierarchyArray = axis.getHierarchiesOnAxis();
            int n3 = jROlapHierarchyArray.length;
            int n4 = 0;
            while (n4 < n3) {
                JROlapHierarchy hier = jROlapHierarchyArray[n4];
                log.debug((Object)("\t Hierarchy: " + hier.getDimensionName() + " - " + hier.getHierarchyUniqueName()));
                log.debug((Object)"\t\tLevels");
                boolean foundMeasuresLevel = false;
                boolean emittedLevel = false;
                JROlapHierarchyLevel[] jROlapHierarchyLevelArray = hier.getLevels();
                int n5 = jROlapHierarchyLevelArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    JROlapHierarchyLevel level = jROlapHierarchyLevelArray[n6];
                    log.debug((Object)("\t\t\t" + (level == null ? "null" : String.valueOf(level.getName()) + ", depth: " + level.getDepth())));
                    if (level != null) {
                        if (level.getName().equalsIgnoreCase("MeasuresLevel")) {
                            foundMeasuresLevel = true;
                        } else {
                            emittedLevel = true;
                            String rowsExpression = String.valueOf(prefix) + this.makeOlapExpression(hier.getDimensionName()) + "[" + level.getName() + "]";
                            List<String> thisLevelExpressions = null;
                            if (levelCount >= allLevelExpressions.size()) {
                                thisLevelExpressions = new ArrayList();
                                allLevelExpressions.add(thisLevelExpressions);
                            } else {
                                thisLevelExpressions = (List)allLevelExpressions.get(levelCount);
                            }
                            thisLevelExpressions.add(rowsExpression);
                            log.debug((Object)("\t\t\t\t" + this.makeJRFieldName(String.valueOf(hier.getDimensionName()) + level.getName()) + "- " + rowsExpression));
                        }
                    }
                    ++n6;
                }
                if (emittedLevel) {
                    ++levelCount;
                }
                int i = 0;
                while (i < axis.getTupleCount()) {
                    JROlapMemberTuple memberTuple = axis.getTuple(i);
                    int j = 0;
                    while (j < memberTuple.getMembers().length) {
                        JROlapMember member = memberTuple.getMembers()[j];
                        if (foundMeasuresLevel && this.isMeasureMember(member.getUniqueName()) && !measureNames.contains(member.getUniqueName())) {
                            measureNames.add(member.getUniqueName());
                        }
                        ++j;
                    }
                    ++i;
                }
                ++n4;
            }
            ++axisCount;
            ++n2;
        }
        for (String measureName : measureNames) {
            log.debug((Object)("\t\t\t\t" + this.makeJRFieldName(measureName) + "- Data(" + measureName + ",?)"));
        }
    }

    private String makeJRFieldName(String s) {
        String out = s.replace(" ", "");
        out = out.replace("[", "");
        out = out.replace("]", "");
        out = out.replace("(", "");
        out = out.replace(")", "");
        out = out.replace(".", "");
        return out;
    }

    private String makeOlapExpression(String s) {
        String out = s.trim();
        int pos = out.indexOf("].[");
        if (pos != -1) {
            out = out.substring(pos + 2);
        }
        if (out.charAt(0) != '[') {
            out = "[" + out;
        }
        if (out.charAt(out.length() - 1) != ']') {
            out = String.valueOf(out) + "]";
        }
        return out;
    }

    private boolean isMeasureMember(String uniqueName) {
        return uniqueName.startsWith("[Measures].");
    }
}

