/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.search;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintElementId;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextUtil;
import net.sf.jasperreports.search.HitTermInfo;
import net.sf.jasperreports.search.LuceneSimpleAnalyzer;
import net.sf.jasperreports.search.LuceneSpansInfo;
import net.sf.jasperreports.search.SpansInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;

public class LuceneUtil {
    private static final Log log = LogFactory.getLog(LuceneUtil.class);
    private static final String CONTENT_FIELD = "content";
    private JRStyledTextAttributeSelector noneSelector;
    private JRStyledTextUtil styledTextUtil;
    private Analyzer analyzer;
    private IndexWriter writer;
    private FieldType fieldType;
    private boolean isCaseSensitive;
    private boolean isWholeWordsOnly;
    private boolean removeAccents;

    public LuceneUtil(JasperReportsContext jasperReportsContext, boolean isCaseSensitive, boolean isWholeWordsOnly, boolean removeAccents) {
        this.isCaseSensitive = isCaseSensitive;
        this.isWholeWordsOnly = isWholeWordsOnly;
        this.removeAccents = removeAccents;
        this.noneSelector = JRStyledTextAttributeSelector.getNoneSelector(jasperReportsContext);
        this.styledTextUtil = JRStyledTextUtil.getInstance(jasperReportsContext);
        this.fieldType = new FieldType();
        this.fieldType.setIndexed(true);
        this.fieldType.setTokenized(true);
        this.fieldType.setStored(true);
        this.fieldType.setStoreTermVectors(true);
        this.fieldType.setStoreTermVectorPositions(true);
        this.fieldType.setStoreTermVectorOffsets(true);
        this.fieldType.freeze();
    }

    public SpansInfo getSpansInfo(JasperPrint jasperPrint, String queryString) throws IOException, ParseException, JRException {
        Long start = System.currentTimeMillis();
        Directory dir = this.createLuceneDirectory(jasperPrint);
        if (log.isDebugEnabled()) {
            log.debug((Object)("original query: [" + queryString + "]"));
        }
        DirectoryReader reader = DirectoryReader.open((Directory)dir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        List<String> queryTerms = this.getQueryTerms(queryString);
        SpanNearQuery query = this.buildQuery(queryTerms);
        if (log.isDebugEnabled()) {
            log.debug((Object)("lucene query: [" + query.toString() + "]"));
        }
        TopDocs results = searcher.search((Query)query, Integer.MAX_VALUE);
        ScoreDoc[] hits = results.scoreDocs;
        LinkedHashMap<Integer, List<Term>> hitTermsMap = new LinkedHashMap<Integer, List<Term>>();
        int i = 0;
        while (i < hits.length) {
            this.getHitTerms((Query)query, searcher, hits[i].doc, hitTermsMap);
            ++i;
        }
        HashMap<Term, TermContext> termContexts = new HashMap<Term, TermContext>();
        HashMap hitTermsInfoMap = new HashMap();
        for (Map.Entry entry : hitTermsMap.entrySet()) {
            List terms = (List)entry.getValue();
            Terms termVector = reader.getTermVector(((Integer)entry.getKey()).intValue(), CONTENT_FIELD);
            for (Term term : terms) {
                termContexts.put(term, TermContext.build((IndexReaderContext)reader.getContext(), (Term)term));
                TermsEnum iterator = termVector.iterator(TermsEnum.EMPTY);
                BytesRef termBytesRef = new BytesRef((CharSequence)term.text());
                if (!iterator.seekExact(termBytesRef)) continue;
                DocsAndPositionsEnum docsAndPositions = iterator.docsAndPositions(null, null);
                docsAndPositions.nextDoc();
                int i2 = 0;
                int freq = docsAndPositions.freq();
                while (i2 < freq) {
                    if (hitTermsInfoMap.get(entry.getKey()) == null) {
                        hitTermsInfoMap.put((Integer)entry.getKey(), new ArrayList());
                    }
                    ((List)hitTermsInfoMap.get(entry.getKey())).add(new HitTermInfo(docsAndPositions.nextPosition(), docsAndPositions.startOffset(), docsAndPositions.endOffset(), termBytesRef.utf8ToString()));
                    ++i2;
                }
            }
        }
        AtomicReaderContext context = (AtomicReaderContext)reader.leaves().get(0);
        Bits acceptDocs = context.reader().getLiveDocs();
        SpanQuery rewrittenQuery = (SpanQuery)query.rewrite((IndexReader)reader);
        Spans spans = rewrittenQuery.getSpans(context, acceptDocs, termContexts);
        LuceneSpansInfo spansInfo = new LuceneSpansInfo(queryTerms.size());
        while (spans.next()) {
            Document doc = searcher.doc(spans.doc());
            String uid = doc.get("uid");
            List hitTermsInfo = (List)hitTermsInfoMap.get(spans.doc());
            int i3 = spans.start();
            while (i3 < spans.end()) {
                for (HitTermInfo ti : hitTermsInfo) {
                    if (ti.getPosition() != i3) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("term: %s@%d [%d, %d] - uid: %s, pageNo: %s", ti.getValue(), ti.getPosition(), ti.getStart(), ti.getEnd(), uid, doc.get("pageNo")));
                    }
                    ti.setPageNo(doc.get("pageNo"));
                    spansInfo.addTermInfo(uid, ti);
                }
                ++i3;
            }
        }
        reader.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)("search took: " + (System.currentTimeMillis() - start) + " ms"));
        }
        return spansInfo;
    }

    protected Directory createLuceneDirectory(JasperPrint jasperPrint) throws IOException, JRException {
        Long start = System.currentTimeMillis();
        RAMDirectory dir = new RAMDirectory();
        Analyzer analyzer = this.getConfiguredAnalyzer();
        IndexWriterConfig iwc = new IndexWriterConfig(Version.LUCENE_45, analyzer);
        iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        this.writer = new IndexWriter((Directory)dir, iwc);
        List<JRPrintPage> pages = jasperPrint.getPages();
        if (pages != null && pages.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("there are " + pages.size() + " pages to be indexed"));
            }
            int i = 0;
            int ps = pages.size();
            while (i < ps) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("indexing page: " + i));
                }
                this.indexPage(pages.get(i), i);
                ++i;
            }
        }
        this.writer.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)("index creation took: " + (System.currentTimeMillis() - start) + " ms"));
        }
        return dir;
    }

    protected void indexPage(JRPrintPage page, int pageNo) throws IOException {
        List<JRPrintElement> elements = page.getElements();
        if (page.getElements().size() > 0) {
            this.indexElements(pageNo, elements);
        }
    }

    protected void indexElements(int pageNo, List<JRPrintElement> elements) throws IOException {
        int i = 0;
        while (i < elements.size()) {
            JRPrintElement element = elements.get(i);
            if (element instanceof JRPrintText) {
                this.addContentField(pageNo, (JRPrintText)element);
            } else if (element instanceof JRPrintFrame) {
                JRPrintFrame frame = (JRPrintFrame)element;
                this.indexElements(pageNo, frame.getElements());
            }
            ++i;
        }
    }

    protected void addContentField(int pageNo, JRPrintText element) throws IOException {
        JRStyledText styledText = this.getStyledText(element);
        String allText = styledText == null ? "" : styledText.getText();
        if (allText != null && allText.length() > 0) {
            Field tf = new Field(CONTENT_FIELD, allText, this.fieldType);
            Document doc = new Document();
            doc.add((IndexableField)new IntField("pageNo", pageNo, Field.Store.YES));
            PrintElementId peid = PrintElementId.forElement(element);
            doc.add((IndexableField)new StringField("uid", peid.toString(), Field.Store.YES));
            this.displayTokens(allText, peid.toString());
            doc.add((IndexableField)tf);
            this.writer.addDocument((Iterable)doc);
        }
    }

    protected Analyzer getConfiguredAnalyzer() {
        if (this.analyzer == null) {
            this.analyzer = new LuceneSimpleAnalyzer(Version.LUCENE_45, this.isCaseSensitive, this.removeAccents);
        }
        return this.analyzer;
    }

    protected JRStyledText getStyledText(JRPrintText textElement) {
        return this.styledTextUtil.getStyledText(textElement, this.noneSelector);
    }

    protected SpanNearQuery buildQuery(List<String> queryTerms) {
        SpanNearQuery query = null;
        ArrayList<Object> clauses = new ArrayList<Object>();
        int i = 0;
        int ln = queryTerms.size();
        while (i < ln) {
            String term = queryTerms.get(i);
            if (this.isWholeWordsOnly) {
                clauses.add(new SpanTermQuery(new Term(CONTENT_FIELD, term)));
            } else {
                if (i == 0) {
                    term = "*" + term;
                }
                if (i == ln - 1) {
                    term = String.valueOf(term) + "*";
                }
                clauses.add(new SpanMultiTermQueryWrapper((MultiTermQuery)new WildcardQuery(new Term(CONTENT_FIELD, term))));
            }
            ++i;
        }
        if (clauses.size() > 0) {
            query = new SpanNearQuery(clauses.toArray(new SpanQuery[0]), 0, true);
        }
        return query;
    }

    protected List<String> getQueryTerms(String queryString) throws IOException {
        ArrayList<String> queryTerms = new ArrayList<String>();
        Analyzer analyzer = this.getConfiguredAnalyzer();
        TokenStream tokenStream = analyzer.tokenStream(null, queryString);
        CharTermAttribute charTermAttribute = (CharTermAttribute)tokenStream.addAttribute(CharTermAttribute.class);
        tokenStream.reset();
        while (tokenStream.incrementToken()) {
            queryTerms.add(charTermAttribute.toString());
        }
        return queryTerms;
    }

    protected void displayTokens(String text, String elementId) throws IOException {
        if (log.isDebugEnabled()) {
            Analyzer analyzer = this.getConfiguredAnalyzer();
            StringBuilder sb = new StringBuilder();
            sb.append(elementId).append(": ").append(text).append(": ");
            TokenStream tokenStream = analyzer.tokenStream(null, (Reader)new StringReader(text));
            CharTermAttribute charTermAttribute = (CharTermAttribute)tokenStream.addAttribute(CharTermAttribute.class);
            OffsetAttribute offsetAttribute = (OffsetAttribute)tokenStream.addAttribute(OffsetAttribute.class);
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                int startOffset = offsetAttribute.startOffset();
                int endOffset = offsetAttribute.endOffset();
                String term = charTermAttribute.toString();
                sb.append("[" + term + "](" + startOffset + "," + endOffset + ") ");
            }
            log.debug((Object)sb);
        }
    }

    protected void getHitTerms(Query query, IndexSearcher searcher, int docId, Map<Integer, List<Term>> hitTerms) throws IOException {
        if (query instanceof SpanTermQuery) {
            if (searcher.explain(query, docId).isMatch()) {
                if (!hitTerms.containsKey(docId)) {
                    hitTerms.put(docId, new ArrayList());
                }
                hitTerms.get(docId).add(((SpanTermQuery)query).getTerm());
            }
            return;
        }
        if (query instanceof MultiTermQuery) {
            if (!(query instanceof FuzzyQuery)) {
                ((MultiTermQuery)query).setRewriteMethod(MultiTermQuery.SCORING_BOOLEAN_QUERY_REWRITE);
            }
            this.getHitTerms(query.rewrite(searcher.getIndexReader()), searcher, docId, hitTerms);
            return;
        }
        if (query instanceof SpanNearQuery) {
            SpanQuery[] spanQueryArray = ((SpanNearQuery)query).getClauses();
            int n = spanQueryArray.length;
            int n2 = 0;
            while (n2 < n) {
                SpanQuery bc = spanQueryArray[n2];
                this.getHitTerms((Query)bc, searcher, docId, hitTerms);
                ++n2;
            }
            return;
        }
        if (query instanceof SpanOrQuery) {
            SpanQuery[] spanQueryArray = ((SpanOrQuery)query).getClauses();
            int n = spanQueryArray.length;
            int n3 = 0;
            while (n3 < n) {
                SpanQuery bc = spanQueryArray[n3];
                this.getHitTerms((Query)bc, searcher, docId, hitTerms);
                ++n3;
            }
            return;
        }
        if (query instanceof SpanMultiTermQueryWrapper) {
            ((SpanMultiTermQueryWrapper)query).setRewriteMethod(SpanMultiTermQueryWrapper.SCORING_SPAN_QUERY_REWRITE);
            this.getHitTerms(query.rewrite(searcher.getIndexReader()), searcher, docId, hitTerms);
            return;
        }
    }
}

