/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import mondrian.olap.Annotated;
import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.MatchType;
import mondrian.olap.MondrianProperties;
import mondrian.olap.OlapElement;
import mondrian.olap.OlapElementBase;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;

public abstract class HierarchyBase
extends OlapElementBase
implements Hierarchy {
    protected final Dimension dimension;
    protected final String subName;
    protected final String name;
    protected final String uniqueName;
    protected String description;
    protected Level[] levels;
    protected final boolean hasAll;
    protected String allMemberName;
    protected String allLevelName;

    protected HierarchyBase(Dimension dimension, String subName, String caption, String description, boolean hasAll) {
        this.dimension = dimension;
        this.hasAll = hasAll;
        this.caption = caption != null ? caption : (subName == null ? dimension.getCaption() : subName);
        this.description = description;
        String name = dimension.getName();
        if (MondrianProperties.instance().SsasCompatibleNaming.get()) {
            if (subName == null) {
                subName = name;
            }
            this.subName = subName;
            this.name = subName;
            this.uniqueName = subName.equals(name) ? dimension.getUniqueName() : Util.makeFqName(dimension, this.name);
        } else {
            this.subName = subName;
            if (this.subName != null) {
                this.name = name + "." + subName;
                this.uniqueName = this.subName.equals(name) ? dimension.getUniqueName() : Util.makeFqName(this.name);
            } else {
                this.name = name;
                this.uniqueName = dimension.getUniqueName();
            }
        }
    }

    public String getSubName() {
        return this.subName;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        return MondrianResource.instance().MdxHierarchyName.str(this.getUniqueName());
    }

    public abstract boolean isRagged();

    public String getDescription() {
        return this.description;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public Level[] getLevels() {
        return this.levels;
    }

    public Hierarchy getHierarchy() {
        return this;
    }

    public boolean hasAll() {
        return this.hasAll;
    }

    public boolean equals(OlapElement mdxElement) {
        return this == mdxElement;
    }

    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment s, MatchType matchType) {
        Annotated oe = Util.lookupHierarchyLevel(this, s.name);
        if (oe == null) {
            oe = Util.lookupHierarchyRootMember(schemaReader, this, s, matchType);
        }
        if (this.getLogger().isDebugEnabled()) {
            StringBuilder buf = new StringBuilder(64);
            buf.append("HierarchyBase.lookupChild: ");
            buf.append("name=");
            buf.append(this.getName());
            buf.append(", childname=");
            buf.append(s);
            if (oe == null) {
                buf.append(" returning null");
            } else {
                buf.append(" returning elementname=").append(oe.getName());
            }
            this.getLogger().debug((Object)buf.toString());
        }
        return oe;
    }

    public String getAllMemberName() {
        return this.allMemberName;
    }

    public String getAllLevelName() {
        return this.allLevelName;
    }
}

