/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.rolap.RolapCalculation;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapEvaluatorRoot;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapMember;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RolapTupleCalculation
implements RolapCalculation {
    private final List<RolapHierarchy> hierarchyList;
    private final Calc calc;

    public RolapTupleCalculation(List<RolapHierarchy> hierarchyList, Calc calc) {
        this.hierarchyList = hierarchyList;
        this.calc = calc;
    }

    @Override
    public RolapEvaluator pushSelf(RolapEvaluator evaluator) {
        RolapEvaluator evaluator2 = evaluator.push();
        for (RolapHierarchy hierarchy : this.hierarchyList) {
            int ordinal = hierarchy.getOrdinalInCube();
            RolapMember defaultMember = evaluator.root.defaultMembers[ordinal];
            evaluator2.setContext(defaultMember);
        }
        evaluator2.removeCalcMember(this);
        return evaluator2;
    }

    @Override
    public int getSolveOrder() {
        return Integer.MIN_VALUE;
    }

    @Override
    public int getHierarchyOrdinal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Calc getCompiledExpression(RolapEvaluatorRoot root) {
        return this.calc;
    }

    @Override
    public boolean containsAggregateFunction() {
        return false;
    }

    @Override
    public boolean isCalculatedInQuery() {
        return true;
    }
}

