/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import mondrian.rolap.CellKey;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.agg.DenseSegmentDataset;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.agg.SegmentDataset;
import mondrian.rolap.agg.SegmentLoader;

class DenseObjectSegmentDataset
extends DenseSegmentDataset {
    private final Object[] values;

    DenseObjectSegmentDataset(Segment segment, int size) {
        super(segment);
        this.values = new Object[size];
    }

    public Object getObject(CellKey key) {
        int offset = key.getOffset(this.axisMultipliers);
        return this.values[offset];
    }

    public boolean isNull(CellKey pos) {
        return this.getObject(pos) != null;
    }

    public boolean exists(CellKey pos) {
        return this.getObject(pos) != null;
    }

    public void populateFrom(int[] pos, SegmentDataset data, CellKey key) {
        this.values[this.getOffset((int[])pos)] = data.getObject(key);
    }

    public void populateFrom(int[] pos, SegmentLoader.RowList rowList, int column) {
        int offset = this.getOffset(pos);
        this.values[offset] = rowList.getObject(column);
    }

    public SqlStatement.Type getType() {
        return SqlStatement.Type.OBJECT;
    }

    public void put(CellKey key, Object value) {
        int offset = key.getOffset(this.axisMultipliers);
        this.values[offset] = value;
    }

    protected int size() {
        return this.values.length;
    }

    protected Object getObject(int i) {
        return this.values[i];
    }
}

