/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.list;

import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.designer.widgets.JRDesignElementWidget;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import net.sf.jasperreports.components.list.DesignListContents;
import net.sf.jasperreports.components.list.ListComponent;
import net.sf.jasperreports.components.list.StandardListComponent;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignElement;

public class JRListComponentWidget
extends JRDesignElementWidget {
    private static final BasicStroke DOTTED_LINE = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{2.0f}, 0.0f);
    private Image chartImage = null;

    public JRListComponentWidget(AbstractReportObjectScene scene, JRDesignElement element) {
        super(scene, element);
        if (((JRDesignComponentElement)element).getComponent() instanceof ListComponent) {
            ListComponent c = (ListComponent)((JRDesignComponentElement)element).getComponent();
            DesignListContents contents = (DesignListContents)c.getContents();
            contents.getEventSupport().addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        PropertyChangeListener pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ListComponent c = (ListComponent)((JRDesignComponentElement)JRListComponentWidget.this.getElement()).getComponent();
                DesignListContents contents = (DesignListContents)c.getContents();
                contents.setHeight(JRListComponentWidget.this.getElement().getHeight());
                contents.setWidth(JRListComponentWidget.this.getElement().getWidth());
            }
        };
        this.getElement().getEventSupport().addPropertyChangeListener("height", pcl);
        this.getElement().getEventSupport().addPropertyChangeListener("width", pcl);
    }

    protected void paintWidgetImplementation() {
        super.paintWidgetImplementation();
        Graphics2D gr = this.getScene().getGraphics();
        Rectangle r = this.getPreferredBounds();
        AffineTransform af = gr.getTransform();
        AffineTransform new_af = (AffineTransform)af.clone();
        AffineTransform translate = AffineTransform.getTranslateInstance(this.getBorder().getInsets().left + r.x, this.getBorder().getInsets().top + r.y);
        new_af.concatenate(translate);
        gr.setTransform(new_af);
        JRDesignElement element = this.getElement();
        StandardListComponent component = (StandardListComponent)((JRDesignComponentElement)this.getElement()).getComponent();
        Shape oldClip = gr.getClip();
        Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, element.getWidth(), element.getHeight());
        Stroke oldStroke = gr.getStroke();
        gr.clip(rect);
        gr.setStroke(DOTTED_LINE);
        gr.setColor(ReportObjectScene.DESIGN_LINE_COLOR);
        gr.drawLine(0, component.getContents().getHeight(), element.getWidth(), component.getContents().getHeight());
        if (component.getContents().getWidth() != null && component.getContents().getWidth() != 0) {
            gr.drawLine(component.getContents().getWidth(), 0, component.getContents().getWidth(), element.getHeight());
        }
        gr.setClip(oldClip);
        gr.setStroke(oldStroke);
        gr.setTransform(af);
    }

    public Image getChartImage() {
        if (this.chartImage == null) {
            this.chartImage = Misc.loadImageFromResources((String)"/com/jaspersoft/ireport/components/list/component.png", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        }
        return this.chartImage;
    }

    public List getChildrenElements() {
        JRDesignComponentElement component = (JRDesignComponentElement)this.getElement();
        if (component.getComponent() instanceof ListComponent) {
            ListComponent c = (ListComponent)component.getComponent();
            DesignListContents contents = (DesignListContents)c.getContents();
            return contents.getChildren();
        }
        return null;
    }

    public void addElement(JRDesignElement element) {
        JRDesignComponentElement component = (JRDesignComponentElement)this.getElement();
        if (component.getComponent() instanceof ListComponent) {
            ListComponent c = (ListComponent)component.getComponent();
            DesignListContents contents = (DesignListContents)c.getContents();
            contents.addElement(element);
        }
    }
}

