/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver;

import com.jaspersoft.ireport.jasperserver.JServer;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.SimpleFileResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFileResolver
extends SimpleFileResolver {
    JServer server = null;
    JasperDesign jasperDesign = null;
    String reportUnitUri = null;
    List<ResourceDescriptor> reportUnitResources = null;

    public JSFileResolver(File parentFolder, JServer server, JasperDesign jasperDesign) {
        this(Arrays.asList(parentFolder), server, jasperDesign);
    }

    public JSFileResolver(List<File> parentFolders, JServer server, JasperDesign jasperDesign) {
        super(parentFolders);
        this.server = server;
        this.jasperDesign = jasperDesign;
        this.setResolveAbsolutePath(true);
        if (jasperDesign.getProperty("ireport.jasperserver.reportUnit") != null) {
            this.reportUnitUri = jasperDesign.getProperty("ireport.jasperserver.reportUnit");
        }
    }

    public File resolveFile(String fileName) {
        if (fileName.startsWith("repo:")) {
            String objectUri = fileName.substring(5);
            try {
                if (!objectUri.contains("/") && this.reportUnitUri != null) {
                    if (this.reportUnitResources == null) {
                        ResourceDescriptor rd = new ResourceDescriptor();
                        rd.setWsType("reportUnit");
                        rd.setUriString(this.reportUnitUri);
                        rd = this.server.getWSClient().get(rd, null);
                        this.reportUnitResources = this.server.getWSClient().list(rd);
                        if (this.reportUnitResources == null) {
                            this.reportUnitResources = new ArrayList<ResourceDescriptor>();
                        }
                    }
                    for (ResourceDescriptor resource : this.reportUnitResources) {
                        if (!resource.getName().equals(objectUri) || !resource.getWsType().equals("img") && !resource.getWsType().equals("prop") && !resource.getWsType().equals("jrtx")) continue;
                        String resolvedFileName = JasperServerManager.createTmpFileName(null, resource.getName());
                        File resolvedFile = new File(resolvedFileName);
                        this.server.getWSClient().get(resource, resolvedFile);
                        return resolvedFile;
                    }
                    System.out.println("Resource " + objectUri + " not found in the JasperServer Report at " + this.reportUnitUri);
                }
            }
            catch (Exception ex) {
                System.out.println("Unable to resolve " + objectUri + " on " + this.server.getName() + "server ( " + ex.getMessage() + ")");
            }
        }
        return super.resolveFile(fileName);
    }
}

