/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.inputcontrols.impl;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.compiler.prompt.DateRangeDatePicker;
import com.jaspersoft.ireport.jasperserver.ui.inputcontrols.impl.InputControlUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class DateTimeInputControlUI
extends JPanel
implements InputControlUI {
    private JLabel jLabelH;
    private JLabel jLabelMin;
    private JLabel jLabelName;
    private JLabel jLabelSec;
    private JSpinner jSpinnerH;
    private JSpinner jSpinnerM;
    private JSpinner jSpinnerS;
    private DateRangeDatePicker dateRangePicker;

    public DateTimeInputControlUI() {
        this.initComponents();
        this.jSpinnerH.setModel(new SpinnerNumberModel(0, 0, 23, 1));
        this.jSpinnerM.setModel(new SpinnerNumberModel(0, 0, 59, 1));
        this.jSpinnerS.setModel(new SpinnerNumberModel(0, 0, 59, 1));
    }

    public Object getValue() {
        if (IReportManager.getPreferences().getBoolean("jasperserver.useRelativeDateExpressions", true) && this.dateRangePicker.getDateRangeExpression() != null) {
            return this.dateRangePicker.getDateRangeExpression();
        }
        Date date = this.dateRangePicker.getDate();
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        gc.set(10, ((Number)this.jSpinnerH.getValue()).intValue());
        gc.set(12, ((Number)this.jSpinnerH.getValue()).intValue());
        gc.set(13, ((Number)this.jSpinnerH.getValue()).intValue());
        return gc.getTime();
    }

    public void setValue(Object v) {
        if (v == null) {
            return;
        }
        if (v instanceof Date) {
            this.dateRangePicker.setDate((Date)v);
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime((Date)v);
            this.jSpinnerH.setValue(gc.get(10));
            this.jSpinnerM.setValue(gc.get(12));
            this.jSpinnerS.setValue(gc.get(13));
        }
        if (v instanceof String) {
            this.dateRangePicker.setDateRangeExpression((String)v);
        }
    }

    private void initComponents() {
        this.jLabelName = new JLabel();
        this.dateRangePicker = new DateRangeDatePicker();
        this.jLabelH = new JLabel();
        this.jSpinnerH = new JSpinner();
        this.jLabelMin = new JLabel();
        this.jSpinnerM = new JSpinner();
        this.jLabelSec = new JLabel();
        this.jSpinnerS = new JSpinner();
        this.setPreferredSize(new Dimension(250, 40));
        this.setLayout(new GridBagLayout());
        this.jLabelName.setText("jLabel1");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.jLabelName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 14, 0, 4);
        this.add((Component)this.dateRangePicker, gridBagConstraints);
        this.jLabelH.setText("Time");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.add((Component)this.jLabelH, gridBagConstraints);
        this.jSpinnerH.setMinimumSize(new Dimension(35, 18));
        this.jSpinnerH.setPreferredSize(new Dimension(35, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        this.add((Component)this.jSpinnerH, gridBagConstraints);
        this.jLabelMin.setText(":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.jLabelMin, gridBagConstraints);
        this.jSpinnerM.setMinimumSize(new Dimension(35, 18));
        this.jSpinnerM.setPreferredSize(new Dimension(35, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        this.add((Component)this.jSpinnerM, gridBagConstraints);
        this.jLabelSec.setText(":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.jLabelSec, gridBagConstraints);
        this.jSpinnerS.setMinimumSize(new Dimension(35, 18));
        this.jSpinnerS.setPreferredSize(new Dimension(35, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        this.add((Component)this.jSpinnerS, gridBagConstraints);
    }

    public void setLabel(String lbl) {
        this.jLabelName.setText(lbl);
    }

    public void setHistory(List values) {
    }

    public void setReadOnly(boolean b) {
        this.jLabelName.setEnabled(!b);
        this.dateRangePicker.setEnabled(!b);
    }

    public void addActionListener(ActionListener listener) {
        this.dateRangePicker.addActionListener(listener);
    }
}

